/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HllUnion$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(first, second, allowDifferentLgConfigK) - Merges two binary representations of\n    Datasketches HllSketch objects, using a Datasketches Union object. Set\n    allowDifferentLgConfigK to true to allow unions of sketches with different\n    lgConfigK values (defaults to false). ", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(hll_sketch_agg(col1), hll_sketch_agg(col2))) FROM VALUES (1, 4), (1, 4), (2, 5), (2, 5), (3, 6) tab(col1, col2);\n       6\n  ", group="sketch_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u000b\t\u0004A\u0011I2\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1\u0011\u000f\u0001Q\u0001\n%DQ\u0001\u0018\u0001\u0005\u0002IDQ\u0001\u0018\u0001\u0005\u0002UDQ!\u001f\u0001\u0005RiDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011q\u0007\u0001\u0005B\u0005e\u0002\"CA'\u0001\u0005\u0005I\u0011AA(\u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0005\u0002p\u0001\t\n\u0011\"\u0001\u0002Z!I\u0011\u0011\u000f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003g\u0002\u0011\u0011!C!\u0003kB\u0011\"!\"\u0001\u0003\u0003%\t!a\"\t\u0013\u0005=\u0005!!A\u0005\u0002\u0005E\u0005\"CAL\u0001\u0005\u0005I\u0011IAM\u0011%\t9\u000bAA\u0001\n\u0003\tI\u000bC\u0005\u0002.\u0002\t\t\u0011\"\u0011\u00020\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0013QW\u0004\n\u00033,\u0013\u0011!E\u0001\u000374\u0001\u0002J\u0013\u0002\u0002#\u0005\u0011Q\u001c\u0005\u00079z!\t!!>\t\u0013\u0005]h$!A\u0005F\u0005e\b\"CA~=\u0005\u0005I\u0011QA\u007f\u0011%\u0011)AHA\u0001\n\u0003\u00139\u0001C\u0005\u0003\u001ay\t\t\u0011\"\u0003\u0003\u001c\tA\u0001\n\u001c7V]&|gN\u0003\u0002'O\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tA\u0013&\u0001\u0005dCR\fG._:u\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0019\u00011gN\u001fA\rB\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e&\u0003\u001d\u0019w\u000eZ3hK:L!\u0001P\u001d\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"\u0001\u000e \n\u0005}*#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA$P\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002Lc\u00051AH]8pizJ\u0011aQ\u0005\u0003\u001d\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002Q#\na1+\u001a:jC2L'0\u00192mK*\u0011aJQ\u0001\u0006M&\u00148\u000f^\u000b\u0002)B\u0011A'V\u0005\u0003-\u0016\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u00191\u0017N]:uA\u000511/Z2p]\u0012\fqa]3d_:$\u0007%A\u0003uQ&\u0014H-\u0001\u0004uQ&\u0014H\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\ty{\u0006-\u0019\t\u0003i\u0001AQAU\u0004A\u0002QCQ\u0001W\u0004A\u0002QCQAW\u0004A\u0002Q\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001e!\t\tU-\u0003\u0002g\u0005\n9!i\\8mK\u0006t\u0017A\u0003;be\u001e,G\u000fV=qKV\t\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006\u0019\u0001\u000e\u001c7\u000b\u00059l\u0013\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018B\u00019l\u0005)!v\r\u001e%mYRK\b/Z\u0001\fi\u0006\u0014x-\u001a;UsB,\u0007\u0005F\u0002_gRDQAU\u0006A\u0002QCQ\u0001W\u0006A\u0002Q#BA\u0018<xq\")!\u000b\u0004a\u0001)\")\u0001\f\u0004a\u0001)\")!\f\u0004a\u0001I\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0005=nlx\u0010C\u0003}\u001b\u0001\u0007A+\u0001\u0005oK^4\u0015N]:u\u0011\u0015qX\u00021\u0001U\u0003%qWm^*fG>tG\r\u0003\u0004\u0002\u00025\u0001\r\u0001V\u0001\t]\u0016<H\u000b[5sI\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003#qA!a\u0003\u0002\u000eA\u0011\u0011JQ\u0005\u0004\u0003\u001f\u0011\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u0010\t\u000b!\"\u001b8qkR$\u0016\u0010]3t+\t\tY\u0002E\u0003H\u0003;\t\t#C\u0002\u0002 E\u00131aU3r!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014S\u0005)A/\u001f9fg&!\u00111FA\u0013\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t\t\u0004\u0005\u0003\u0002$\u0005M\u0012\u0002BA\u001b\u0003K\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003w\t\t%!\u0012\u0002JA\u0019\u0011)!\u0010\n\u0007\u0005}\"IA\u0002B]fDq!a\u0011\u0012\u0001\u0004\tY$\u0001\u0004wC2,X-\r\u0005\b\u0003\u000f\n\u0002\u0019AA\u001e\u0003\u00191\u0018\r\\;fe!9\u00111J\tA\u0002\u0005m\u0012A\u0002<bYV,7'\u0001\u0003d_BLHc\u00020\u0002R\u0005M\u0013Q\u000b\u0005\b%J\u0001\n\u00111\u0001U\u0011\u001dA&\u0003%AA\u0002QCqA\u0017\n\u0011\u0002\u0003\u0007A+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m#f\u0001+\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j\t\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005!A.\u00198h\u0015\t\t\t)\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003w\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!#\u0011\u0007\u0005\u000bY)C\u0002\u0002\u000e\n\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000f\u0002\u0014\"I\u0011Q\u0013\r\u0002\u0002\u0003\u0007\u0011\u0011R\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0005CBAO\u0003G\u000bY$\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0006}%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001ZAV\u0011%\t)JGA\u0001\u0002\u0004\tY$\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA<\u0003cC\u0011\"!&\u001c\u0003\u0003\u0005\r!!#\u0002\r\u0015\fX/\u00197t)\r!\u0017q\u0017\u0005\n\u0003+c\u0012\u0011!a\u0001\u0003wA3\u0003AA^\u0003\u0003\f\u0019-a2\u0002J\u00065\u0017qZAj\u0003+\u00042\u0001NA_\u0013\r\ty,\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)-\u0001B \u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b4jeN$H\u0006I:fG>tG\r\f\u0011bY2|w\u000fR5gM\u0016\u0014XM\u001c;MO\u000e{gNZ5h\u0017&\u0002S\u0006I'fe\u001e,7\u000f\t;x_\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:\u001c\be\u001c4\u000bA\u0001\u0002\u0003\u0005R1uCN\\W\r^2iKN\u0004\u0003\n\u001c7TW\u0016$8\r\u001b\u0011pE*,7\r^:-AU\u001c\u0018N\\4!C\u0002\"\u0015\r^1tW\u0016$8\r[3tAUs\u0017n\u001c8!_\nTWm\u0019;/AM+GO\u0003\u0011!A\u0001\nG\u000e\\8x\t&4g-\u001a:f]RdumQ8oM&<7\n\t;pAQ\u0014X/\u001a\u0011u_\u0002\nG\u000e\\8xAUt\u0017n\u001c8tA=4\u0007e]6fi\u000eDWm\u001d\u0011xSRD\u0007\u0005Z5gM\u0016\u0014XM\u001c;\u000bA\u0001\u0002\u0003\u0005\\4D_:4\u0017nZ&!m\u0006dW/Z:!Q\u0011,g-Y;miN\u0004Co\u001c\u0011gC2\u001cX-\u000b\u0018!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAf\u0003\u0005-$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t5mY~\u001b8.\u001a;dQ~+7\u000f^5nCR,\u0007f\u0018$V\u001d\u000e{\u0006\u0006\u001b7m?N\\W\r^2i?\u0006<w\rK2pYFJC\u0006\t5mY~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2\u0014\u0014&K\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152Y\u0001\"\u0014\u0006\f\u0011)c1\u0002C'\u000b\u0017!QIb\u0003%N\u0015-A!\u0012D\u0006I\u001b*Y\u0001B3\u0007\f\u00117S\u0001\"\u0018M\u0019\u0015d_2\fD\u0006I2pYJJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001c\u000bA\u0001\nQa\u001a:pkB\f#!!5\u0002\u0019M\\W\r^2i?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005]\u0017!B\u001a/k9\u0002\u0014\u0001\u0003%mYVs\u0017n\u001c8\u0011\u0005Qr2#\u0002\u0010\u0002`\u0006-\b\u0003CAq\u0003O$F\u000b\u00160\u000e\u0005\u0005\r(bAAs\u0005\u00069!/\u001e8uS6,\u0017\u0002BAu\u0003G\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\ti/a=\u000e\u0005\u0005=(\u0002BAy\u0003\u007f\n!![8\n\u0007A\u000by\u000f\u0006\u0002\u0002\\\u0006AAo\\*ue&tw\r\u0006\u0002\u0002x\u0005)\u0011\r\u001d9msR9a,a@\u0003\u0002\t\r\u0001\"\u0002*\"\u0001\u0004!\u0006\"\u0002-\"\u0001\u0004!\u0006\"\u0002.\"\u0001\u0004!\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0013\u0011)\u0002E\u0003B\u0005\u0017\u0011y!C\u0002\u0003\u000e\t\u0013aa\u00149uS>t\u0007CB!\u0003\u0012Q#F+C\u0002\u0003\u0014\t\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\fE\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u001eA!\u0011\u0011\u0010B\u0010\u0013\u0011\u0011\t#a\u001f\u0003\r=\u0013'.Z2u\u0001")
public class HllUnion
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression first;
    private final Expression second;
    private final Expression third;
    private final TgtHllType targetType;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(HllUnion x$0) {
        return HllUnion$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, HllUnion> tupled() {
        return HllUnion$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, HllUnion>>> curried() {
        return HllUnion$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression first() {
        return this.first;
    }

    @Override
    public Expression second() {
        return this.second;
    }

    @Override
    public Expression third() {
        return this.third;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllUnion withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    @Override
    public String prettyName() {
        return "hll_union";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object value1, Object value2, Object value3) {
        HllSketch hllSketch;
        HllSketch hllSketch2;
        try {
            hllSketch2 = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])value1)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SketchesArgumentException ? true : (throwable2 instanceof Error ? true : throwable2 instanceof ArrayIndexOutOfBoundsException)) {
                throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
            }
            throw throwable;
        }
        HllSketch sketch1 = hllSketch2;
        try {
            hllSketch = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])value2)));
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (throwable3 instanceof SketchesArgumentException ? true : (throwable3 instanceof Error ? true : throwable3 instanceof ArrayIndexOutOfBoundsException)) {
                throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
            }
            throw throwable;
        }
        HllSketch sketch2 = hllSketch;
        boolean allowDifferentLgConfigK = BoxesRunTime.unboxToBoolean((Object)value3);
        if (!allowDifferentLgConfigK && sketch1.getLgConfigK() != sketch2.getLgConfigK()) {
            throw QueryExecutionErrors$.MODULE$.hllUnionDifferentLgK(sketch1.getLgConfigK(), sketch2.getLgConfigK(), this.prettyName());
        }
        Union union = new Union(Math.min(sketch1.getLgConfigK(), sketch2.getLgConfigK()));
        union.update(sketch1);
        union.update(sketch2);
        return union.getResult(this.targetType()).toUpdatableByteArray();
    }

    public HllUnion copy(Expression first, Expression second, Expression third) {
        return new HllUnion(first, second, third);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    public Expression copy$default$3() {
        return this.third();
    }

    @Override
    public String productPrefix() {
        return "HllUnion";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
            case 2: {
                return this.third();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllUnion;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
            case 2: {
                return "third";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllUnion)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllUnion hllUnion = (HllUnion)x$1;
        Expression expression = this.first();
        Expression expression2 = hllUnion.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = hllUnion.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.third();
        Expression expression6 = hllUnion.third();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!hllUnion.canEqual(this)) return false;
        return true;
    }

    public HllUnion(Expression first, Expression second, Expression third) {
        this.first = first;
        this.second = second;
        this.third = third;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllUnion(Expression first, Expression second) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public HllUnion(Expression first, Expression second, boolean third) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)third)));
    }
}

