/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.QueryContext;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.analysis.RelationCache;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.V2TableReference;
import org.apache.spark.sql.catalyst.analysis.V2TableReferenceUtils$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.TemporaryViewRelation;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan$;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias$;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.LookupCatalog;
import org.apache.spark.sql.connector.catalog.LookupCatalog$AsTableIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndMultipartIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndNamespace$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$NonSessionCatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$SessionCatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u000f\u001f\u0001-B\u0001B\u0013\u0001\u0003\u0006\u0004%\te\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000bC\u0003V\u0001\u0011\u0005a+\u0002\u0003[\u0001\u0001Y\u0006b\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002>\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011%\t)\u0006AI\u0001\n\u0003\t9\u0006C\u0004\u0002n\u0001!I!a\u001c\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\n\u0003W\u0004\u0011\u0013!C\u0005\u0003[D\u0011\"!=\u0001#\u0003%I!!<\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001b\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\b\u0003G\u0003A\u0011\u0002B\u0007\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\b\u0001\t\u0013\u0011y\u0002C\u0004\u0003\"\u0001!IAa\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!I!\u0011\u0007\u0001\u0012\u0002\u0013%\u0011q\u000b\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0005I\u0011V\r\\1uS>t'+Z:pYV$\u0018n\u001c8\u000b\u0005}\u0001\u0013\u0001C1oC2L8/[:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001a#\u0007\u000f G!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111GN\u0007\u0002i)\u0011QGI\u0001\u0007KJ\u0014xN]:\n\u0005]\"$A\u0005#bi\u0006$\u0016\u0010]3FeJ|'o\u001d\"bg\u0016\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0013\u0002\u0011%tG/\u001a:oC2L!!\u0010\u001e\u0003\u000f1{wmZ5oOB\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\bG\u0006$\u0018\r\\8h\u0015\t\u0019%%A\u0005d_:tWm\u0019;pe&\u0011Q\t\u0011\u0002\u000e\u0019>|7.\u001e9DCR\fGn\\4\u0011\u0005\u001dCU\"\u0001\u0011\n\u0005%\u0003#!D*R\u0019\u000e{gN\u001a%fYB,'/\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u00031\u0003\"aP'\n\u00059\u0003%AD\"bi\u0006dwnZ'b]\u0006<WM]\u0001\u0010G\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3sA\u0005\u00192\u000f[1sK\u0012\u0014V\r\\1uS>t7)Y2iKB\u0011!kU\u0007\u0002=%\u0011AK\b\u0002\u000e%\u0016d\u0017\r^5p]\u000e\u000b7\r[3\u0002\rqJg.\u001b;?)\r9\u0006,\u0017\t\u0003%\u0002AQA\u0013\u0003A\u00021CQ\u0001\u0015\u0003A\u0002E\u0013\u0001bQ1dQ\u0016\\U-\u001f\t\u0005[qs&/\u0003\u0002^]\t1A+\u001e9mKJ\u00022aX4k\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002dU\u00051AH]8pizJ\u0011aL\u0005\u0003M:\nq\u0001]1dW\u0006<W-\u0003\u0002iS\n\u00191+Z9\u000b\u0005\u0019t\u0003CA6p\u001d\taW\u000e\u0005\u0002b]%\u0011aNL\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002o]A\u0019Qf];\n\u0005Qt#AB(qi&|g\u000e\u0005\u0002Sm&\u0011qO\b\u0002\u000f)&lW\r\u0016:bm\u0016d7\u000b]3d\u0003A1\u0018gU3tg&|gnQ1uC2|w-F\u0001{!\tYX0D\u0001}\u0015\t\t\u0005%\u0003\u0002\u007fy\nq1+Z:tS>t7)\u0019;bY><\u0017!\u0005<2'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8hA\u0005i!/\u001a7bi&|gnQ1dQ\u0016,\"!!\u0002\u0011\u0011\u0005\u001d\u0011\u0011CA\u000b\u00033i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\b[V$\u0018M\u00197f\u0015\r\tyAL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\n\u0003\u0013\u00111!T1q!\r\t9\"B\u0007\u0002\u0001A!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0004\u0003G\u0001\u0013!\u00029mC:\u001c\u0018\u0002BA\u0014\u0003;\u00111\u0002T8hS\u000e\fG\u000e\u00157b]\u0006\u0001R\r\u001f9b]\u0012LE-\u001a8uS\u001aLWM\u001d\u000b\u0004=\u00065\u0002BBA\u0018\u0013\u0001\u0007a,A\u0005oC6,\u0007+\u0019:ug\u0006qAn\\8lkB$V-\u001c9WS\u0016<H\u0003BA\u001b\u0003{\u0001B!L:\u00028A\u001910!\u000f\n\u0007\u0005mBPA\u000bUK6\u0004xN]1ssZKWm\u001e*fY\u0006$\u0018n\u001c8\t\r\u0005}\"\u00021\u0001_\u0003)IG-\u001a8uS\u001aLWM]\u0001\u0010e\u0016\u001cx\u000e\u001c<f%\u0016d\u0017\r^5p]R1\u0011QIA$\u0003#\u0002B!L:\u0002\u001a!9\u0011\u0011J\u0006A\u0002\u0005-\u0013!A;\u0011\u0007I\u000bi%C\u0002\u0002Py\u0011!#\u00168sKN|GN^3e%\u0016d\u0017\r^5p]\"A\u00111K\u0006\u0011\u0002\u0003\u0007!/\u0001\buS6,GK]1wK2\u001c\u0006/Z2\u00023I,7o\u001c7wKJ+G.\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0003\u00033R3A]A.W\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA4]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00077p_.,\bo\u00155be\u0016$'+\u001a7bi&|gnQ1dQ\u0016$\u0002\"!\u001d\u0002\b\u0006=\u0015\u0011\u0014\t\u0005[M\f\u0019\b\u0005\u0003\u0002v\u0005\rUBAA<\u0015\u0011\tI(a\u001f\u0002\u0005Y\u0014$\u0002BA?\u0003\u007f\n1\u0002Z1uCN|WO]2fg*\u0019\u0011\u0011\u0011\u0012\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BAC\u0003o\u0012A\u0003R1uCN{WO]2f-J\u0012V\r\\1uS>t\u0007BB!\u000e\u0001\u0004\tI\tE\u0002@\u0003\u0017K1!!$A\u00055\u0019\u0015\r^1m_\u001e\u0004F.^4j]\"9\u0011\u0011S\u0007A\u0002\u0005M\u0015!B5eK:$\bcA \u0002\u0016&\u0019\u0011q\u0013!\u0003\u0015%#WM\u001c;jM&,'\u000fC\u0004\u0002\u001c6\u0001\r!!(\u0002\u000bQ\f'\r\\3\u0011\u0007}\ny*C\u0002\u0002\"\u0002\u0013Q\u0001V1cY\u0016\f1#\u00193baR\u001c\u0015m\u00195fIJ+G.\u0019;j_:$b!!\u0007\u0002(\u0006-\u0006bBAU\u001d\u0001\u0007\u0011\u0011D\u0001\u0007G\u0006\u001c\u0007.\u001a3\t\u000f\u00055f\u00021\u0001\u00020\u00061\u0001\u000f\\1o\u0013\u0012\u0004B!L:\u00022B\u0019Q&a-\n\u0007\u0005UfF\u0001\u0003M_:<\u0017AD2sK\u0006$XMU3mCRLwN\u001c\u000b\u000f\u0003\u000b\nY,!0\u0002@\u0006\r\u00171[Ao\u0011\u0019\tu\u00021\u0001\u0002\n\"9\u0011\u0011S\bA\u0002\u0005M\u0005bBAN\u001f\u0001\u0007\u0011\u0011\u0019\t\u0005[M\fi\nC\u0004\u0002F>\u0001\r!a2\u0002\u000f=\u0004H/[8ogB!\u0011\u0011ZAh\u001b\t\tYMC\u0002\u0002N\n\nA!\u001e;jY&!\u0011\u0011[Af\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r\u001d\u0005\b\u0003+|\u0001\u0019AAl\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0011\u00075\nI.C\u0002\u0002\\:\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002T=\u0001\rA]\u0001\u0010e\u0016\u001cx\u000e\u001c<f)\u0016l\u0007OV5foRA\u0011QIAr\u0003K\f9\u000f\u0003\u0004\u0002@A\u0001\rA\u0018\u0005\n\u0003+\u0004\u0002\u0013!a\u0001\u0003/D\u0011\"!;\u0011!\u0003\u0005\r!a6\u0002\u0019%\u001cH+[7f)J\fg/\u001a7\u00023I,7o\u001c7wKR+W\u000e\u001d,jK^$C-\u001a4bk2$HEM\u000b\u0003\u0003_TC!a6\u0002\\\u0005I\"/Z:pYZ,G+Z7q-&,w\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003A\u0011Xm]8mm\u0016\u0014VMZ3sK:\u001cW\r\u0006\u0003\u0002\u001a\u0005]\bbBA}'\u0001\u0007\u00111`\u0001\u0004e\u00164\u0007c\u0001*\u0002~&\u0019\u0011q \u0010\u0003!Y\u0013D+\u00192mKJ+g-\u001a:f]\u000e,\u0017!E4fi>\u0013Hj\\1e%\u0016d\u0017\r^5p]R!\u0011\u0011\u0004B\u0003\u0011\u001d\tI\u0010\u0006a\u0001\u0003w\fA\u0002\\8bIJ+G.\u0019;j_:$B!!\u0007\u0003\f!9\u0011\u0011`\u000bA\u0002\u0005mHCBA\r\u0005\u001f\u0011\t\u0002C\u0004\u0002*Z\u0001\r!!\u0007\t\u000f\u0005eh\u00031\u0001\u0002|\u0006\u0001R.\u0019;dQ\u0016\u001c(+\u001a4fe\u0016t7-\u001a\u000b\u0007\u0003/\u00149Ba\u0007\t\u000f\teq\u00031\u0001\u0002t\u0005A!/\u001a7bi&|g\u000eC\u0004\u0002z^\u0001\r!a?\u0002\u001f%\u001c(+Z:pYZLgn\u001a,jK^,\"!a6\u0002-%\u001c(+\u001a4feJ,G\rV3naZKWm\u001e(b[\u0016$B!a6\u0003&!1\u0011qF\rA\u0002y\u000b!\u0002^8DC\u000eDWmS3z)!\t)Ba\u000b\u0003.\t=\u0002BB!\u001b\u0001\u0004\tI\tC\u0004\u0002\u0012j\u0001\r!a%\t\u0011\u0005M#\u0004%AA\u0002I\fA\u0003^8DC\u000eDWmS3zI\u0011,g-Y;mi\u0012\u001a\u0014aD2m_:,w+\u001b;i!2\fg.\u00133\u0015\r\u0005e!q\u0007B\u001e\u0011\u001d\u0011I\u0004\ba\u0001\u00033\tA\u0001\u001d7b]\"9\u0011Q\u0016\u000fA\u0002\u0005=\u0006")
public class RelationResolution
implements DataTypeErrorsBase,
LookupCatalog,
SQLConfHelper {
    private final CatalogManager catalogManager;
    private final RelationCache sharedRelationCache;
    private final SessionCatalog v1SessionCatalog;
    private volatile LookupCatalog$CatalogAndMultipartIdentifier$ CatalogAndMultipartIdentifier$module;
    private volatile LookupCatalog$SessionCatalogAndIdentifier$ SessionCatalogAndIdentifier$module;
    private volatile LookupCatalog$NonSessionCatalogAndIdentifier$ NonSessionCatalogAndIdentifier$module;
    private volatile LookupCatalog$CatalogAndNamespace$ CatalogAndNamespace$module;
    private volatile LookupCatalog$CatalogAndIdentifier$ CatalogAndIdentifier$module;
    private volatile LookupCatalog$AsTableIdentifier$ AsTableIdentifier$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public CatalogPlugin currentCatalog() {
        return LookupCatalog.currentCatalog$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public LookupCatalog$CatalogAndMultipartIdentifier$ org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier() {
        if (this.CatalogAndMultipartIdentifier$module == null) {
            this.org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier$lzycompute$1();
        }
        return this.CatalogAndMultipartIdentifier$module;
    }

    @Override
    public LookupCatalog$SessionCatalogAndIdentifier$ SessionCatalogAndIdentifier() {
        if (this.SessionCatalogAndIdentifier$module == null) {
            this.SessionCatalogAndIdentifier$lzycompute$1();
        }
        return this.SessionCatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$NonSessionCatalogAndIdentifier$ NonSessionCatalogAndIdentifier() {
        if (this.NonSessionCatalogAndIdentifier$module == null) {
            this.NonSessionCatalogAndIdentifier$lzycompute$1();
        }
        return this.NonSessionCatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$CatalogAndNamespace$ CatalogAndNamespace() {
        if (this.CatalogAndNamespace$module == null) {
            this.CatalogAndNamespace$lzycompute$1();
        }
        return this.CatalogAndNamespace$module;
    }

    @Override
    public LookupCatalog$CatalogAndIdentifier$ CatalogAndIdentifier() {
        if (this.CatalogAndIdentifier$module == null) {
            this.CatalogAndIdentifier$lzycompute$1();
        }
        return this.CatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$AsTableIdentifier$ AsTableIdentifier() {
        if (this.AsTableIdentifier$module == null) {
            this.AsTableIdentifier$lzycompute$1();
        }
        return this.AsTableIdentifier$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private scala.collection.mutable.Map<Tuple2<Seq<String>, Option<TimeTravelSpec>>, LogicalPlan> relationCache() {
        return AnalysisContext$.MODULE$.get().relationCache();
    }

    public Seq<String> expandIdentifier(Seq<String> nameParts) {
        if (!this.isResolvingView() || this.isReferredTempViewName(nameParts)) {
            return nameParts;
        }
        if (nameParts.length() == 1) {
            return (Seq)AnalysisContext$.MODULE$.get().catalogAndNamespace().$colon$plus(nameParts.head());
        }
        if (this.catalogManager().isCatalogRegistered((String)nameParts.head())) {
            return nameParts;
        }
        String string = (String)AnalysisContext$.MODULE$.get().catalogAndNamespace().head();
        return (Seq)nameParts.$plus$colon((Object)string);
    }

    public Option<TemporaryViewRelation> lookupTempView(Seq<String> identifier) {
        if (this.isResolvingView() && !this.isReferredTempViewName(identifier)) {
            return None$.MODULE$;
        }
        return this.v1SessionCatalog().getRawLocalOrGlobalTempView(identifier);
    }

    public Option<LogicalPlan> resolveRelation(UnresolvedRelation u, Option<TimeTravelSpec> timeTravelSpec) {
        Option<TimeTravelSpec> timeTravelSpecFromOptions = TimeTravelSpec$.MODULE$.fromOptions(u.options(), this.conf().getConf(SQLConf$.MODULE$.TIME_TRAVEL_TIMESTAMP_KEY()), this.conf().getConf(SQLConf$.MODULE$.TIME_TRAVEL_VERSION_KEY()), this.conf().sessionLocalTimeZone());
        if (timeTravelSpec.nonEmpty() && timeTravelSpecFromOptions.nonEmpty()) {
            throw new AnalysisException("MULTIPLE_TIME_TRAVEL_SPEC", Predef$.MODULE$.Map().empty());
        }
        Option finalTimeTravelSpec = timeTravelSpec.orElse((Function0 & Serializable)() -> timeTravelSpecFromOptions);
        return this.resolveTempView(u.multipartIdentifier(), u.isStreaming(), finalTimeTravelSpec.isDefined()).orElse((Function0 & Serializable)() -> {
            Option<Tuple2<CatalogPlugin, Identifier>> option;
            Seq<String> seq = this.expandIdentifier(u.multipartIdentifier());
            if (seq != null && !(option = this.CatalogAndIdentifier().unapply(seq)).isEmpty()) {
                CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
                Identifier ident = (Identifier)((Tuple2)option.get())._2();
                Tuple2<Seq<String>, Option<TimeTravelSpec>> key = this.toCacheKey(catalog, ident, (Option<TimeTravelSpec>)finalTimeTravelSpec);
                Option<Object> planId = u.getTagValue(LogicalPlan$.MODULE$.PLAN_ID_TAG());
                return this.relationCache().get(key).map((Function1 & Serializable)x$1 -> this.adaptCachedRelation((LogicalPlan)x$1, planId)).orElse((Function0 & Serializable)() -> {
                    String writePrivileges = u.options().get(UnresolvedRelation$.MODULE$.REQUIRED_WRITE_PRIVILEGES());
                    CaseInsensitiveStringMap finalOptions = u.clearWritePrivileges().options();
                    Option<Table> table = CatalogV2Util$.MODULE$.loadTable(catalog, ident, (Option<TimeTravelSpec>)finalTimeTravelSpec, (Option<String>)Option$.MODULE$.apply((Object)writePrivileges));
                    Option sharedRelationCacheMatch = table.withFilter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)RelationResolution.$anonfun$resolveRelation$5(finalTimeTravelSpec, writePrivileges, u, t))).flatMap((Function1 & Serializable)t -> this.lookupSharedRelationCache(catalog, ident, (Table)t).map((Function1 & Serializable)cached -> {
                        CaseInsensitiveStringMap x$1 = finalOptions;
                        Table x$2 = cached.copy$default$1();
                        Seq<AttributeReference> x$3 = cached.copy$default$2();
                        Option<CatalogPlugin> x$4 = cached.copy$default$3();
                        Option<Identifier> x$5 = cached.copy$default$4();
                        Option<TimeTravelSpec> x$6 = cached.copy$default$6();
                        DataSourceV2Relation updatedRelation = cached.copy(x$2, x$3, x$4, x$5, x$1, x$6);
                        Seq<String> nameParts = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).toQualifiedNameParts(catalog);
                        SubqueryAlias aliasedRelation = SubqueryAlias$.MODULE$.apply(nameParts, (LogicalPlan)updatedRelation);
                        this.relationCache().update((Object)key, (Object)aliasedRelation);
                        return this.adaptCachedRelation((LogicalPlan)aliasedRelation, planId);
                    }));
                    return sharedRelationCacheMatch.orElse((Function0 & Serializable)() -> {
                        Option<LogicalPlan> loaded = this.createRelation(catalog, ident, table, finalOptions, u.isStreaming(), (Option<TimeTravelSpec>)finalTimeTravelSpec);
                        loaded.foreach((Function1 & Serializable)x$2 -> {
                            RelationResolution.$anonfun$resolveRelation$9(this, key, x$2);
                            return BoxedUnit.UNIT;
                        });
                        return loaded.map((Function1 & Serializable)x$3 -> this.cloneWithPlanId((LogicalPlan)x$3, planId));
                    });
                });
            }
            return None$.MODULE$;
        });
    }

    public Option<TimeTravelSpec> resolveRelation$default$2() {
        return None$.MODULE$;
    }

    private Option<DataSourceV2Relation> lookupSharedRelationCache(CatalogPlugin catalog, Identifier ident, Table table) {
        return CatalogV2Util$.MODULE$.lookupCachedRelation(this.sharedRelationCache, catalog, ident, table, this.conf());
    }

    private LogicalPlan adaptCachedRelation(LogicalPlan cached, Option<Object> planId) {
        LogicalPlan plan2 = (LogicalPlan)cached.transform(new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MultiInstanceRelation) {
                    A1 A12 = A1;
                    LogicalPlan newRelation = ((MultiInstanceRelation)((Object)A12)).newInstance();
                    newRelation.copyTagsFrom(A12);
                    return (B1)newRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof MultiInstanceRelation;
            }
        });
        return this.cloneWithPlanId(plan2, planId);
    }

    private Option<LogicalPlan> createRelation(CatalogPlugin catalog, Identifier ident, Option<Table> table, CaseInsensitiveStringMap options, boolean isStreaming, Option<TimeTravelSpec> timeTravelSpec) {
        return table.map((Function1 & Serializable)x0$1 -> {
            Table table = x0$1;
            if (table instanceof V1Table) {
                V1Table v1Table = (V1Table)table;
                if (CatalogV2Util$.MODULE$.isSessionCatalog(catalog) || !v1Table.catalogTable().tracksPartitionsInCatalog()) {
                    if (isStreaming) {
                        CatalogTableType catalogTableType = v1Table.v1Table().tableType();
                        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                        if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                            throw QueryCompilationErrors$.MODULE$.permanentViewNotSupportedByStreamingReadingAPIError(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted());
                        }
                        String string = catalog.name();
                        return SubqueryAlias$.MODULE$.apply((Seq<String>)((Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier().$plus$colon((Object)string)), (LogicalPlan)new UnresolvedCatalogRelation(v1Table.v1Table(), options, true));
                    }
                    return this.v1SessionCatalog().getRelation(v1Table.v1Table(), options);
                }
            }
            if (isStreaming) {
                None$ none$;
                Predef$.MODULE$.assert(timeTravelSpec.isEmpty(), (Function0 & Serializable)() -> "time travel is not allowed in streaming");
                Table table2 = table;
                if (table2 instanceof V2TableWithV1Fallback) {
                    V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table2;
                    CatalogTable x$1 = v2TableWithV1Fallback.v1Table();
                    boolean x$2 = true;
                    CaseInsensitiveStringMap x$3 = UnresolvedCatalogRelation$.MODULE$.apply$default$2();
                    Some some = new Some((Object)new UnresolvedCatalogRelation(x$1, x$3, true));
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                None$ v1Fallback = none$;
                String string = catalog.name();
                return SubqueryAlias$.MODULE$.apply((Seq<String>)((Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier().$plus$colon((Object)string)), (LogicalPlan)new StreamingRelationV2((Option<TableProvider>)None$.MODULE$, table.name(), table, options, CatalogV2Implicits$.MODULE$.ColumnsHelper(table.columns()).toAttributes(), (Option<CatalogPlugin>)new Some((Object)catalog), (Option<Identifier>)new Some((Object)ident), (Option<LogicalPlan>)v1Fallback, StreamingRelationV2$.MODULE$.apply$default$9()));
            }
            String string = catalog.name();
            return SubqueryAlias$.MODULE$.apply((Seq<String>)((Seq)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asMultipartIdentifier().$plus$colon((Object)string)), (LogicalPlan)DataSourceV2Relation$.MODULE$.create(table, (Option<CatalogPlugin>)new Some((Object)catalog), (Option<Identifier>)new Some((Object)ident), options, timeTravelSpec));
        });
    }

    private Option<LogicalPlan> resolveTempView(Seq<String> identifier, boolean isStreaming, boolean isTimeTravel) {
        return this.lookupTempView(identifier).map((Function1 & Serializable)v -> {
            SubqueryAlias tempViewPlan = this.v1SessionCatalog().getTempViewRelation((TemporaryViewRelation)v);
            if (isStreaming && !tempViewPlan.isStreaming()) {
                throw QueryCompilationErrors$.MODULE$.readNonStreamingTempViewError(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(identifier).quoted());
            }
            if (isTimeTravel) {
                throw QueryCompilationErrors$.MODULE$.timeTravelUnsupportedError(this.toSQLId(identifier));
            }
            return tempViewPlan;
        });
    }

    private boolean resolveTempView$default$2() {
        return false;
    }

    private boolean resolveTempView$default$3() {
        return false;
    }

    public LogicalPlan resolveReference(V2TableReference ref) {
        LogicalPlan relation = this.getOrLoadRelation(ref);
        Option<Object> planId = ref.getTagValue(LogicalPlan$.MODULE$.PLAN_ID_TAG());
        return this.cloneWithPlanId(relation, planId);
    }

    private LogicalPlan getOrLoadRelation(V2TableReference ref) {
        Tuple2<Seq<String>, Option<TimeTravelSpec>> key = this.toCacheKey(ref.catalog(), ref.identifier(), this.toCacheKey$default$3());
        Option option = this.relationCache().get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogicalPlan cached = (LogicalPlan)some.value();
            return this.adaptCachedRelation(cached, ref);
        }
        if (None$.MODULE$.equals(option)) {
            LogicalPlan relation = this.loadRelation(ref);
            this.relationCache().update(key, (Object)relation);
            return relation;
        }
        throw new MatchError((Object)option);
    }

    private LogicalPlan loadRelation(V2TableReference ref) {
        Table table = ref.catalog().loadTable(ref.identifier());
        V2TableReferenceUtils$.MODULE$.validateLoadedTable(table, ref);
        return ref.toRelation(table);
    }

    private LogicalPlan adaptCachedRelation(LogicalPlan cached, V2TableReference ref) {
        return (LogicalPlan)cached.transform(new Serializable(this, ref){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RelationResolution $outer;
            private final V2TableReference ref$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2Relation dataSourceV2Relation;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2Relation && this.$outer.org$apache$spark$sql$catalyst$analysis$RelationResolution$$matchesReference(dataSourceV2Relation = (DataSourceV2Relation)A1, this.ref$1)) {
                    V2TableReferenceUtils$.MODULE$.validateLoadedTable(dataSourceV2Relation.table(), this.ref$1);
                    Seq<AttributeReference> x$1 = this.ref$1.output();
                    CaseInsensitiveStringMap x$2 = this.ref$1.options();
                    Table x$3 = dataSourceV2Relation.copy$default$1();
                    Option<CatalogPlugin> x$4 = dataSourceV2Relation.copy$default$3();
                    Option<Identifier> x$5 = dataSourceV2Relation.copy$default$4();
                    Option<TimeTravelSpec> x$6 = dataSourceV2Relation.copy$default$6();
                    return (B1)dataSourceV2Relation.copy(x$3, x$1, x$4, x$5, x$2, x$6);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof DataSourceV2Relation && this.$outer.org$apache$spark$sql$catalyst$analysis$RelationResolution$$matchesReference(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan, this.ref$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ref$1 = ref$1;
            }
        });
    }

    public boolean org$apache$spark$sql$catalyst$analysis$RelationResolution$$matchesReference(DataSourceV2Relation relation, V2TableReference ref) {
        return relation.catalog().contains((Object)ref.catalog()) && relation.identifier().contains((Object)ref.identifier());
    }

    private boolean isResolvingView() {
        return AnalysisContext$.MODULE$.get().catalogAndNamespace().nonEmpty();
    }

    private boolean isReferredTempViewName(Seq<String> nameParts) {
        Function2<String, String, Object> resolver = this.conf().resolver();
        return AnalysisContext$.MODULE$.get().referredTempViewNames().exists((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)RelationResolution.$anonfun$isReferredTempViewName$1(nameParts, resolver, n)));
    }

    private Tuple2<Seq<String>, Option<TimeTravelSpec>> toCacheKey(CatalogPlugin catalog, Identifier ident, Option<TimeTravelSpec> timeTravelSpec) {
        String string = catalog.name();
        return new Tuple2((Object)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)string, ClassTag$.MODULE$.apply(String.class))), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq(), timeTravelSpec);
    }

    private Option<TimeTravelSpec> toCacheKey$default$3() {
        return None$.MODULE$;
    }

    private LogicalPlan cloneWithPlanId(LogicalPlan plan2, Option<Object> planId) {
        Option<Object> option = planId;
        if (option instanceof Some) {
            Some some = (Some)option;
            long id = BoxesRunTime.unboxToLong((Object)some.value());
            LogicalPlan clone = plan2.clone();
            clone.setTagValue(LogicalPlan$.MODULE$.PLAN_ID_TAG(), BoxesRunTime.boxToLong((long)id));
            return clone;
        }
        if (None$.MODULE$.equals(option)) {
            return plan2;
        }
        throw new MatchError(option);
    }

    private final void org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.CatalogAndMultipartIdentifier$module == null) {
                this.CatalogAndMultipartIdentifier$module = new LookupCatalog$CatalogAndMultipartIdentifier$(this);
            }
        }
    }

    private final void SessionCatalogAndIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.SessionCatalogAndIdentifier$module == null) {
                this.SessionCatalogAndIdentifier$module = new LookupCatalog$SessionCatalogAndIdentifier$(this);
            }
        }
    }

    private final void NonSessionCatalogAndIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.NonSessionCatalogAndIdentifier$module == null) {
                this.NonSessionCatalogAndIdentifier$module = new LookupCatalog$NonSessionCatalogAndIdentifier$(this);
            }
        }
    }

    private final void CatalogAndNamespace$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.CatalogAndNamespace$module == null) {
                this.CatalogAndNamespace$module = new LookupCatalog$CatalogAndNamespace$(this);
            }
        }
    }

    private final void CatalogAndIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.CatalogAndIdentifier$module == null) {
                this.CatalogAndIdentifier$module = new LookupCatalog$CatalogAndIdentifier$(this);
            }
        }
    }

    private final void AsTableIdentifier$lzycompute$1() {
        RelationResolution relationResolution = this;
        synchronized (relationResolution) {
            if (this.AsTableIdentifier$module == null) {
                this.AsTableIdentifier$module = new LookupCatalog$AsTableIdentifier$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$resolveRelation$5(Option finalTimeTravelSpec$1, String writePrivileges$1, UnresolvedRelation u$1, Table t) {
        return finalTimeTravelSpec$1.isEmpty() && writePrivileges$1 == null && !u$1.isStreaming();
    }

    public static final /* synthetic */ void $anonfun$resolveRelation$9(RelationResolution $this, Tuple2 key$1, LogicalPlan x$2) {
        $this.relationCache().update((Object)key$1, (Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$isReferredTempViewName$2(Function2 resolver$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)a, (Object)b));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isReferredTempViewName$1(Seq nameParts$1, Function2 resolver$1, Seq n) {
        return n.length() == nameParts$1.length() && ((IterableOnceOps)n.zip((IterableOnce)nameParts$1)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RelationResolution.$anonfun$isReferredTempViewName$2(resolver$1, x0$1)));
    }

    public RelationResolution(CatalogManager catalogManager, RelationCache sharedRelationCache) {
        this.catalogManager = catalogManager;
        this.sharedRelationCache = sharedRelationCache;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        Logging.$init$((Logging)this);
        LookupCatalog.$init$(this);
        SQLConfHelper.$init$(this);
        this.v1SessionCatalog = catalogManager.v1SessionCatalog();
    }
}

