/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics;

import org.apache.parquet.ParquetRuntimeException;
import org.apache.parquet.column.statistics.Statistics;

public class StatisticsClassException
extends ParquetRuntimeException {
    private static final long serialVersionUID = 1L;

    public StatisticsClassException(String className1, String className2) {
        this("Statistics classes mismatched: " + className1 + " vs. " + className2);
    }

    private StatisticsClassException(String msg) {
        super(msg);
    }

    static StatisticsClassException create(Statistics<?> stats1, Statistics<?> stats2) {
        if (stats1.getClass() != stats2.getClass()) {
            return new StatisticsClassException(stats1.getClass().toString(), stats2.getClass().toString());
        }
        return new StatisticsClassException("Statistics comparator mismatched: " + String.valueOf(stats1.comparator()) + " vs. " + String.valueOf(stats2.comparator()));
    }
}

