/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.LineString;

class MultiLineString
extends GeometryModel {
    private final List<LineString> lineStrings;

    MultiLineString(List<LineString> lineStrings, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.MULTI_LINESTRING, srid, hasZ, hasM);
        this.lineStrings = lineStrings;
    }

    List<LineString> getLineStrings() {
        return this.lineStrings;
    }

    int getNumGeometries() {
        return this.lineStrings.size();
    }

    @Override
    boolean isEmpty() {
        return this.lineStrings.isEmpty() || this.lineStrings.stream().allMatch(LineString::isEmpty);
    }

    @Override
    int getDimensionCount() {
        return 2 + (this.hasZ ? 1 : 0) + (this.hasM ? 1 : 0);
    }
}

