/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.URIUtil;
import org.sparkproject.jetty.util.resource.Resource;
import org.sparkproject.jetty.util.resource.Resources;

public class CombinedResource
extends Resource {
    private final List<Resource> _resources;

    static Resource combine(List<Resource> resources) {
        if ((resources = CombinedResource.gatherUniqueFlatResourceList(resources)) == null || resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        return new CombinedResource(resources);
    }

    static List<Resource> gatherUniqueFlatResourceList(List<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        ArrayList<Resource> unique = new ArrayList<Resource>(resources.size());
        for (Resource r : resources) {
            if (r == null) {
                throw new IllegalArgumentException("Null Resource entry encountered");
            }
            if (r instanceof CombinedResource) {
                CombinedResource resourceCollection = (CombinedResource)r;
                unique.addAll(CombinedResource.gatherUniqueFlatResourceList(resourceCollection.getResources()));
                continue;
            }
            if (unique.contains(r)) continue;
            if (!r.exists()) {
                throw new IllegalArgumentException("Does not exist: " + String.valueOf(r));
            }
            if (!r.isDirectory()) {
                throw new IllegalArgumentException("Non-Directory not allowed: " + String.valueOf(r));
            }
            unique.add(r);
        }
        return unique;
    }

    CombinedResource(List<Resource> resources) {
        this._resources = Collections.unmodifiableList(resources);
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    @Override
    public Resource resolve(String subUriPath) {
        if (URIUtil.isNotNormalWithinSelf(subUriPath)) {
            throw new IllegalArgumentException(subUriPath);
        }
        if (subUriPath.length() == 0 || "/".equals(subUriPath)) {
            return this;
        }
        ArrayList<Resource> resources = null;
        Resource resolved = null;
        Resource notFound = null;
        for (Resource res : this._resources) {
            resolved = res.resolve(subUriPath);
            if (!Resources.missing(resolved) && !resolved.isDirectory()) {
                return resolved;
            }
            if (Resources.missing(resolved) && notFound == null) {
                notFound = resolved;
            }
            if (resources == null) {
                resources = new ArrayList<Resource>();
            }
            resources.add(resolved);
        }
        if (resources == null) {
            return notFound;
        }
        if (resources.size() == 1) {
            return (Resource)resources.get(0);
        }
        return new CombinedResource((List<Resource>)resources);
    }

    @Override
    public boolean exists() {
        for (Resource r : this._resources) {
            if (!r.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Path getPath() {
        int exists = 0;
        Path path = null;
        for (Resource r : this._resources) {
            if (!r.exists() || exists++ != 0) continue;
            path = r.getPath();
        }
        return switch (exists) {
            case 0 -> this._resources.get(0).getPath();
            case 1 -> path;
            default -> null;
        };
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getFileName() {
        String filename = null;
        for (Resource r : this._resources) {
            String fn = r.getFileName();
            if (fn == null) {
                return null;
            }
            if (filename == null) {
                filename = fn;
                continue;
            }
            if (filename.equals(fn)) continue;
            return null;
        }
        return filename;
    }

    @Override
    public URI getURI() {
        int exists = 0;
        URI uri = null;
        for (Resource r : this._resources) {
            if (!r.exists() || exists++ != 0) continue;
            uri = r.getURI();
        }
        return switch (exists) {
            case 0 -> this._resources.get(0).getURI();
            case 1 -> uri;
            default -> null;
        };
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isReadable() {
        for (Resource r : this._resources) {
            if (!r.isReadable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Instant lastModified() {
        Instant instant = null;
        for (Resource r : this._resources) {
            Instant lm = r.lastModified();
            if (instant != null && !lm.isAfter(instant)) continue;
            instant = lm;
        }
        return instant;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public Iterator<Resource> iterator() {
        return this._resources.iterator();
    }

    @Override
    public List<Resource> list() {
        TreeMap<String, Resource> results = new TreeMap<String, Resource>();
        for (Resource base : this._resources) {
            for (Resource r : base.list()) {
                if (r.isDirectory()) {
                    results.computeIfAbsent(r.getFileName(), this::resolve);
                    continue;
                }
                results.putIfAbsent(r.getFileName(), r);
            }
        }
        return new ArrayList<Resource>(results.values());
    }

    @Override
    public void copyTo(Path destination) throws IOException {
        Collection<Resource> all = this.getAllResources();
        for (Resource r : all) {
            if (!r.exists()) continue;
            Path relative = this.getPathTo(r);
            Path pathTo = IO.resolvePath(destination, relative);
            if (r.isDirectory()) {
                IO.ensureDirExists(pathTo);
                continue;
            }
            IO.ensureDirExists(pathTo.getParent());
            r.copyTo(pathTo);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedResource other = (CombinedResource)o;
        return Objects.equals(this._resources, other._resources);
    }

    public int hashCode() {
        return Objects.hash(this._resources);
    }

    @Override
    public boolean isAlias() {
        for (Resource r : this._resources) {
            if (!r.isAlias()) continue;
            return true;
        }
        return false;
    }

    @Override
    public URI getRealURI() {
        if (!this.isAlias()) {
            return this.getURI();
        }
        int exists = 0;
        URI uri = null;
        for (Resource r : this._resources) {
            if (!r.exists() || exists++ != 0) continue;
            uri = r.getRealURI();
        }
        return switch (exists) {
            case 0 -> this._resources.get(0).getRealURI();
            case 1 -> uri;
            default -> null;
        };
    }

    @Override
    public String toString() {
        return this._resources.stream().map(Resource::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean contains(Resource other) {
        block0: for (Resource o : other) {
            for (Resource r : this._resources) {
                if (!r.contains(o)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public Path getPathTo(Resource other) {
        Path otherPath = other.getPath();
        if (otherPath != null) {
            for (Resource r : this._resources) {
                Path path;
                if (!r.exists() || !otherPath.startsWith(path = r.getPath())) continue;
                return path.relativize(otherPath);
            }
            return null;
        }
        Path relative = null;
        block1: for (Resource o : other) {
            if (!o.exists()) continue;
            for (Resource r : this._resources) {
                if (!r.exists() || !o.getPath().startsWith(r.getPath())) continue;
                Path rel = r.getPath().relativize(o.getPath());
                if (relative == null) {
                    relative = rel;
                    continue block1;
                }
                if (relative.equals(rel)) continue block1;
                return null;
            }
            return null;
        }
        return relative;
    }

    @Override
    public boolean isSameFile(Path path) {
        for (Resource r : this) {
            if (!r.isSameFile(path)) continue;
            return true;
        }
        return false;
    }
}

