/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.python.PythonFunction;
import org.apache.spark.api.python.PythonWorkerUtils$;
import org.apache.spark.api.python.SpecialLengths$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.v2.python.PythonDataSourceCreationResult;
import org.apache.spark.sql.execution.python.PythonPlannerRunner;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\u0006\r\tuA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dA\u0006A1A\u0005BeCa!\u0019\u0001!\u0002\u0013Q\u0006\"\u00022\u0001\t#\u001a\u0007\"B4\u0001\t#B\u0007bBA\u0001\u0001\u0011E\u00131\u0001\u0002\"+N,'\u000fR3gS:,G\rU=uQ>tG)\u0019;b'>,(oY3Sk:tWM\u001d\u0006\u0003\u001b9\ta\u0001]=uQ>t'BA\b\u0011\u0003\t1(G\u0003\u0002\u0012%\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0019B#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\b\t\u0004?\u0005\u001aS\"\u0001\u0011\u000b\u00055\u0011\u0012B\u0001\u0012!\u0005M\u0001\u0016\u0010\u001e5p]Bc\u0017M\u001c8feJ+hN\\3s!\t!S%D\u0001\r\u0013\t1CB\u0001\u0010QsRDwN\u001c#bi\u0006\u001cv.\u001e:dK\u000e\u0013X-\u0019;j_:\u0014Vm];mi\u0006iA-\u0019;b'>,(oY3DYN\u0004\"!K\u0017\u000e\u0003)R!!D\u0016\u000b\u000512\u0012aA1qS&\u0011aF\u000b\u0002\u000f!f$\bn\u001c8Gk:\u001cG/[8o\u0003!\u0001(o\u001c<jI\u0016\u0014\bCA\u0019;\u001d\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u000269\u00051AH]8pizR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011HN\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.\u0019\t\u0004\u007f\u0001\u0013U\"\u0001\u001c\n\u0005\u00053$AB(qi&|g\u000e\u0005\u0002D\r6\tAI\u0003\u0002F)\u0005)A/\u001f9fg&\u0011q\t\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aB8qi&|gn\u001d\t\u0004\u0015>\u0003T\"A&\u000b\u00051k\u0015\u0001B;uS2T!A\u0014\u000b\u0002\u0011\r\fG/\u00197zgRL!\u0001U&\u0003%\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016l\u0015\r]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM#VKV,\u0011\u0005\u0011\u0002\u0001\"B\u0014\u0006\u0001\u0004A\u0003\"B\u0018\u0006\u0001\u0004\u0001\u0004\"B\u001f\u0006\u0001\u0004q\u0004\"\u0002%\u0006\u0001\u0004I\u0015\u0001D<pe.,'/T8ek2,W#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016\u0001\u00027b]\u001eT\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002<9\u0006iqo\u001c:lKJlu\u000eZ;mK\u0002\n!B];o]\u0016\u00148i\u001c8g+\u0005!\u0007\u0003B\u0019faAJ!A\u001a\u001f\u0003\u00075\u000b\u0007/A\u0007xe&$X\rV8QsRDwN\u001c\u000b\u0004S2$\bCA k\u0013\tYgG\u0001\u0003V]&$\b\"B7\n\u0001\u0004q\u0017a\u00023bi\u0006|U\u000f\u001e\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cz\u000b!![8\n\u0005M\u0004(\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u0015)\u0018\u00021\u0001w\u0003\u001d\u0001\u0018nY6mKJ\u0004\"a\u001e@\u000e\u0003aT!!\u001f>\u0002\rAL7m\u001b7f\u0015\tYH0A\u0005sCj|'O^5oK*\tQ0A\u0002oKRL!a =\u0003\u000fAK7m\u001b7fe\u0006\t\"/Z2fSZ,gI]8n!f$\bn\u001c8\u0015\u0007\r\n)\u0001C\u0004\u0002\b)\u0001\r!!\u0003\u0002\r\u0011\fG/Y%o!\ry\u00171B\u0005\u0004\u0003\u001b\u0001(a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7")
public class UserDefinedPythonDataSourceRunner
extends PythonPlannerRunner<PythonDataSourceCreationResult> {
    private final PythonFunction dataSourceCls;
    private final String provider;
    private final Option<StructType> userSpecifiedSchema;
    private final CaseInsensitiveMap<String> options;
    private final String workerModule;

    @Override
    public String workerModule() {
        return this.workerModule;
    }

    @Override
    public Map<String, String> runnerConf() {
        return (Map)super.runnerConf().$plus$plus((IterableOnce)SQLConf$.MODULE$.get().pythonDataSourceProfiler().map((Function1 & Serializable)p -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PYTHON_DATA_SOURCE_PROFILER().key()), p)}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()));
    }

    @Override
    public void writeToPython(DataOutputStream dataOut, Pickler pickler) {
        PythonWorkerUtils$.MODULE$.writePythonFunction(this.dataSourceCls, dataOut);
        PythonWorkerUtils$.MODULE$.writeUTF(this.provider, dataOut);
        dataOut.writeBoolean(this.userSpecifiedSchema.isDefined());
        this.userSpecifiedSchema.map((Function1 & Serializable)x$2 -> x$2.json()).foreach((Function1 & Serializable)x$3 -> {
            PythonWorkerUtils$.MODULE$.writeUTF(x$3, dataOut);
            return BoxedUnit.UNIT;
        });
        dataOut.writeInt(this.options.size());
        this.options.iterator().foreach((Function1 & Serializable)x0$1 -> {
            UserDefinedPythonDataSourceRunner.$anonfun$writeToPython$3(dataOut, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public PythonDataSourceCreationResult receiveFromPython(DataInputStream dataIn) {
        DataType schema;
        int length = dataIn.readInt();
        if (length == SpecialLengths$.MODULE$.PYTHON_EXCEPTION_THROWN()) {
            String msg = PythonWorkerUtils$.MODULE$.readUTF(dataIn);
            throw QueryCompilationErrors$.MODULE$.pythonDataSourceError("create", "instance", msg);
        }
        byte[] pickledDataSourceInstance = PythonWorkerUtils$.MODULE$.readBytes(length, dataIn);
        int isDDLString = dataIn.readInt();
        String schemaStr = PythonWorkerUtils$.MODULE$.readUTF(dataIn);
        DataType dataType = schema = isDDLString == 1 ? DataType$.MODULE$.fromDDL(schemaStr) : DataType$.MODULE$.fromJson(schemaStr);
        if (!(schema instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(schemaStr, schema);
        }
        return new PythonDataSourceCreationResult(pickledDataSourceInstance, (StructType)schema);
    }

    public static final /* synthetic */ void $anonfun$writeToPython$3(DataOutputStream dataOut$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            PythonWorkerUtils$.MODULE$.writeUTF(key, dataOut$1);
            PythonWorkerUtils$.MODULE$.writeUTF(value, dataOut$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public UserDefinedPythonDataSourceRunner(PythonFunction dataSourceCls, String provider, Option<StructType> userSpecifiedSchema, CaseInsensitiveMap<String> options) {
        this.dataSourceCls = dataSourceCls;
        this.provider = provider;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.options = options;
        super(dataSourceCls);
        this.workerModule = "pyspark.sql.worker.create_data_source";
    }
}

