/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.shuffle.AppsWithRecoveryDisabled;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.MergedShuffleFileManager;
import org.apache.spark.network.shuffle.ShuffleIndexInformation;
import org.apache.spark.network.shuffle.ShuffleIndexRecord;
import org.apache.spark.network.shuffle.protocol.BlockPushReturnCode;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.FinalizeShuffleMerge;
import org.apache.spark.network.shuffle.protocol.MergeStatuses;
import org.apache.spark.network.shuffle.protocol.PushBlockStream;
import org.apache.spark.network.shuffle.protocol.RemoveShuffleMerge;
import org.apache.spark.network.shuffledb.DB;
import org.apache.spark.network.shuffledb.DBBackend;
import org.apache.spark.network.shuffledb.DBIterator;
import org.apache.spark.network.shuffledb.StoreVersion;
import org.apache.spark.network.util.DBProvider;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.roaringbitmap.RoaringBitmap;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.primitives.Ints;
import org.sparkproject.guava.primitives.Longs;

public class RemoteBlockPushResolver
implements MergedShuffleFileManager {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(RemoteBlockPushResolver.class);
    public static final String MERGED_SHUFFLE_FILE_NAME_PREFIX = "shuffleMerged";
    public static final String SHUFFLE_META_DELIMITER = ":";
    public static final String MERGE_DIR_KEY = "mergeDir";
    public static final String ATTEMPT_ID_KEY = "attemptId";
    private static final int UNDEFINED_ATTEMPT_ID = -1;
    public static final int DELETE_ALL_MERGED_SHUFFLE = -1;
    private static final String DB_KEY_DELIMITER = ";";
    private static final ErrorHandler.BlockPushErrorHandler ERROR_HANDLER = RemoteBlockPushResolver.createErrorHandler();
    private static final ByteBuffer SUCCESS_RESPONSE = new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.SUCCESS.id(), "").toByteBuffer().asReadOnlyBuffer();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, String>> SHUFFLE_MANAGER_META_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final String APP_ATTEMPT_SHUFFLE_FINALIZE_STATUS_KEY_PREFIX = "AppAttemptShuffleFinalized";
    private static final String APP_ATTEMPT_PATH_KEY_PREFIX = "AppAttemptPathInfo";
    private static final StoreVersion CURRENT_VERSION = new StoreVersion(1, 0);
    @VisibleForTesting
    final ConcurrentMap<String, AppShuffleInfo> appsShuffleInfo;
    private final ExecutorService mergedShuffleCleaner;
    private final TransportConf conf;
    private final long cleanerShutdownTimeout;
    private final int minChunkSize;
    private final int ioExceptionsThresholdDuringMerge;
    private final LoadingCache<String, ShuffleIndexInformation> indexCache;
    private final PushMergeMetrics pushMergeMetrics;
    @VisibleForTesting
    final File recoveryFile;
    @VisibleForTesting
    final DB db;

    public RemoteBlockPushResolver(TransportConf conf, File recoveryFile) throws IOException {
        this.conf = conf;
        this.appsShuffleInfo = new ConcurrentHashMap<String, AppShuffleInfo>();
        this.mergedShuffleCleaner = Executors.newSingleThreadExecutor(NettyUtils.createThreadFactory((String)"spark-shuffle-merged-shuffle-directory-cleaner"));
        this.cleanerShutdownTimeout = conf.mergedShuffleCleanerShutdownTimeout();
        this.minChunkSize = conf.minChunkSizeInMergedShuffleFile();
        this.ioExceptionsThresholdDuringMerge = conf.ioExceptionsThresholdDuringMerge();
        CacheLoader<String, ShuffleIndexInformation> indexCacheLoader = new CacheLoader<String, ShuffleIndexInformation>(){

            public ShuffleIndexInformation load(String filePath) throws IOException {
                return new ShuffleIndexInformation(filePath);
            }
        };
        this.indexCache = CacheBuilder.newBuilder().maximumWeight(conf.mergedIndexCacheSize()).weigher((filePath, indexInfo) -> indexInfo.getRetainedMemorySize()).build((CacheLoader)indexCacheLoader);
        this.recoveryFile = recoveryFile;
        String dbBackendName = conf.get("spark.shuffle.service.db.backend", DBBackend.ROCKSDB.name());
        DBBackend dbBackend = DBBackend.byName((String)dbBackendName);
        this.db = DBProvider.initDB((DBBackend)dbBackend, (File)this.recoveryFile, (StoreVersion)CURRENT_VERSION, (ObjectMapper)mapper);
        if (this.db != null) {
            logger.info("Use {} as the implementation of {}", new MDC[]{MDC.of((LogKey)LogKeys.SHUFFLE_DB_BACKEND_NAME, (Object)dbBackend), MDC.of((LogKey)LogKeys.SHUFFLE_DB_BACKEND_KEY, (Object)"spark.shuffle.service.db.backend")});
            this.reloadAndCleanUpAppShuffleInfo(this.db);
        }
        this.pushMergeMetrics = new PushMergeMetrics();
    }

    @VisibleForTesting
    protected static ErrorHandler.BlockPushErrorHandler createErrorHandler() {
        return new ErrorHandler.BlockPushErrorHandler(){

            @Override
            public boolean shouldLogError(Throwable t) {
                return !(t instanceof BlockPushNonFatalFailure);
            }
        };
    }

    @VisibleForTesting
    protected AppShuffleInfo validateAndGetAppShuffleInfo(String appId) {
        AppShuffleInfo appShuffleInfo = (AppShuffleInfo)this.appsShuffleInfo.get(appId);
        JavaUtils.checkArgument((appShuffleInfo != null ? 1 : 0) != 0, (String)("application " + appId + " is not registered or NM was restarted."), (Object[])new Object[0]);
        return appShuffleInfo;
    }

    @VisibleForTesting
    AppShufflePartitionInfo getOrCreateAppShufflePartitionInfo(AppShuffleInfo appShuffleInfo, int shuffleId, int shuffleMergeId, int reduceId, String blockId) throws BlockPushNonFatalFailure {
        ConcurrentMap<Integer, AppShuffleMergePartitionsInfo> shuffles = appShuffleInfo.shuffles;
        AppShuffleMergePartitionsInfo shufflePartitionsWithMergeId = shuffles.compute(shuffleId, (id, mergePartitionsInfo) -> {
            if (mergePartitionsInfo == null) {
                logger.info("{} attempt {} shuffle {} shuffleMerge {}: creating a new shuffle merge metadata", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)appShuffleInfo.appId), MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)appShuffleInfo.attemptId), MDC.of((LogKey)LogKeys.SHUFFLE_ID, (Object)shuffleId), MDC.of((LogKey)LogKeys.SHUFFLE_MERGE_ID, (Object)shuffleMergeId)});
                return new AppShuffleMergePartitionsInfo(shuffleMergeId, false);
            }
            int latestShuffleMergeId = mergePartitionsInfo.shuffleMergeId;
            if (latestShuffleMergeId > shuffleMergeId) {
                throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH.id(), blockId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)blockId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH));
            }
            if (latestShuffleMergeId < shuffleMergeId) {
                AppAttemptShuffleMergeId currentAppAttemptShuffleMergeId = new AppAttemptShuffleMergeId(appShuffleInfo.appId, appShuffleInfo.attemptId, shuffleId, latestShuffleMergeId);
                logger.info("{}: creating a new shuffle merge metadata since received shuffleMergeId {} is higher than latest shuffleMergeId {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)currentAppAttemptShuffleMergeId), MDC.of((LogKey)LogKeys.SHUFFLE_MERGE_ID, (Object)shuffleMergeId), MDC.of((LogKey)LogKeys.LATEST_SHUFFLE_MERGE_ID, (Object)latestShuffleMergeId)});
                this.submitCleanupTask(() -> this.closeAndDeleteOutdatedPartitions(currentAppAttemptShuffleMergeId, mergePartitionsInfo.shuffleMergePartitions));
                return new AppShuffleMergePartitionsInfo(shuffleMergeId, false);
            }
            if (mergePartitionsInfo.isFinalized()) {
                throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH.id(), blockId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)blockId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH));
            }
            return mergePartitionsInfo;
        });
        Map<Integer, AppShufflePartitionInfo> shuffleMergePartitions = shufflePartitionsWithMergeId.shuffleMergePartitions;
        return shuffleMergePartitions.computeIfAbsent(reduceId, key -> {
            File dataFile = appShuffleInfo.getMergedShuffleDataFile(shuffleId, shuffleMergeId, reduceId);
            File indexFile = new File(appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId));
            File metaFile = appShuffleInfo.getMergedShuffleMetaFile(shuffleId, shuffleMergeId, reduceId);
            try {
                return this.newAppShufflePartitionInfo(appShuffleInfo, shuffleId, shuffleMergeId, reduceId, dataFile, indexFile, metaFile);
            }
            catch (IOException e) {
                logger.error("{} attempt {} shuffle {} shuffleMerge {}: cannot create merged shuffle partition with data file {}, index file {}, and meta file {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)appShuffleInfo.appId), MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)appShuffleInfo.attemptId), MDC.of((LogKey)LogKeys.SHUFFLE_ID, (Object)shuffleId), MDC.of((LogKey)LogKeys.SHUFFLE_MERGE_ID, (Object)shuffleMergeId), MDC.of((LogKey)LogKeys.DATA_FILE, (Object)dataFile.getAbsolutePath()), MDC.of((LogKey)LogKeys.INDEX_FILE, (Object)indexFile.getAbsolutePath()), MDC.of((LogKey)LogKeys.META_FILE, (Object)metaFile.getAbsolutePath())});
                throw new RuntimeException(String.format("Cannot initialize merged shuffle partition for appId %s shuffleId %s shuffleMergeId %s reduceId %s", appShuffleInfo.appId, shuffleId, shuffleMergeId, reduceId), e);
            }
        });
    }

    @VisibleForTesting
    AppShufflePartitionInfo newAppShufflePartitionInfo(AppShuffleInfo appShuffleInfo, int shuffleId, int shuffleMergeId, int reduceId, File dataFile, File indexFile, File metaFile) throws IOException {
        return new AppShufflePartitionInfo(new AppAttemptShuffleMergeId(appShuffleInfo.appId, appShuffleInfo.attemptId, shuffleId, shuffleMergeId), reduceId, dataFile, new MergeShuffleFile(indexFile), new MergeShuffleFile(metaFile));
    }

    @Override
    public MergedBlockMeta getMergedBlockMeta(String appId, int shuffleId, int shuffleMergeId, int reduceId) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(appId);
        AppShuffleMergePartitionsInfo partitionsInfo = (AppShuffleMergePartitionsInfo)appShuffleInfo.shuffles.get(shuffleId);
        if (null != partitionsInfo && partitionsInfo.shuffleMergeId > shuffleMergeId) {
            throw new RuntimeException(String.format("MergedBlockMeta fetch for shuffle %s with shuffleMergeId %s reduceId %s is %s", shuffleId, shuffleMergeId, reduceId, "stale shuffle block fetch request as shuffle blocks of a higher shuffleMergeId for the shuffle is available"));
        }
        File indexFile = new File(appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId));
        if (!indexFile.exists()) {
            throw new RuntimeException(String.format("Merged shuffle index file %s not found", indexFile.getPath()));
        }
        int size = (int)indexFile.length();
        int numChunks = size / 8 - 1;
        if (numChunks <= 0) {
            throw new RuntimeException(String.format("Merged shuffle index file %s is empty", indexFile.getPath()));
        }
        File metaFile = appShuffleInfo.getMergedShuffleMetaFile(shuffleId, shuffleMergeId, reduceId);
        if (!metaFile.exists()) {
            throw new RuntimeException(String.format("Merged shuffle meta file %s not found", metaFile.getPath()));
        }
        FileSegmentManagedBuffer chunkBitMaps = new FileSegmentManagedBuffer(this.conf, metaFile, 0L, metaFile.length());
        logger.trace("{} shuffleId {} shuffleMergeId {} reduceId {} num chunks {}", new Object[]{appId, shuffleId, shuffleMergeId, reduceId, numChunks});
        return new MergedBlockMeta(numChunks, (ManagedBuffer)chunkBitMaps);
    }

    @Override
    public ManagedBuffer getMergedBlockData(String appId, int shuffleId, int shuffleMergeId, int reduceId, int chunkId) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(appId);
        AppShuffleMergePartitionsInfo partitionsInfo = (AppShuffleMergePartitionsInfo)appShuffleInfo.shuffles.get(shuffleId);
        if (null != partitionsInfo && partitionsInfo.shuffleMergeId > shuffleMergeId) {
            throw new RuntimeException(String.format("MergedBlockData fetch for shuffle %s with shuffleMergeId %s reduceId %s is %s", shuffleId, shuffleMergeId, reduceId, "stale shuffle block fetch request as shuffle blocks of a higher shuffleMergeId for the shuffle is available"));
        }
        File dataFile = appShuffleInfo.getMergedShuffleDataFile(shuffleId, shuffleMergeId, reduceId);
        if (!dataFile.exists()) {
            throw new RuntimeException(String.format("Merged shuffle data file %s not found", dataFile.getPath()));
        }
        String indexFilePath = appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId);
        try {
            ShuffleIndexInformation shuffleIndexInformation = (ShuffleIndexInformation)this.indexCache.get((Object)indexFilePath);
            ShuffleIndexRecord shuffleIndexRecord = shuffleIndexInformation.getIndex(chunkId);
            return new FileSegmentManagedBuffer(this.conf, dataFile, shuffleIndexRecord.offset(), shuffleIndexRecord.length());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(String.format("Failed to open merged shuffle index file %s", indexFilePath), e);
        }
    }

    @Override
    public String[] getMergedBlockDirs(String appId) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(appId);
        return appShuffleInfo.appPathsInfo.activeLocalDirs;
    }

    private void removeOldApplicationAttemptsFromDb(AppShuffleInfo info) {
        if (info.attemptId != -1) {
            for (int formerAttemptId = 0; formerAttemptId < info.attemptId; ++formerAttemptId) {
                this.removeAppAttemptPathInfoFromDB(info.appId, formerAttemptId);
            }
        }
    }

    @Override
    public void applicationRemoved(String appId, boolean cleanupLocalDirs) {
        logger.info("Application {} removed, cleanupLocalDirs = {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)appId), MDC.of((LogKey)LogKeys.CLEANUP_LOCAL_DIRS, (Object)cleanupLocalDirs)});
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.appsShuffleInfo.compute(appId, (id, info) -> {
            if (null != info) {
                this.removeAppAttemptPathInfoFromDB(info.appId, info.attemptId);
                this.removeOldApplicationAttemptsFromDb((AppShuffleInfo)info);
                ref.set(info);
            }
            return null;
        });
        AppShuffleInfo appShuffleInfo = ref.get();
        if (null != appShuffleInfo) {
            this.submitCleanupTask(() -> this.closeAndDeletePartitionsIfNeeded(appShuffleInfo, cleanupLocalDirs));
        }
    }

    @Override
    public void removeShuffleMerge(RemoveShuffleMerge msg) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(msg.appId);
        if (appShuffleInfo.attemptId != msg.appAttemptId) {
            throw new IllegalArgumentException(String.format("The attempt id %s in this RemoveShuffleMerge message does not match with the current attempt id %s stored in shuffle service for application %s", msg.appAttemptId, appShuffleInfo.attemptId, msg.appId));
        }
        appShuffleInfo.shuffles.compute(msg.shuffleId, (shuffleId, mergePartitionsInfo) -> {
            int shuffleMergeIdToDelete;
            if (mergePartitionsInfo == null) {
                if (msg.shuffleMergeId == -1) {
                    return null;
                }
                this.writeAppAttemptShuffleMergeInfoToDB(new AppAttemptShuffleMergeId(msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId));
                return new AppShuffleMergePartitionsInfo(msg.shuffleMergeId, true);
            }
            boolean deleteCurrentMergedShuffle = msg.shuffleMergeId == -1 || msg.shuffleMergeId == mergePartitionsInfo.shuffleMergeId;
            int n = shuffleMergeIdToDelete = msg.shuffleMergeId != -1 ? msg.shuffleMergeId : mergePartitionsInfo.shuffleMergeId;
            if (deleteCurrentMergedShuffle || shuffleMergeIdToDelete > mergePartitionsInfo.shuffleMergeId) {
                AppAttemptShuffleMergeId currentAppAttemptShuffleMergeId = new AppAttemptShuffleMergeId(msg.appId, msg.appAttemptId, msg.shuffleId, mergePartitionsInfo.shuffleMergeId);
                if (!mergePartitionsInfo.isFinalized()) {
                    this.submitCleanupTask(() -> this.closeAndDeleteOutdatedPartitions(currentAppAttemptShuffleMergeId, mergePartitionsInfo.shuffleMergePartitions));
                } else {
                    this.submitCleanupTask(() -> this.deleteMergedFiles(currentAppAttemptShuffleMergeId, appShuffleInfo, mergePartitionsInfo.getReduceIds(), false));
                }
            } else {
                throw new RuntimeException(String.format("Asked to remove old shuffle merged data for application %s shuffleId %s shuffleMergeId %s, but current shuffleMergeId %s ", msg.appId, msg.shuffleId, shuffleMergeIdToDelete, mergePartitionsInfo.shuffleMergeId));
            }
            this.writeAppAttemptShuffleMergeInfoToDB(new AppAttemptShuffleMergeId(msg.appId, msg.appAttemptId, msg.shuffleId, shuffleMergeIdToDelete));
            return new AppShuffleMergePartitionsInfo(shuffleMergeIdToDelete, true);
        });
    }

    @VisibleForTesting
    void closeAndDeletePartitionsIfNeeded(AppShuffleInfo appShuffleInfo, boolean cleanupLocalDirs) {
        appShuffleInfo.shuffles.forEach((shuffleId, shuffleInfo) -> shuffleInfo.shuffleMergePartitions.forEach((shuffleMergeId, partitionInfo) -> {
            AppShufflePartitionInfo appShufflePartitionInfo = partitionInfo;
            synchronized (appShufflePartitionInfo) {
                partitionInfo.cleanable.clean();
            }
        }));
        if (cleanupLocalDirs) {
            this.deleteExecutorDirs(appShuffleInfo);
        }
        this.removeAppShuffleInfoFromDB(appShuffleInfo);
    }

    @VisibleForTesting
    void removeAppAttemptPathInfoFromDB(String appId, int attemptId) {
        AppAttemptId appAttemptId = new AppAttemptId(appId, attemptId);
        if (this.db != null && AppsWithRecoveryDisabled.isRecoveryEnabledForApp(appId)) {
            try {
                byte[] key = this.getDbAppAttemptPathsKey(appAttemptId);
                this.db.delete(key);
            }
            catch (Exception e) {
                logger.error("Failed to remove the application attempt {} local path in DB", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)appAttemptId)});
            }
        }
    }

    @VisibleForTesting
    void removeAppShuffleInfoFromDB(AppShuffleInfo appShuffleInfo) {
        if (this.db != null) {
            appShuffleInfo.shuffles.forEach((shuffleId, shuffleInfo) -> this.removeAppShufflePartitionInfoFromDB(new AppAttemptShuffleMergeId(appShuffleInfo.appId, appShuffleInfo.attemptId, (int)shuffleId, shuffleInfo.shuffleMergeId)));
        }
    }

    @VisibleForTesting
    void closeAndDeleteOutdatedPartitions(AppAttemptShuffleMergeId appAttemptShuffleMergeId, Map<Integer, AppShufflePartitionInfo> partitions) {
        this.removeAppShufflePartitionInfoFromDB(appAttemptShuffleMergeId);
        partitions.forEach((partitionId, partitionInfo) -> {
            AppShufflePartitionInfo appShufflePartitionInfo = partitionInfo;
            synchronized (appShufflePartitionInfo) {
                partitionInfo.cleanable.clean();
                partitionInfo.deleteAllFiles();
            }
        });
    }

    void deleteMergedFiles(AppAttemptShuffleMergeId appAttemptShuffleMergeId, AppShuffleInfo appShuffleInfo, int[] reduceIds, boolean deleteFromDB) {
        if (deleteFromDB) {
            this.removeAppShufflePartitionInfoFromDB(appAttemptShuffleMergeId);
        }
        int shuffleId = appAttemptShuffleMergeId.shuffleId;
        int shuffleMergeId = appAttemptShuffleMergeId.shuffleMergeId;
        int dataFilesDeleteCnt = 0;
        int indexFilesDeleteCnt = 0;
        int metaFilesDeleteCnt = 0;
        for (int reduceId : reduceIds) {
            File metaFile;
            File indexFile;
            File dataFile = appShuffleInfo.getMergedShuffleDataFile(shuffleId, shuffleMergeId, reduceId);
            if (dataFile.delete()) {
                ++dataFilesDeleteCnt;
            }
            if ((indexFile = new File(appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId))).delete()) {
                ++indexFilesDeleteCnt;
            }
            if (!(metaFile = appShuffleInfo.getMergedShuffleMetaFile(shuffleId, shuffleMergeId, reduceId)).delete()) continue;
            ++metaFilesDeleteCnt;
        }
        logger.info("Delete {} data files, {} index files, {} meta files for {}", new MDC[]{MDC.of((LogKey)LogKeys.NUM_DATA_FILES, (Object)dataFilesDeleteCnt), MDC.of((LogKey)LogKeys.NUM_INDEX_FILES, (Object)indexFilesDeleteCnt), MDC.of((LogKey)LogKeys.NUM_META_FILES, (Object)metaFilesDeleteCnt), MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId)});
    }

    void removeAppShufflePartitionInfoFromDB(AppAttemptShuffleMergeId appAttemptShuffleMergeId) {
        if (this.db != null) {
            try {
                this.db.delete(this.getDbAppAttemptShufflePartitionKey(appAttemptShuffleMergeId));
            }
            catch (Exception e) {
                logger.error("Error deleting {} from application shuffle merged partition info in DB", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId)});
            }
        }
    }

    @VisibleForTesting
    void deleteExecutorDirs(AppShuffleInfo appShuffleInfo) {
        Path[] dirs;
        for (Path localDir : dirs = (Path[])Arrays.stream(appShuffleInfo.appPathsInfo.activeLocalDirs).map(dir -> Paths.get(dir, new String[0])).toArray(Path[]::new)) {
            try {
                if (!Files.exists(localDir, new LinkOption[0])) continue;
                JavaUtils.deleteRecursively((File)localDir.toFile());
                logger.debug("Successfully cleaned up directory: {}", (Object)localDir);
            }
            catch (Exception e) {
                logger.error("Failed to delete directory: {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.PATH, (Object)localDir)});
            }
        }
    }

    @Override
    public MetricSet getMetrics() {
        return this.pushMergeMetrics;
    }

    @Override
    public StreamCallbackWithID receiveBlockDataAsStream(PushBlockStream msg) {
        AppShufflePartitionInfo partitionInfo;
        AppShufflePartitionInfo partitionInfoBeforeCheck;
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(msg.appId);
        final String streamId = "shufflePush_" + msg.shuffleId + "_" + msg.shuffleMergeId + "_" + msg.mapIndex + "_" + msg.reduceId;
        if (appShuffleInfo.attemptId != msg.appAttemptId) {
            throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.TOO_OLD_ATTEMPT_PUSH.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.TOO_OLD_ATTEMPT_PUSH));
        }
        BlockPushNonFatalFailure failure = null;
        try {
            partitionInfoBeforeCheck = this.getOrCreateAppShufflePartitionInfo(appShuffleInfo, msg.shuffleId, msg.shuffleMergeId, msg.reduceId, streamId);
        }
        catch (BlockPushNonFatalFailure bpf) {
            partitionInfoBeforeCheck = null;
            failure = bpf;
        }
        AppShufflePartitionInfo appShufflePartitionInfo = failure != null ? null : (partitionInfo = partitionInfoBeforeCheck.mapTracker.contains(msg.mapIndex) ? null : partitionInfoBeforeCheck);
        if (partitionInfo != null) {
            return new PushBlockStreamCallback(this, appShuffleInfo, streamId, partitionInfo, msg.mapIndex);
        }
        this.pushMergeMetrics.lateBlockPushes.mark();
        final BlockPushNonFatalFailure finalFailure = failure;
        return new StreamCallbackWithID(){

            public String getID() {
                return streamId;
            }

            public void onData(String streamId2, ByteBuffer buf) {
                RemoteBlockPushResolver.this.pushMergeMetrics.ignoredBlockBytes.mark((long)buf.remaining());
            }

            public void onComplete(String streamId2) {
                if (finalFailure != null) {
                    throw finalFailure;
                }
            }

            public void onFailure(String streamId2, Throwable cause) {
            }

            public ByteBuffer getCompletionResponse() {
                return SUCCESS_RESPONSE.duplicate();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeStatuses finalizeShuffleMerge(FinalizeShuffleMerge msg) {
        MergeStatuses mergeStatuses;
        logger.info("{} attempt {} shuffle {} shuffleMerge {}: finalize shuffle merge", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)msg.appId), MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)msg.appAttemptId), MDC.of((LogKey)LogKeys.SHUFFLE_ID, (Object)msg.shuffleId), MDC.of((LogKey)LogKeys.SHUFFLE_MERGE_ID, (Object)msg.shuffleMergeId)});
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(msg.appId);
        if (appShuffleInfo.attemptId != msg.appAttemptId) {
            throw new IllegalArgumentException(String.format("The attempt id %s in this FinalizeShuffleMerge message does not match with the current attempt id %s stored in shuffle service for application %s", msg.appAttemptId, appShuffleInfo.attemptId, msg.appId));
        }
        AppAttemptShuffleMergeId appAttemptShuffleMergeId = new AppAttemptShuffleMergeId(msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId);
        AtomicReference<Object> shuffleMergePartitionsRef = new AtomicReference<Object>(null);
        appShuffleInfo.shuffles.compute(msg.shuffleId, (shuffleId, mergePartitionsInfo) -> {
            if (null != mergePartitionsInfo) {
                if (msg.shuffleMergeId < mergePartitionsInfo.shuffleMergeId || mergePartitionsInfo.isFinalized()) {
                    throw new RuntimeException(String.format("Shuffle merge finalize request for shuffle %s with shuffleMergeId %s is %s", msg.shuffleId, msg.shuffleMergeId, "stale shuffle finalize request as shuffle blocks of a higher shuffleMergeId for the shuffle is already being pushed"));
                }
                if (msg.shuffleMergeId > mergePartitionsInfo.shuffleMergeId) {
                    AppAttemptShuffleMergeId currentAppAttemptShuffleMergeId = new AppAttemptShuffleMergeId(msg.appId, msg.appAttemptId, msg.shuffleId, mergePartitionsInfo.shuffleMergeId);
                    this.submitCleanupTask(() -> this.closeAndDeleteOutdatedPartitions(currentAppAttemptShuffleMergeId, mergePartitionsInfo.shuffleMergePartitions));
                } else {
                    shuffleMergePartitionsRef.set(mergePartitionsInfo.shuffleMergePartitions);
                }
            }
            this.writeAppAttemptShuffleMergeInfoToDB(appAttemptShuffleMergeId);
            return new AppShuffleMergePartitionsInfo(msg.shuffleMergeId, true);
        });
        Map shuffleMergePartitions = shuffleMergePartitionsRef.get();
        if (null == shuffleMergePartitions || shuffleMergePartitions.isEmpty()) {
            mergeStatuses = new MergeStatuses(msg.shuffleId, msg.shuffleMergeId, new RoaringBitmap[0], new int[0], new long[0]);
        } else {
            ArrayList<RoaringBitmap> bitmaps = new ArrayList<RoaringBitmap>(shuffleMergePartitions.size());
            ArrayList<Integer> reduceIds = new ArrayList<Integer>(shuffleMergePartitions.size());
            ArrayList<Long> sizes = new ArrayList<Long>(shuffleMergePartitions.size());
            Iterator iterator = shuffleMergePartitions.values().iterator();
            while (iterator.hasNext()) {
                AppShufflePartitionInfo partition;
                AppShufflePartitionInfo appShufflePartitionInfo = partition = (AppShufflePartitionInfo)iterator.next();
                synchronized (appShufflePartitionInfo) {
                    try {
                        logger.debug("{} attempt {} shuffle {} shuffleMerge {}: finalizing shuffle partition {} ", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId, partition.reduceId});
                        partition.finalizePartition();
                        if (!partition.mapTracker.isEmpty()) {
                            bitmaps.add(partition.mapTracker);
                            reduceIds.add(partition.reduceId);
                            sizes.add(partition.getLastChunkOffset());
                            logger.debug("{} attempt {} shuffle {} shuffleMerge {}: finalization results added for partition {} data size {} index size {} meta size {}", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId, partition.reduceId, partition.getLastChunkOffset(), partition.indexFile.getPos(), partition.metaFile.getPos()});
                        }
                    }
                    catch (IOException ioe) {
                        logger.warn("{} attempt {} shuffle {} shuffleMerge {}: exception while finalizing shuffle partition {}. Exception message: {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)msg.appId), MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)msg.appAttemptId), MDC.of((LogKey)LogKeys.SHUFFLE_ID, (Object)msg.shuffleId), MDC.of((LogKey)LogKeys.SHUFFLE_MERGE_ID, (Object)msg.shuffleMergeId), MDC.of((LogKey)LogKeys.REDUCE_ID, (Object)partition.reduceId), MDC.of((LogKey)LogKeys.EXCEPTION, (Object)ioe.getMessage())});
                    }
                    finally {
                        partition.cleanable.clean();
                    }
                }
            }
            mergeStatuses = new MergeStatuses(msg.shuffleId, msg.shuffleMergeId, bitmaps.toArray(new RoaringBitmap[bitmaps.size()]), Ints.toArray(reduceIds), Longs.toArray(sizes));
            ((AppShuffleMergePartitionsInfo)appShuffleInfo.shuffles.get(msg.shuffleId)).setReduceIds(Ints.toArray(reduceIds));
        }
        logger.info("{} attempt {} shuffle {} shuffleMerge {}: finalization of shuffle merge completed", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)msg.appId), MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)msg.appAttemptId), MDC.of((LogKey)LogKeys.SHUFFLE_ID, (Object)msg.shuffleId), MDC.of((LogKey)LogKeys.SHUFFLE_MERGE_ID, (Object)msg.shuffleMergeId)});
        return mergeStatuses;
    }

    @Override
    public void registerExecutor(String appId, ExecutorShuffleInfo executorInfo) {
        String shuffleManagerMeta;
        if (logger.isDebugEnabled()) {
            logger.debug("register executor with RemoteBlockPushResolver {} local-dirs {} num sub-dirs {} shuffleManager {}", new Object[]{appId, Arrays.toString(executorInfo.localDirs), executorInfo.subDirsPerLocalDir, executorInfo.shuffleManager});
        }
        if ((shuffleManagerMeta = executorInfo.shuffleManager).contains(SHUFFLE_META_DELIMITER)) {
            String mergeDirInfo = shuffleManagerMeta.substring(shuffleManagerMeta.indexOf(SHUFFLE_META_DELIMITER) + 1);
            try {
                Map metaMap = (Map)mapper.readValue(mergeDirInfo, SHUFFLE_MANAGER_META_TYPE_REF);
                String mergeDir = (String)metaMap.get(MERGE_DIR_KEY);
                int attemptId = Integer.valueOf(metaMap.getOrDefault(ATTEMPT_ID_KEY, String.valueOf(-1)));
                if (mergeDir == null) {
                    throw new IllegalArgumentException(String.format("Failed to get the merge directory information from the shuffleManagerMeta %s in executor registration message", shuffleManagerMeta));
                }
                if (attemptId == -1) {
                    this.appsShuffleInfo.computeIfAbsent(appId, id -> {
                        AppPathsInfo appPathsInfo = new AppPathsInfo(appId, executorInfo.localDirs, mergeDir, executorInfo.subDirsPerLocalDir);
                        this.writeAppPathsInfoToDb(appId, -1, appPathsInfo);
                        return new AppShuffleInfo(appId, -1, appPathsInfo);
                    });
                } else {
                    AtomicReference originalAppShuffleInfo = new AtomicReference();
                    this.appsShuffleInfo.compute(appId, (id, appShuffleInfo) -> {
                        if (appShuffleInfo == null || attemptId > appShuffleInfo.attemptId) {
                            originalAppShuffleInfo.set(appShuffleInfo);
                            AppPathsInfo appPathsInfo = new AppPathsInfo(appId, executorInfo.localDirs, mergeDir, executorInfo.subDirsPerLocalDir);
                            if (appShuffleInfo != null) {
                                this.removeAppAttemptPathInfoFromDB(appId, appShuffleInfo.attemptId);
                            }
                            this.writeAppPathsInfoToDb(appId, attemptId, appPathsInfo);
                            appShuffleInfo = new AppShuffleInfo(appId, attemptId, new AppPathsInfo(appId, executorInfo.localDirs, mergeDir, executorInfo.subDirsPerLocalDir));
                        }
                        return appShuffleInfo;
                    });
                    if (originalAppShuffleInfo.get() != null) {
                        AppShuffleInfo appShuffleInfo2 = (AppShuffleInfo)originalAppShuffleInfo.get();
                        logger.warn("Cleanup shuffle info and merged shuffle files for {}_{} as new application attempt registered", new MDC[]{MDC.of((LogKey)LogKeys.APP_ID, (Object)appId), MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)appShuffleInfo2.attemptId)});
                        this.submitCleanupTask(() -> this.closeAndDeletePartitionsIfNeeded(appShuffleInfo2, true));
                    }
                }
            }
            catch (JsonProcessingException e) {
                logger.warn("Failed to get the merge directory information from ExecutorShuffleInfo: ", (Throwable)e);
            }
        } else {
            logger.warn("ExecutorShuffleInfo does not have the expected merge directory information");
        }
    }

    @Override
    public void close() {
        if (!this.mergedShuffleCleaner.isShutdown()) {
            try {
                this.mergedShuffleCleaner.shutdown();
                if (!this.mergedShuffleCleaner.awaitTermination(this.cleanerShutdownTimeout, TimeUnit.SECONDS)) {
                    this.shutdownMergedShuffleCleanerNow();
                }
            }
            catch (InterruptedException e) {
                logger.info("mergedShuffleCleaner is interrupted in the process of graceful shutdown", (Throwable)e);
                this.shutdownMergedShuffleCleanerNow();
                Thread.currentThread().interrupt();
            }
        }
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (IOException e) {
                logger.error("Exception closing leveldb with registered app paths info and shuffle partition info", (Throwable)e);
            }
        }
    }

    private void shutdownMergedShuffleCleanerNow() {
        try {
            List<Runnable> unfinishedTasks = this.mergedShuffleCleaner.shutdownNow();
            logger.warn("There are still {} tasks not completed in mergedShuffleCleaner after {} ms.", new MDC[]{MDC.of((LogKey)LogKeys.COUNT, (Object)unfinishedTasks.size()), MDC.of((LogKey)LogKeys.TIMEOUT, (Object)(this.cleanerShutdownTimeout * 1000L))});
            if (!this.mergedShuffleCleaner.awaitTermination(this.cleanerShutdownTimeout, TimeUnit.SECONDS)) {
                logger.warn("mergedShuffleCleaner did not terminate in {} ms.", new MDC[]{MDC.of((LogKey)LogKeys.TIMEOUT, (Object)(this.cleanerShutdownTimeout * 1000L))});
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private void writeAppPathsInfoToDb(String appId, int attemptId, AppPathsInfo appPathsInfo) {
        if (this.db != null && AppsWithRecoveryDisabled.isRecoveryEnabledForApp(appId)) {
            AppAttemptId appAttemptId = new AppAttemptId(appId, attemptId);
            try {
                byte[] key = this.getDbAppAttemptPathsKey(appAttemptId);
                String valueStr = mapper.writeValueAsString((Object)appPathsInfo);
                byte[] value = valueStr.getBytes(StandardCharsets.UTF_8);
                this.db.put(key, value);
            }
            catch (Exception e) {
                logger.error("Error saving registered app paths info for {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)appAttemptId)});
            }
        }
    }

    private void writeAppAttemptShuffleMergeInfoToDB(AppAttemptShuffleMergeId appAttemptShuffleMergeId) {
        if (this.db != null && AppsWithRecoveryDisabled.isRecoveryEnabledForApp(appAttemptShuffleMergeId.appId)) {
            try {
                byte[] dbKey = this.getDbAppAttemptShufflePartitionKey(appAttemptShuffleMergeId);
                this.db.put(dbKey, new byte[0]);
            }
            catch (Exception e) {
                logger.error("Error saving active app shuffle partition {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId)});
            }
        }
    }

    private <T> T parseDbKey(String key, String prefix, Class<T> valueType) throws IOException {
        String json = key.substring(prefix.length() + 1);
        return (T)mapper.readValue(json, valueType);
    }

    private AppAttemptId parseDbAppAttemptPathsKey(String key) throws IOException {
        return this.parseDbKey(key, APP_ATTEMPT_PATH_KEY_PREFIX, AppAttemptId.class);
    }

    private AppAttemptShuffleMergeId parseDbAppAttemptShufflePartitionKey(String key) throws IOException {
        return this.parseDbKey(key, APP_ATTEMPT_SHUFFLE_FINALIZE_STATUS_KEY_PREFIX, AppAttemptShuffleMergeId.class);
    }

    private byte[] getDbKey(Object key, String prefix) throws IOException {
        String keyJsonString = prefix + DB_KEY_DELIMITER + mapper.writeValueAsString(key);
        return keyJsonString.getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getDbAppAttemptShufflePartitionKey(AppAttemptShuffleMergeId appAttemptShuffleMergeId) throws IOException {
        return this.getDbKey(appAttemptShuffleMergeId, APP_ATTEMPT_SHUFFLE_FINALIZE_STATUS_KEY_PREFIX);
    }

    private byte[] getDbAppAttemptPathsKey(AppAttemptId appAttemptId) throws IOException {
        return this.getDbKey(appAttemptId, APP_ATTEMPT_PATH_KEY_PREFIX);
    }

    @VisibleForTesting
    void reloadAndCleanUpAppShuffleInfo(DB db) throws IOException {
        logger.info("Reload applications merged shuffle information from DB");
        ArrayList<byte[]> dbKeysToBeRemoved = new ArrayList<byte[]>();
        dbKeysToBeRemoved.addAll(this.reloadActiveAppAttemptsPathInfo(db));
        dbKeysToBeRemoved.addAll(this.reloadFinalizedAppAttemptsShuffleMergeInfo(db));
        this.removeOutdatedKeyValuesInDB(dbKeysToBeRemoved);
    }

    @VisibleForTesting
    List<byte[]> reloadActiveAppAttemptsPathInfo(DB db) throws IOException {
        ArrayList<byte[]> dbKeysToBeRemoved = new ArrayList<byte[]>();
        if (db != null) {
            try (DBIterator itr = db.iterator();){
                itr.seek(APP_ATTEMPT_PATH_KEY_PREFIX.getBytes(StandardCharsets.UTF_8));
                while (itr.hasNext()) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
                    if (!key.startsWith(APP_ATTEMPT_PATH_KEY_PREFIX)) {
                        break;
                    }
                    AppAttemptId appAttemptId = this.parseDbAppAttemptPathsKey(key);
                    AppPathsInfo appPathsInfo = (AppPathsInfo)mapper.readValue((byte[])entry.getValue(), AppPathsInfo.class);
                    logger.debug("Reloading Application paths info for application {}", (Object)appAttemptId);
                    this.appsShuffleInfo.compute(appAttemptId.appId, (appId, existingAppShuffleInfo) -> {
                        if (existingAppShuffleInfo == null || existingAppShuffleInfo.attemptId < appAttemptId.attemptId) {
                            if (existingAppShuffleInfo != null) {
                                AppAttemptId existingAppAttemptId = new AppAttemptId(existingAppShuffleInfo.appId, existingAppShuffleInfo.attemptId);
                                try {
                                    dbKeysToBeRemoved.add(this.getDbAppAttemptPathsKey(existingAppAttemptId));
                                }
                                catch (IOException e) {
                                    logger.error("Failed to get the DB key for {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_ID, (Object)existingAppAttemptId)});
                                }
                            }
                            return new AppShuffleInfo(appAttemptId.appId, appAttemptId.attemptId, appPathsInfo);
                        }
                        dbKeysToBeRemoved.add((byte[])entry.getKey());
                        return existingAppShuffleInfo;
                    });
                }
            }
        }
        return dbKeysToBeRemoved;
    }

    @VisibleForTesting
    List<byte[]> reloadFinalizedAppAttemptsShuffleMergeInfo(DB db) throws IOException {
        ArrayList<byte[]> dbKeysToBeRemoved = new ArrayList<byte[]>();
        if (db != null) {
            try (DBIterator itr = db.iterator();){
                itr.seek(APP_ATTEMPT_SHUFFLE_FINALIZE_STATUS_KEY_PREFIX.getBytes(StandardCharsets.UTF_8));
                while (itr.hasNext()) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
                    if (!key.startsWith(APP_ATTEMPT_SHUFFLE_FINALIZE_STATUS_KEY_PREFIX)) {
                        break;
                    }
                    AppAttemptShuffleMergeId partitionId = this.parseDbAppAttemptShufflePartitionKey(key);
                    logger.debug("Reloading finalized shuffle info for partitionId {}", (Object)partitionId);
                    AppShuffleInfo appShuffleInfo = (AppShuffleInfo)this.appsShuffleInfo.get(partitionId.appId);
                    if (appShuffleInfo != null && appShuffleInfo.attemptId == partitionId.attemptId) {
                        appShuffleInfo.shuffles.compute(partitionId.shuffleId, (shuffleId, existingMergePartitionInfo) -> {
                            if (existingMergePartitionInfo == null || existingMergePartitionInfo.shuffleMergeId < partitionId.shuffleMergeId) {
                                if (existingMergePartitionInfo != null) {
                                    AppAttemptShuffleMergeId appAttemptShuffleMergeId = new AppAttemptShuffleMergeId(appShuffleInfo.appId, appShuffleInfo.attemptId, (int)shuffleId, existingMergePartitionInfo.shuffleMergeId);
                                    try {
                                        dbKeysToBeRemoved.add(this.getDbAppAttemptShufflePartitionKey(appAttemptShuffleMergeId));
                                    }
                                    catch (Exception e) {
                                        logger.error("Error getting the DB key for {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId)});
                                    }
                                }
                                return new AppShuffleMergePartitionsInfo(partitionId.shuffleMergeId, true);
                            }
                            dbKeysToBeRemoved.add((byte[])entry.getKey());
                            return existingMergePartitionInfo;
                        });
                        continue;
                    }
                    dbKeysToBeRemoved.add((byte[])entry.getKey());
                }
            }
        }
        return dbKeysToBeRemoved;
    }

    @VisibleForTesting
    void removeOutdatedKeyValuesInDB(List<byte[]> dbKeysToBeRemoved) {
        dbKeysToBeRemoved.forEach(key -> {
            try {
                this.db.delete(key);
            }
            catch (Exception e) {
                logger.error("Error deleting dangling key {} in DB", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.KEY, (Object)key)});
            }
        });
    }

    @VisibleForTesting
    void submitCleanupTask(Runnable task) {
        this.mergedShuffleCleaner.execute(task);
    }

    @VisibleForTesting
    boolean isCleanerShutdown() {
        return this.mergedShuffleCleaner.isShutdown();
    }

    static class PushMergeMetrics
    implements MetricSet {
        static final String BLOCK_APPEND_COLLISIONS_METRIC = "blockAppendCollisions";
        static final String LATE_BLOCK_PUSHES_METRIC = "lateBlockPushes";
        static final String BLOCK_BYTES_WRITTEN_METRIC = "blockBytesWritten";
        static final String DEFERRED_BLOCK_BYTES_METRIC = "deferredBlockBytes";
        static final String DEFERRED_BLOCKS_METRIC = "deferredBlocks";
        static final String STALE_BLOCK_PUSHES_METRIC = "staleBlockPushes";
        static final String IGNORED_BLOCK_BYTES_METRIC = "ignoredBlockBytes";
        private final Map<String, Metric> allMetrics = new HashMap<String, Metric>();
        private final Meter blockAppendCollisions = new Meter();
        private final Meter lateBlockPushes;
        private final Meter blockBytesWritten;
        private final Counter deferredBlockBytes;
        private final Meter deferredBlocks;
        private final Meter staleBlockPushes;
        private final Meter ignoredBlockBytes;

        private PushMergeMetrics() {
            this.allMetrics.put(BLOCK_APPEND_COLLISIONS_METRIC, (Metric)this.blockAppendCollisions);
            this.lateBlockPushes = new Meter();
            this.allMetrics.put(LATE_BLOCK_PUSHES_METRIC, (Metric)this.lateBlockPushes);
            this.blockBytesWritten = new Meter();
            this.allMetrics.put(BLOCK_BYTES_WRITTEN_METRIC, (Metric)this.blockBytesWritten);
            this.deferredBlockBytes = new Counter();
            this.allMetrics.put(DEFERRED_BLOCK_BYTES_METRIC, (Metric)this.deferredBlockBytes);
            this.deferredBlocks = new Meter();
            this.allMetrics.put(DEFERRED_BLOCKS_METRIC, (Metric)this.deferredBlocks);
            this.staleBlockPushes = new Meter();
            this.allMetrics.put(STALE_BLOCK_PUSHES_METRIC, (Metric)this.staleBlockPushes);
            this.ignoredBlockBytes = new Meter();
            this.allMetrics.put(IGNORED_BLOCK_BYTES_METRIC, (Metric)this.ignoredBlockBytes);
        }

        public Map<String, Metric> getMetrics() {
            return this.allMetrics;
        }
    }

    public static class AppShuffleInfo {
        @VisibleForTesting
        final String appId;
        @VisibleForTesting
        final int attemptId;
        private final AppPathsInfo appPathsInfo;
        private final ConcurrentMap<Integer, AppShuffleMergePartitionsInfo> shuffles;

        AppShuffleInfo(String appId, int attemptId, AppPathsInfo appPathsInfo) {
            this.appId = appId;
            this.attemptId = attemptId;
            this.appPathsInfo = appPathsInfo;
            this.shuffles = new ConcurrentHashMap<Integer, AppShuffleMergePartitionsInfo>();
        }

        @VisibleForTesting
        public AppPathsInfo getAppPathsInfo() {
            return this.appPathsInfo;
        }

        @VisibleForTesting
        public ConcurrentMap<Integer, AppShuffleMergePartitionsInfo> getShuffles() {
            return this.shuffles;
        }

        @VisibleForTesting
        String getFilePath(String filename) {
            String targetFile = ExecutorDiskUtils.getFilePath(this.appPathsInfo.activeLocalDirs, this.appPathsInfo.subDirsPerLocalDir, filename);
            logger.debug("Get merged file {}", (Object)targetFile);
            return targetFile;
        }

        private String generateFileName(String appId, int shuffleId, int shuffleMergeId, int reduceId) {
            return String.format("%s_%s_%d_%d_%d", RemoteBlockPushResolver.MERGED_SHUFFLE_FILE_NAME_PREFIX, appId, shuffleId, shuffleMergeId, reduceId);
        }

        public File getMergedShuffleDataFile(int shuffleId, int shuffleMergeId, int reduceId) {
            String fileName = String.format("%s.data", this.generateFileName(this.appId, shuffleId, shuffleMergeId, reduceId));
            return new File(this.getFilePath(fileName));
        }

        public String getMergedShuffleIndexFilePath(int shuffleId, int shuffleMergeId, int reduceId) {
            String indexName = String.format("%s.index", this.generateFileName(this.appId, shuffleId, shuffleMergeId, reduceId));
            return this.getFilePath(indexName);
        }

        public File getMergedShuffleMetaFile(int shuffleId, int shuffleMergeId, int reduceId) {
            String metaName = String.format("%s.meta", this.generateFileName(this.appId, shuffleId, shuffleMergeId, reduceId));
            return new File(this.getFilePath(metaName));
        }
    }

    public static class AppShuffleMergePartitionsInfo {
        private static final Map<Integer, AppShufflePartitionInfo> SHUFFLE_FINALIZED_MARKER = Collections.emptyMap();
        private final int shuffleMergeId;
        private final Map<Integer, AppShufflePartitionInfo> shuffleMergePartitions;
        private final AtomicReference<int[]> reduceIds = new AtomicReference<int[]>(new int[0]);

        public AppShuffleMergePartitionsInfo(int shuffleMergeId, boolean shuffleFinalized) {
            this.shuffleMergeId = shuffleMergeId;
            this.shuffleMergePartitions = shuffleFinalized ? SHUFFLE_FINALIZED_MARKER : new ConcurrentHashMap();
        }

        @VisibleForTesting
        public Map<Integer, AppShufflePartitionInfo> getShuffleMergePartitions() {
            return this.shuffleMergePartitions;
        }

        public boolean isFinalized() {
            return this.shuffleMergePartitions == SHUFFLE_FINALIZED_MARKER;
        }

        public void setReduceIds(int[] reduceIds) {
            this.reduceIds.set(reduceIds);
        }

        public int[] getReduceIds() {
            return this.reduceIds.get();
        }
    }

    public static class AppShufflePartitionInfo {
        private final AppAttemptShuffleMergeId appAttemptShuffleMergeId;
        private final int reduceId;
        private final File dataFile;
        public final FileChannel dataChannel;
        private final MergeShuffleFile indexFile;
        private final MergeShuffleFile metaFile;
        private final Cleaner.Cleanable cleanable;
        private long dataFilePos;
        private int currentMapIndex;
        private RoaringBitmap mapTracker;
        private long lastChunkOffset;
        private int lastMergedMapIndex = -1;
        private RoaringBitmap chunkTracker;
        private int numIOExceptions = 0;
        private boolean indexMetaUpdateFailed;

        AppShufflePartitionInfo(AppAttemptShuffleMergeId appAttemptShuffleMergeId, int reduceId, File dataFile, MergeShuffleFile indexFile, MergeShuffleFile metaFile) throws IOException {
            this.appAttemptShuffleMergeId = appAttemptShuffleMergeId;
            this.reduceId = reduceId;
            this.dataChannel = new FileOutputStream(dataFile).getChannel();
            this.dataFile = dataFile;
            this.indexFile = indexFile;
            this.metaFile = metaFile;
            this.currentMapIndex = -1;
            this.updateChunkInfo(0L, -1);
            this.dataFilePos = 0L;
            this.mapTracker = new RoaringBitmap();
            this.chunkTracker = new RoaringBitmap();
            this.cleanable = CLEANER.register(this, new ResourceCleaner(this.dataChannel, indexFile, metaFile, appAttemptShuffleMergeId, reduceId));
        }

        public long getDataFilePos() {
            return this.dataFilePos;
        }

        public void setDataFilePos(long dataFilePos) {
            logger.trace("{} current pos {} update pos {}", new Object[]{this, this.dataFilePos, dataFilePos});
            this.dataFilePos = dataFilePos;
        }

        int getCurrentMapIndex() {
            return this.currentMapIndex;
        }

        void setCurrentMapIndex(int mapIndex) {
            logger.trace("{} mapIndex {} current mapIndex {}", new Object[]{this, this.currentMapIndex, mapIndex});
            this.currentMapIndex = mapIndex;
        }

        long getLastChunkOffset() {
            return this.lastChunkOffset;
        }

        void blockMerged(int mapIndex) {
            logger.debug("{} updated merging mapIndex {}", (Object)this, (Object)mapIndex);
            this.mapTracker.add(mapIndex);
            this.chunkTracker.add(mapIndex);
            this.lastMergedMapIndex = mapIndex;
        }

        void resetChunkTracker() {
            this.chunkTracker.clear();
        }

        void updateChunkInfo(long chunkOffset, int mapIndex) throws IOException {
            try {
                logger.trace("{} index current {} updated {}", new Object[]{this, this.lastChunkOffset, chunkOffset});
                if (this.indexMetaUpdateFailed) {
                    this.indexFile.getChannel().position(this.indexFile.getPos());
                }
                this.indexFile.getDos().writeLong(chunkOffset);
                this.writeChunkTracker(mapIndex);
                this.indexFile.updatePos(8L);
                this.lastChunkOffset = chunkOffset;
                this.indexMetaUpdateFailed = false;
            }
            catch (IOException ioe) {
                logger.warn("{} reduceId {} update to index/meta failed", new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)this.appAttemptShuffleMergeId), MDC.of((LogKey)LogKeys.REDUCE_ID, (Object)this.reduceId)});
                this.indexMetaUpdateFailed = true;
                throw ioe;
            }
        }

        private void writeChunkTracker(int mapIndex) throws IOException {
            if (mapIndex == -1) {
                return;
            }
            this.chunkTracker.add(mapIndex);
            logger.trace("{} mapIndex {} write chunk to meta file", (Object)this, (Object)mapIndex);
            if (this.indexMetaUpdateFailed) {
                this.metaFile.getChannel().position(this.metaFile.getPos());
            }
            this.chunkTracker.serialize((DataOutput)this.metaFile.getDos());
            this.metaFile.updatePos(this.metaFile.getChannel().position() - this.metaFile.getPos());
        }

        private void incrementIOExceptions() {
            ++this.numIOExceptions;
        }

        private boolean shouldAbort(int ioExceptionsThresholdDuringMerge) {
            return this.numIOExceptions > ioExceptionsThresholdDuringMerge;
        }

        private void finalizePartition() throws IOException {
            if (this.dataFilePos != this.lastChunkOffset) {
                try {
                    this.updateChunkInfo(this.dataFilePos, this.lastMergedMapIndex);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.trace("{} reduceId {} truncating files data {} index {} meta {}", new Object[]{this.appAttemptShuffleMergeId, this.reduceId, this.lastChunkOffset, this.indexFile.getPos(), this.metaFile.getPos()});
            this.dataChannel.truncate(this.lastChunkOffset);
            this.indexFile.getChannel().truncate(this.indexFile.getPos());
            this.metaFile.getChannel().truncate(this.metaFile.getPos());
        }

        private void deleteAllFiles() {
            if (!this.dataFile.delete()) {
                logger.info("Error deleting data file for {} reduceId {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)this.appAttemptShuffleMergeId), MDC.of((LogKey)LogKeys.REDUCE_ID, (Object)this.reduceId)});
            }
            this.metaFile.delete();
            this.indexFile.delete();
        }

        public String toString() {
            return String.format("Application %s_%s shuffleId %s shuffleMergeId %s reduceId %s", this.appAttemptShuffleMergeId.appId, this.appAttemptShuffleMergeId.attemptId, this.appAttemptShuffleMergeId.shuffleId, this.appAttemptShuffleMergeId.shuffleMergeId, this.reduceId);
        }

        @VisibleForTesting
        MergeShuffleFile getIndexFile() {
            return this.indexFile;
        }

        @VisibleForTesting
        MergeShuffleFile getMetaFile() {
            return this.metaFile;
        }

        @VisibleForTesting
        FileChannel getDataChannel() {
            return this.dataChannel;
        }

        @VisibleForTesting
        public RoaringBitmap getMapTracker() {
            return this.mapTracker;
        }

        @VisibleForTesting
        int getNumIOExceptions() {
            return this.numIOExceptions;
        }

        @VisibleForTesting
        Cleaner.Cleanable getCleanable() {
            return this.cleanable;
        }

        private record ResourceCleaner(FileChannel dataChannel, MergeShuffleFile indexFile, MergeShuffleFile metaFile, AppAttemptShuffleMergeId appAttemptShuffleMergeId, int reduceId) implements Runnable
        {
            @Override
            public void run() {
                this.closeAllFiles(this.dataChannel, this.indexFile, this.metaFile, this.appAttemptShuffleMergeId, this.reduceId);
            }

            private void closeAllFiles(FileChannel dataChannel, MergeShuffleFile indexFile, MergeShuffleFile metaFile, AppAttemptShuffleMergeId appAttemptShuffleMergeId, int reduceId) {
                try {
                    if (dataChannel.isOpen()) {
                        dataChannel.close();
                    }
                }
                catch (IOException ioe) {
                    logger.warn("Error closing data channel for {} reduceId {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId), MDC.of((LogKey)LogKeys.REDUCE_ID, (Object)reduceId)});
                }
                try {
                    metaFile.close();
                }
                catch (IOException ioe) {
                    logger.warn("Error closing meta file for {} reduceId {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId), MDC.of((LogKey)LogKeys.REDUCE_ID, (Object)reduceId)});
                }
                try {
                    indexFile.close();
                }
                catch (IOException ioe) {
                    logger.warn("Error closing index file for {} reduceId {}", new MDC[]{MDC.of((LogKey)LogKeys.APP_ATTEMPT_SHUFFLE_MERGE_ID, (Object)appAttemptShuffleMergeId), MDC.of((LogKey)LogKeys.REDUCE_ID, (Object)reduceId)});
                }
            }
        }
    }

    public static class AppAttemptShuffleMergeId {
        public final String appId;
        public final int attemptId;
        public final int shuffleId;
        public final int shuffleMergeId;

        @JsonCreator
        public AppAttemptShuffleMergeId(@JsonProperty(value="appId") String appId, @JsonProperty(value="attemptId") int attemptId, @JsonProperty(value="shuffleId") int shuffleId, @JsonProperty(value="shuffleMergeId") int shuffleMergeId) {
            JavaUtils.checkArgument((appId != null ? 1 : 0) != 0, (String)"app id is null", (Object[])new Object[0]);
            this.appId = appId;
            this.attemptId = attemptId;
            this.shuffleId = shuffleId;
            this.shuffleMergeId = shuffleMergeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppAttemptShuffleMergeId appAttemptShuffleMergeId = (AppAttemptShuffleMergeId)o;
            return this.attemptId == appAttemptShuffleMergeId.attemptId && this.shuffleId == appAttemptShuffleMergeId.shuffleId && this.shuffleMergeId == appAttemptShuffleMergeId.shuffleMergeId && Objects.equals(this.appId, appAttemptShuffleMergeId.appId);
        }

        public int hashCode() {
            return Objects.hash(this.appId, this.attemptId, this.shuffleId, this.shuffleMergeId);
        }

        public String toString() {
            return String.format("Application %s_%s shuffleId %s shuffleMergeId %s", this.appId, this.attemptId, this.shuffleId, this.shuffleMergeId);
        }
    }

    @VisibleForTesting
    public static class MergeShuffleFile {
        private final FileChannel channel;
        private final DataOutputStream dos;
        private long pos;
        private File file;

        @VisibleForTesting
        MergeShuffleFile(File file) throws IOException {
            FileOutputStream fos = new FileOutputStream(file);
            this.channel = fos.getChannel();
            this.dos = new DataOutputStream(fos);
            this.file = file;
        }

        private void updatePos(long numBytes) {
            this.pos += numBytes;
        }

        void close() throws IOException {
            if (this.channel.isOpen()) {
                this.dos.close();
            }
        }

        void delete() {
            try {
                if (null != this.file) {
                    this.file.delete();
                }
            }
            finally {
                this.file = null;
            }
        }

        @VisibleForTesting
        public DataOutputStream getDos() {
            return this.dos;
        }

        @VisibleForTesting
        FileChannel getChannel() {
            return this.channel;
        }

        @VisibleForTesting
        long getPos() {
            return this.pos;
        }
    }

    @VisibleForTesting
    public static class AppPathsInfo {
        @JsonFormat(shape=JsonFormat.Shape.ARRAY)
        @JsonProperty(value="activeLocalDirs")
        private final String[] activeLocalDirs;
        @JsonProperty(value="subDirsPerLocalDir")
        private final int subDirsPerLocalDir;

        @JsonCreator
        public AppPathsInfo(@JsonFormat(shape=JsonFormat.Shape.ARRAY) @JsonProperty(value="activeLocalDirs") String[] activeLocalDirs, @JsonProperty(value="subDirsPerLocalDir") int subDirsPerLocalDir) {
            this.activeLocalDirs = activeLocalDirs;
            this.subDirsPerLocalDir = subDirsPerLocalDir;
        }

        private AppPathsInfo(String appId, String[] localDirs, String mergeDirectory, int subDirsPerLocalDir) {
            this.activeLocalDirs = (String[])Arrays.stream(localDirs).map(localDir -> Paths.get(localDir, new String[0]).getParent().resolve(mergeDirectory).toFile().getPath()).toArray(String[]::new);
            this.subDirsPerLocalDir = subDirsPerLocalDir;
            if (logger.isInfoEnabled()) {
                logger.info("Updated active local dirs {} and sub dirs {} for application {}", new MDC[]{MDC.of((LogKey)LogKeys.PATHS, (Object)Arrays.toString(this.activeLocalDirs)), MDC.of((LogKey)LogKeys.NUM_SUB_DIRS, (Object)subDirsPerLocalDir), MDC.of((LogKey)LogKeys.APP_ID, (Object)appId)});
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppPathsInfo appPathsInfo = (AppPathsInfo)o;
            return this.subDirsPerLocalDir == appPathsInfo.subDirsPerLocalDir && Arrays.equals(this.activeLocalDirs, appPathsInfo.activeLocalDirs);
        }

        public int hashCode() {
            return Objects.hash(this.subDirsPerLocalDir) * 41 + Arrays.hashCode(this.activeLocalDirs);
        }
    }

    public static class AppAttemptId {
        public final String appId;
        public final int attemptId;

        @JsonCreator
        public AppAttemptId(@JsonProperty(value="appId") String appId, @JsonProperty(value="attemptId") int attemptId) {
            this.appId = appId;
            this.attemptId = attemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppAttemptId appAttemptId = (AppAttemptId)o;
            return this.attemptId == appAttemptId.attemptId && Objects.equals(this.appId, appAttemptId.appId);
        }

        public int hashCode() {
            return Objects.hash(this.appId, this.attemptId);
        }

        public String toString() {
            return String.format("Application %s_%s", this.appId, this.attemptId);
        }
    }

    static class PushBlockStreamCallback
    implements StreamCallbackWithID {
        private final RemoteBlockPushResolver mergeManager;
        private final AppShuffleInfo appShuffleInfo;
        private final String streamId;
        private final int mapIndex;
        private final AppShufflePartitionInfo partitionInfo;
        private int length = 0;
        private boolean isWriting = false;
        private List<ByteBuffer> deferredBufs;
        private long receivedBytes = 0L;

        private PushBlockStreamCallback(RemoteBlockPushResolver mergeManager, AppShuffleInfo appShuffleInfo, String streamId, AppShufflePartitionInfo partitionInfo, int mapIndex) {
            JavaUtils.checkArgument((mergeManager != null ? 1 : 0) != 0, (String)"mergeManager is null", (Object[])new Object[0]);
            this.mergeManager = mergeManager;
            JavaUtils.checkArgument((appShuffleInfo != null ? 1 : 0) != 0, (String)"appShuffleInfo is null", (Object[])new Object[0]);
            this.appShuffleInfo = appShuffleInfo;
            this.streamId = streamId;
            JavaUtils.checkArgument((partitionInfo != null ? 1 : 0) != 0, (String)"partitionInfo is null", (Object[])new Object[0]);
            this.partitionInfo = partitionInfo;
            this.mapIndex = mapIndex;
            this.abortIfNecessary();
        }

        public String getID() {
            return this.streamId;
        }

        public ByteBuffer getCompletionResponse() {
            return SUCCESS_RESPONSE.duplicate();
        }

        private void writeBuf(ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                long updatedPos = this.partitionInfo.getDataFilePos() + (long)this.length;
                logger.debug("{} current pos {} updated pos {}", new Object[]{this.partitionInfo, this.partitionInfo.getDataFilePos(), updatedPos});
                int bytesWritten = this.partitionInfo.dataChannel.write(buf, updatedPos);
                this.length += bytesWritten;
                this.mergeManager.pushMergeMetrics.blockBytesWritten.mark((long)bytesWritten);
            }
        }

        private boolean allowedToWrite() {
            return this.partitionInfo.getCurrentMapIndex() < 0 || this.partitionInfo.getCurrentMapIndex() == this.mapIndex;
        }

        private boolean isDuplicateBlock() {
            return this.partitionInfo.getCurrentMapIndex() == this.mapIndex && this.length == 0 || this.partitionInfo.mapTracker.contains(this.mapIndex);
        }

        private void writeDeferredBufs() throws IOException {
            long totalSize = 0L;
            for (ByteBuffer deferredBuf : this.deferredBufs) {
                totalSize += (long)deferredBuf.limit();
                this.writeBuf(deferredBuf);
                this.mergeManager.pushMergeMetrics.deferredBlocks.mark(-1L);
            }
            this.mergeManager.pushMergeMetrics.deferredBlockBytes.dec(totalSize);
            this.deferredBufs = null;
        }

        private void freeDeferredBufs() {
            if (this.deferredBufs != null && !this.deferredBufs.isEmpty()) {
                long totalSize = 0L;
                for (ByteBuffer deferredBuf : this.deferredBufs) {
                    totalSize += (long)deferredBuf.limit();
                    this.mergeManager.pushMergeMetrics.deferredBlocks.mark(-1L);
                }
                this.mergeManager.pushMergeMetrics.deferredBlockBytes.dec(totalSize);
            }
            this.deferredBufs = null;
        }

        private void abortIfNecessary() {
            if (this.partitionInfo.shouldAbort(this.mergeManager.ioExceptionsThresholdDuringMerge)) {
                this.freeDeferredBufs();
                throw new IllegalStateException(String.format("%s when merging %s", "IOExceptions exceeded the threshold", this.streamId));
            }
        }

        private void updateIgnoredBlockBytes() {
            if (this.receivedBytes > 0L) {
                this.mergeManager.pushMergeMetrics.ignoredBlockBytes.mark(this.receivedBytes);
                this.receivedBytes = 0L;
            }
        }

        private void incrementIOExceptionsAndAbortIfNecessary() {
            this.partitionInfo.incrementIOExceptions();
            this.abortIfNecessary();
        }

        private boolean isStale(AppShuffleMergePartitionsInfo appShuffleMergePartitionsInfo, int shuffleMergeId) {
            return null == appShuffleMergePartitionsInfo || appShuffleMergePartitionsInfo.shuffleMergeId > shuffleMergeId;
        }

        private boolean isTooLate(AppShuffleMergePartitionsInfo appShuffleMergePartitionsInfo, int reduceId) {
            return null == appShuffleMergePartitionsInfo || appShuffleMergePartitionsInfo.isFinalized() || !appShuffleMergePartitionsInfo.shuffleMergePartitions.containsKey(reduceId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onData(String streamId, ByteBuffer buf) throws IOException {
            this.receivedBytes += (long)buf.remaining();
            AppShufflePartitionInfo appShufflePartitionInfo = this.partitionInfo;
            synchronized (appShufflePartitionInfo) {
                AppShuffleMergePartitionsInfo info = (AppShuffleMergePartitionsInfo)this.appShuffleInfo.shuffles.get(this.partitionInfo.appAttemptShuffleMergeId.shuffleId);
                boolean isStaleBlockPush = this.isStale(info, this.partitionInfo.appAttemptShuffleMergeId.shuffleMergeId);
                boolean isTooLateBlockPush = this.isTooLate(info, this.partitionInfo.reduceId);
                if (isStaleBlockPush || isTooLateBlockPush) {
                    this.freeDeferredBufs();
                    if (isTooLateBlockPush) {
                        this.mergeManager.pushMergeMetrics.lateBlockPushes.mark();
                    } else {
                        this.mergeManager.pushMergeMetrics.staleBlockPushes.mark();
                    }
                    return;
                }
                if (this.allowedToWrite()) {
                    if (this.isDuplicateBlock()) {
                        this.freeDeferredBufs();
                        return;
                    }
                    this.abortIfNecessary();
                    logger.trace("{} onData writable", (Object)this.partitionInfo);
                    if (this.partitionInfo.getCurrentMapIndex() < 0) {
                        this.partitionInfo.setCurrentMapIndex(this.mapIndex);
                    }
                    this.isWriting = true;
                    try {
                        if (this.deferredBufs != null && !this.deferredBufs.isEmpty()) {
                            this.writeDeferredBufs();
                        }
                        this.writeBuf(buf);
                    }
                    catch (IOException ioe) {
                        this.incrementIOExceptionsAndAbortIfNecessary();
                        throw ioe;
                    }
                } else {
                    logger.trace("{} onData deferred", (Object)this.partitionInfo);
                    if (this.deferredBufs == null) {
                        this.deferredBufs = new ArrayList<ByteBuffer>();
                    }
                    int deferredLen = buf.remaining();
                    ByteBuffer deferredBuf = ByteBuffer.allocate(deferredLen);
                    deferredBuf.put(buf);
                    deferredBuf.flip();
                    this.deferredBufs.add(deferredBuf);
                    this.mergeManager.pushMergeMetrics.deferredBlockBytes.inc((long)deferredLen);
                    this.mergeManager.pushMergeMetrics.deferredBlocks.mark();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String streamId) throws IOException {
            AppShufflePartitionInfo appShufflePartitionInfo = this.partitionInfo;
            synchronized (appShufflePartitionInfo) {
                logger.trace("{} onComplete invoked", (Object)this.partitionInfo);
                AppShuffleMergePartitionsInfo info = (AppShuffleMergePartitionsInfo)this.appShuffleInfo.shuffles.get(this.partitionInfo.appAttemptShuffleMergeId.shuffleId);
                if (this.isTooLate(info, this.partitionInfo.reduceId)) {
                    this.freeDeferredBufs();
                    this.mergeManager.pushMergeMetrics.lateBlockPushes.mark();
                    throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH));
                }
                if (this.isStale(info, this.partitionInfo.appAttemptShuffleMergeId.shuffleMergeId)) {
                    this.freeDeferredBufs();
                    this.mergeManager.pushMergeMetrics.staleBlockPushes.mark();
                    throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH));
                }
                if (this.allowedToWrite()) {
                    if (this.isDuplicateBlock()) {
                        this.freeDeferredBufs();
                        this.updateIgnoredBlockBytes();
                        return;
                    }
                    if (this.partitionInfo.getCurrentMapIndex() < 0) {
                        try {
                            if (this.deferredBufs != null && !this.deferredBufs.isEmpty()) {
                                this.abortIfNecessary();
                                this.isWriting = true;
                                this.writeDeferredBufs();
                            }
                        }
                        catch (IOException ioe) {
                            this.incrementIOExceptionsAndAbortIfNecessary();
                            throw ioe;
                        }
                    }
                    long updatedPos = this.partitionInfo.getDataFilePos() + (long)this.length;
                    boolean indexUpdated = false;
                    if (updatedPos - this.partitionInfo.getLastChunkOffset() >= (long)this.mergeManager.minChunkSize) {
                        try {
                            this.partitionInfo.updateChunkInfo(updatedPos, this.mapIndex);
                            indexUpdated = true;
                        }
                        catch (IOException ioe) {
                            this.incrementIOExceptionsAndAbortIfNecessary();
                        }
                    }
                    this.partitionInfo.setDataFilePos(updatedPos);
                    this.partitionInfo.setCurrentMapIndex(-1);
                    this.partitionInfo.blockMerged(this.mapIndex);
                    if (indexUpdated) {
                        this.partitionInfo.resetChunkTracker();
                    }
                } else {
                    this.freeDeferredBufs();
                    this.mergeManager.pushMergeMetrics.blockAppendCollisions.mark();
                    throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.BLOCK_APPEND_COLLISION_DETECTED.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.BLOCK_APPEND_COLLISION_DETECTED));
                }
            }
            this.isWriting = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(String streamId, Throwable throwable) throws IOException {
            if (ERROR_HANDLER.shouldLogError(throwable)) {
                logger.error("Encountered issue when merging {}", throwable, new MDC[]{MDC.of((LogKey)LogKeys.STREAM_ID, (Object)streamId)});
            } else {
                logger.debug("Encountered issue when merging {}", (Object)streamId, (Object)throwable);
            }
            this.updateIgnoredBlockBytes();
            if (this.isWriting) {
                AppShufflePartitionInfo appShufflePartitionInfo = this.partitionInfo;
                synchronized (appShufflePartitionInfo) {
                    AppShuffleMergePartitionsInfo info = (AppShuffleMergePartitionsInfo)this.appShuffleInfo.shuffles.get(this.partitionInfo.appAttemptShuffleMergeId.shuffleId);
                    if (!this.isTooLate(info, this.partitionInfo.reduceId) && !this.isStale(info, this.partitionInfo.appAttemptShuffleMergeId.shuffleMergeId)) {
                        logger.debug("{} encountered failure", (Object)this.partitionInfo);
                        this.partitionInfo.setCurrentMapIndex(-1);
                    }
                }
            }
            this.isWriting = false;
        }

        @VisibleForTesting
        AppShufflePartitionInfo getPartitionInfo() {
            return this.partitionInfo;
        }
    }
}

