/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import ujson.MathUtils;

public final class DoubleToDecimalChar {
    static final int P = 53;
    private static final int W = 11;
    static final int Q_MIN = -1074;
    static final int Q_MAX = 971;
    static final int E_MIN = -323;
    static final int E_MAX = 309;
    static final long C_TINY = 3L;
    static final int K_MIN = -324;
    static final int K_MAX = 292;
    static final int H = 17;
    private static final long C_MIN = 0x10000000000000L;
    private static final int BQ_MASK = 2047;
    private static final long T_MASK = 0xFFFFFFFFFFFFFL;
    private static final long MASK_63 = Long.MAX_VALUE;
    private static final int MASK_28 = 0xFFFFFFF;
    private static final int NON_SPECIAL = 0;
    private static final int PLUS_ZERO = 1;
    private static final int MINUS_ZERO = 2;
    private static final int PLUS_INF = 3;
    private static final int MINUS_INF = 4;
    private static final int NAN = 5;
    public final int MAX_CHARS = 24;
    private final char[] bytes;
    private int index;
    private int offset;

    public DoubleToDecimalChar(char[] cArray, int n) {
        this.bytes = cArray;
        this.offset = n;
    }

    public static int toString(char[] cArray, int n, double d) {
        DoubleToDecimalChar doubleToDecimalChar = new DoubleToDecimalChar(cArray, n);
        doubleToDecimalChar.toDecimal(d);
        return doubleToDecimalChar.index + 1;
    }

    private String toDecimalString(double d) {
        switch (this.toDecimal(d)) {
            case 0: {
                return this.charsToString();
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "-0.0";
            }
            case 3: {
                return "Infinity";
            }
            case 4: {
                return "-Infinity";
            }
        }
        return "NaN";
    }

    private int toDecimal(double d) {
        long l = Double.doubleToRawLongBits(d);
        long l2 = l & 0xFFFFFFFFFFFFFL;
        int n = (int)(l >>> 52) & 0x7FF;
        if (n < 2047) {
            this.index = -1;
            if (l < 0L) {
                this.append(45);
            }
            if (n != 0) {
                long l3;
                int n2 = 1075 - n;
                long l4 = 0x10000000000000L | l2;
                if (0 < n2 & n2 < 53 && (l3 = l4 >> n2) << n2 == l4) {
                    return this.toChars(l3, 0);
                }
                return this.toDecimal(-n2, l4, 0);
            }
            if (l2 != 0L) {
                return l2 < 3L ? this.toDecimal(-1074, 10L * l2, -1) : this.toDecimal(-1074, l2, 0);
            }
            return l == 0L ? 1 : 2;
        }
        if (l2 != 0L) {
            return 5;
        }
        return l > 0L ? 3 : 4;
    }

    private int toDecimal(int n, long l, int n2) {
        boolean bl;
        long l2;
        int n3;
        long l3;
        int n4 = (int)l & 1;
        long l4 = l << 2;
        long l5 = l4 + 2L;
        if (l != 0x10000000000000L | n == -1074) {
            l3 = l4 - 2L;
            n3 = MathUtils.flog10pow2(n);
        } else {
            l3 = l4 - 1L;
            n3 = MathUtils.flog10threeQuartersPow2(n);
        }
        int n5 = n + MathUtils.flog2pow10(-n3) + 2;
        long l6 = MathUtils.g1(n3);
        long l7 = MathUtils.g0(n3);
        long l8 = DoubleToDecimalChar.rop(l6, l7, l4 << n5);
        long l9 = DoubleToDecimalChar.rop(l6, l7, l3 << n5);
        long l10 = DoubleToDecimalChar.rop(l6, l7, l5 << n5);
        long l11 = l8 >> 2;
        if (l11 >= 100L) {
            boolean bl2;
            l2 = 10L * MathUtils.multiplyHigh(l11, 1844674407370955168L);
            long l12 = l2 + 10L;
            boolean bl3 = l9 + (long)n4 <= l2 << 2;
            boolean bl4 = bl2 = (l12 << 2) + (long)n4 <= l10;
            if (bl3 != bl2) {
                return this.toChars(bl3 ? l2 : l12, n3);
            }
        }
        l2 = l11 + 1L;
        boolean bl5 = l9 + (long)n4 <= l11 << 2;
        boolean bl6 = bl = (l2 << 2) + (long)n4 <= l10;
        if (bl5 != bl) {
            return this.toChars(bl5 ? l11 : l2, n3 + n2);
        }
        long l13 = l8 - (l11 + l2 << 1);
        return this.toChars(l13 < 0L || l13 == 0L && (l11 & 1L) == 0L ? l11 : l2, n3 + n2);
    }

    private static long rop(long l, long l2, long l3) {
        long l4 = MathUtils.multiplyHigh(l2, l3);
        long l5 = l * l3;
        long l6 = MathUtils.multiplyHigh(l, l3);
        long l7 = (l5 >>> 1) + l4;
        long l8 = l6 + (l7 >>> 63);
        return l8 | (l7 & Long.MAX_VALUE) + Long.MAX_VALUE >>> 63;
    }

    private int toChars(long l, int n) {
        int n2 = MathUtils.flog10pow2(64 - Long.numberOfLeadingZeros(l));
        if (l >= MathUtils.pow10(n2)) {
            ++n2;
        }
        long l2 = MathUtils.multiplyHigh(l *= MathUtils.pow10(17 - n2), 193428131138340668L) >>> 20;
        int n3 = (int)(l - 100000000L * l2);
        int n4 = (int)(l2 * 1441151881L >>> 57);
        int n5 = (int)(l2 - (long)(100000000 * n4));
        if (0 < (n += n2) && n <= 7) {
            return this.toChars1(n4, n5, n3, n);
        }
        if (-3 < n && n <= 0) {
            return this.toChars2(n4, n5, n3, n);
        }
        return this.toChars3(n4, n5, n3, n);
    }

    private int toChars1(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.appendDigit(n);
        int n7 = this.y(n2);
        for (n6 = 1; n6 < n4; ++n6) {
            n5 = 10 * n7;
            this.appendDigit(n5 >>> 28);
            n7 = n5 & 0xFFFFFFF;
        }
        this.append(46);
        while (n6 <= 8) {
            n5 = 10 * n7;
            this.appendDigit(n5 >>> 28);
            n7 = n5 & 0xFFFFFFF;
            ++n6;
        }
        this.lowDigits(n3);
        return 0;
    }

    private int toChars2(int n, int n2, int n3, int n4) {
        this.appendDigit(0);
        this.append(46);
        while (n4 < 0) {
            this.appendDigit(0);
            ++n4;
        }
        this.appendDigit(n);
        this.append8Digits(n2);
        this.lowDigits(n3);
        return 0;
    }

    private int toChars3(int n, int n2, int n3, int n4) {
        this.appendDigit(n);
        this.append(46);
        this.append8Digits(n2);
        this.lowDigits(n3);
        this.exponent(n4 - 1);
        return 0;
    }

    private void lowDigits(int n) {
        if (n != 0) {
            this.append8Digits(n);
        }
        this.removeTrailingZeroes();
    }

    private void append8Digits(int n) {
        int n2 = this.y(n);
        for (int i = 0; i < 8; ++i) {
            int n3 = 10 * n2;
            this.appendDigit(n3 >>> 28);
            n2 = n3 & 0xFFFFFFF;
        }
    }

    private void removeTrailingZeroes() {
        while (this.bytes[this.offset + this.index] == '0') {
            --this.index;
        }
        if (this.bytes[this.offset + this.index] == '.') {
            ++this.index;
        }
    }

    private int y(int n) {
        return (int)(MathUtils.multiplyHigh((long)(n + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void exponent(int n) {
        int n2;
        this.append(69);
        if (n < 0) {
            this.append(45);
            n = -n;
        }
        if (n < 10) {
            this.appendDigit(n);
            return;
        }
        if (n >= 100) {
            n2 = n * 1311 >>> 17;
            this.appendDigit(n2);
            n -= 100 * n2;
        }
        n2 = n * 103 >>> 10;
        this.appendDigit(n2);
        this.appendDigit(n - 10 * n2);
    }

    private void append(int n) {
        this.bytes[this.offset + ++this.index] = (char)n;
    }

    private void appendDigit(int n) {
        this.bytes[this.offset + ++this.index] = (char)(48 + n);
    }

    private String charsToString() {
        return new String(this.bytes, 0, this.index + 1);
    }
}

