/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.internal.MonitoringClient;
import com.google.crypto.tink.internal.MonitoringKeysetInfo;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.internal.PrimitiveWrapper;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtPublicKeyVerify;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.List;

class JwtPublicKeyVerifyWrapper
implements PrimitiveWrapper<JwtPublicKeyVerify, JwtPublicKeyVerify> {
    private static final JwtPublicKeyVerifyWrapper WRAPPER = new JwtPublicKeyVerifyWrapper();

    JwtPublicKeyVerifyWrapper() {
    }

    @Override
    public JwtPublicKeyVerify wrap(PrimitiveSet<JwtPublicKeyVerify> primitives) throws GeneralSecurityException {
        return new WrappedJwtPublicKeyVerify(primitives);
    }

    @Override
    public Class<JwtPublicKeyVerify> getPrimitiveClass() {
        return JwtPublicKeyVerify.class;
    }

    @Override
    public Class<JwtPublicKeyVerify> getInputPrimitiveClass() {
        return JwtPublicKeyVerify.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedJwtPublicKeyVerify
    implements JwtPublicKeyVerify {
        private final PrimitiveSet<JwtPublicKeyVerify> primitives;
        private final MonitoringClient.Logger logger;

        public WrappedJwtPublicKeyVerify(PrimitiveSet<JwtPublicKeyVerify> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.logger = client.createLogger(keysetInfo, "jwtverify", "verify");
            } else {
                this.logger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public VerifiedJwt verifyAndDecode(String compact, JwtValidator validator) throws GeneralSecurityException {
            GeneralSecurityException interestingException = null;
            for (List<PrimitiveSet.Entry<JwtPublicKeyVerify>> entries : this.primitives.getAll()) {
                for (PrimitiveSet.Entry<JwtPublicKeyVerify> entry : entries) {
                    try {
                        VerifiedJwt result = entry.getFullPrimitive().verifyAndDecode(compact, validator);
                        this.logger.log(entry.getKeyId(), 1L);
                        return result;
                    }
                    catch (GeneralSecurityException e) {
                        if (!(e instanceof JwtInvalidException)) continue;
                        interestingException = e;
                    }
                }
            }
            this.logger.logFailure();
            if (interestingException != null) {
                throw interestingException;
            }
            throw new GeneralSecurityException("invalid JWT");
        }
    }
}

