/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.random;

import java.io.Serializable;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.AcceptanceResult;
import org.apache.spark.util.random.AcceptanceResult$;
import org.apache.spark.util.random.BinomialBounds$;
import org.apache.spark.util.random.PoissonBounds$;
import org.apache.spark.util.random.StratifiedSamplingUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class StratifiedSamplingUtils$
implements Logging {
    public static final StratifiedSamplingUtils$ MODULE$ = new StratifiedSamplingUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <K, V> scala.collection.mutable.Map<K, AcceptanceResult> getAcceptanceResults(RDD<Tuple2<K, V>> rdd, boolean withReplacement, Map<K, Object> fractions, Option<Map<K, Object>> counts, long seed) {
        Function2<scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>> combOp = this.getCombOp();
        RDD mappedPartitionRDD = rdd.mapPartitionsWithIndex((Function2 & Serializable)(x0$1, x1$1) -> StratifiedSamplingUtils$.$anonfun$getAcceptanceResults$1(seed, withReplacement, fractions, counts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class));
        return mappedPartitionRDD.reduce(combOp);
    }

    public <K, V> Function2<scala.collection.mutable.Map<K, AcceptanceResult>, Tuple2<K, V>, scala.collection.mutable.Map<K, AcceptanceResult>> getSeqOp(boolean withReplacement, Map<K, Object> fractions, StratifiedSamplingUtils.RandomDataGenerator rng, Option<Map<K, Object>> counts) {
        double delta = 5.0E-5;
        return (Function2 & Serializable)(result, item) -> {
            Object key = item._1();
            double fraction = BoxesRunTime.unboxToDouble((Object)fractions.apply(key));
            Object object = !result.contains(key) ? result.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)new AcceptanceResult(AcceptanceResult$.MODULE$.$lessinit$greater$default$1(), AcceptanceResult$.MODULE$.$lessinit$greater$default$2()))) : BoxedUnit.UNIT;
            AcceptanceResult acceptResult = (AcceptanceResult)result.apply(key);
            if (withReplacement) {
                int copiesWaitlisted;
                double acceptBound;
                long copiesAccepted;
                if (acceptResult.areBoundsEmpty()) {
                    long n = BoxesRunTime.unboxToLong((Object)((MapOps)counts.get()).apply(key));
                    long sampleSize = (long)scala.math.package$.MODULE$.ceil((double)n * fraction);
                    double lmbd1 = PoissonBounds$.MODULE$.getLowerBound(sampleSize);
                    double lmbd2 = PoissonBounds$.MODULE$.getUpperBound(sampleSize);
                    acceptResult.acceptBound_$eq(lmbd1 / (double)n);
                    acceptResult.waitListBound_$eq((lmbd2 - lmbd1) / (double)n);
                }
                long l = copiesAccepted = (acceptBound = acceptResult.acceptBound()) == 0.0 ? 0L : (long)rng.nextPoisson(acceptBound);
                if (copiesAccepted > 0L) {
                    acceptResult.numAccepted_$eq(acceptResult.numAccepted() + copiesAccepted);
                }
                v2 = (copiesWaitlisted = rng.nextPoisson(acceptResult.waitListBound())) > 0 ? acceptResult.waitList().$plus$plus$eq((IterableOnce)ArrayBuffer$.MODULE$.fill(copiesWaitlisted, (Function0)(JFunction0.mcD.sp & Serializable)() -> rng.nextUniform())) : BoxedUnit.UNIT;
            } else {
                acceptResult.acceptBound_$eq(BinomialBounds$.MODULE$.getLowerBound(delta, acceptResult.numItems(), fraction));
                acceptResult.waitListBound_$eq(BinomialBounds$.MODULE$.getUpperBound(delta, acceptResult.numItems(), fraction));
                double x = rng.nextUniform();
                if (x < acceptResult.acceptBound()) {
                    acceptResult.numAccepted_$eq(acceptResult.numAccepted() + 1L);
                    v2 = BoxedUnit.UNIT;
                } else {
                    v2 = x < acceptResult.waitListBound() ? acceptResult.waitList().$plus$eq((Object)BoxesRunTime.boxToDouble((double)x)) : BoxedUnit.UNIT;
                }
            }
            acceptResult.numItems_$eq(acceptResult.numItems() + 1L);
            return result;
        };
    }

    public <K> Function2<scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>, scala.collection.mutable.Map<K, AcceptanceResult>> getCombOp() {
        return (Function2 & Serializable)(result1, result2) -> {
            result1.keySet().union(result2.keySet()).foreach((Function1 & Serializable)key -> {
                Option entry1 = result1.get(key);
                if (result2.contains(key)) {
                    ((AcceptanceResult)result2.apply(key)).merge((Option<AcceptanceResult>)entry1);
                    return BoxedUnit.UNIT;
                }
                if (entry1.isDefined()) {
                    return result2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), entry1.get()));
                }
                return BoxedUnit.UNIT;
            });
            return result2;
        };
    }

    public <K> Map<K, Object> computeThresholdByKey(Map<K, AcceptanceResult> finalResult, Map<K, Object> fractions) {
        HashMap thresholdByKey = new HashMap();
        finalResult.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StratifiedSamplingUtils$.$anonfun$computeThresholdByKey$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                AcceptanceResult acceptResult = (AcceptanceResult)tuple2._2();
                long sampleSize = (long)scala.math.package$.MODULE$.ceil((double)acceptResult.numItems() * BoxesRunTime.unboxToDouble((Object)fractions.apply(key)));
                if (acceptResult.numAccepted() > sampleSize) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Pre-accepted too many");
                    return (HashMap)thresholdByKey.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToDouble((double)acceptResult.acceptBound())));
                }
                int numWaitListAccepted = (int)(sampleSize - acceptResult.numAccepted());
                if (numWaitListAccepted >= acceptResult.waitList().size()) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "WaitList too short");
                    return (HashMap)thresholdByKey.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)BoxesRunTime.boxToDouble((double)acceptResult.waitListBound())));
                }
                return (HashMap)thresholdByKey.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), ((ArrayBuffer)acceptResult.waitList().sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).apply(numWaitListAccepted)));
            }
            throw new MatchError((Object)tuple2);
        });
        return thresholdByKey;
    }

    public <K, V> Function2<Object, Iterator<Tuple2<K, V>>, Iterator<Tuple2<K, V>>> getBernoulliSamplingFunction(RDD<Tuple2<K, V>> rdd, Map<K, Object> fractions, boolean exact, long seed) {
        ObjectRef samplingRateByKey;
        block0: {
            samplingRateByKey = ObjectRef.create(fractions);
            if (!exact) break block0;
            scala.collection.mutable.Map<K, AcceptanceResult> finalResult = this.getAcceptanceResults(rdd, false, fractions, (Option<Map<K, Object>>)None$.MODULE$, seed);
            samplingRateByKey.elem = this.computeThresholdByKey((Map<K, AcceptanceResult>)finalResult, fractions);
        }
        return (Function2 & Serializable)(idx, iter) -> StratifiedSamplingUtils$.$anonfun$getBernoulliSamplingFunction$1(seed, samplingRateByKey, BoxesRunTime.unboxToInt((Object)idx), iter);
    }

    public <K, V> Function2<Object, Iterator<Tuple2<K, V>>, Iterator<Tuple2<K, V>>> getPoissonSamplingFunction(RDD<Tuple2<K, V>> rdd, Map<K, Object> fractions, boolean exact, long seed, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        if (exact) {
            RDD<Tuple2<K, V>> x$1 = rdd;
            ClassTag<K> x$2 = evidence$1;
            ClassTag<V> x$3 = evidence$2;
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            Some counts = new Some(RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).countByKey());
            scala.collection.mutable.Map finalResult = this.getAcceptanceResults(rdd, true, fractions, (Option<Map<K, Object>>)counts, seed);
            Map thresholdByKey = this.computeThresholdByKey((Map<K, AcceptanceResult>)finalResult, fractions);
            return (Function2 & Serializable)(idx, iter) -> StratifiedSamplingUtils$.$anonfun$getPoissonSamplingFunction$1(seed, finalResult, thresholdByKey, BoxesRunTime.unboxToInt((Object)idx), iter);
        }
        return (Function2 & Serializable)(idx, iter) -> StratifiedSamplingUtils$.$anonfun$getPoissonSamplingFunction$5(seed, fractions, BoxesRunTime.unboxToInt((Object)idx), iter);
    }

    public static final /* synthetic */ Iterator $anonfun$getAcceptanceResults$1(long seed$1, boolean withReplacement$1, Map fractions$1, Option counts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int partition = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            HashMap zeroU = new HashMap();
            StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
            rng.reSeed(seed$1 + (long)partition);
            Function2 seqOp = MODULE$.getSeqOp(withReplacement$1, fractions$1, rng, counts$1);
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.mutable.Map[]{(scala.collection.mutable.Map)iter.foldLeft((Object)zeroU, seqOp)}));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$computeThresholdByKey$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getBernoulliSamplingFunction$2(StratifiedSamplingUtils.RandomDataGenerator rng$2, ObjectRef samplingRateByKey$1, Tuple2 t) {
        return rng$2.nextUniform() < BoxesRunTime.unboxToDouble((Object)((Map)samplingRateByKey$1.elem).apply(t._1()));
    }

    public static final /* synthetic */ Iterator $anonfun$getBernoulliSamplingFunction$1(long seed$2, ObjectRef samplingRateByKey$1, int idx, Iterator iter) {
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$2 + (long)idx);
        return iter.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)StratifiedSamplingUtils$.$anonfun$getBernoulliSamplingFunction$2(rng, samplingRateByKey$1, t)));
    }

    public static final /* synthetic */ Iterator $anonfun$getPoissonSamplingFunction$1(long seed$3, scala.collection.mutable.Map finalResult$1, Map thresholdByKey$2, int idx, Iterator iter) {
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$3 + (long)idx);
        return iter.flatMap((Function1 & Serializable)item -> {
            Object key = item._1();
            double acceptBound = ((AcceptanceResult)finalResult$1.apply(key)).acceptBound();
            long copiesAccepted = acceptBound == 0.0 ? 0L : (long)rng.nextPoisson(acceptBound);
            int copiesWaitlisted = rng.nextPoisson(((AcceptanceResult)finalResult$1.apply(key)).waitListBound());
            long copiesInSample = copiesAccepted + (long)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), copiesWaitlisted).count((Function1)(JFunction1.mcZI.sp & Serializable)i -> rng.nextUniform() < BoxesRunTime.unboxToDouble((Object)thresholdByKey$2.apply(key)));
            if (copiesInSample > 0L) {
                return package$.MODULE$.Iterator().fill((int)copiesInSample, (Function0 & Serializable)() -> item);
            }
            return package$.MODULE$.Iterator().empty();
        });
    }

    public static final /* synthetic */ Iterator $anonfun$getPoissonSamplingFunction$5(long seed$3, Map fractions$4, int idx, Iterator iter) {
        StratifiedSamplingUtils.RandomDataGenerator rng = new StratifiedSamplingUtils.RandomDataGenerator();
        rng.reSeed(seed$3 + (long)idx);
        return iter.flatMap((Function1 & Serializable)item -> {
            int count = rng.nextPoisson(BoxesRunTime.unboxToDouble((Object)fractions$4.apply(item._1())));
            if (count == 0) {
                return package$.MODULE$.Iterator().empty();
            }
            return package$.MODULE$.Iterator().fill(count, (Function0 & Serializable)() -> item);
        });
    }

    private StratifiedSamplingUtils$() {
    }
}

