/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.netty;

import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import org.sparkproject.connect.grpc.EquivalentAddressGroup;
import org.sparkproject.connect.grpc.NameResolver;
import org.sparkproject.connect.guava.base.Preconditions;

final class UdsNameResolver
extends NameResolver {
    private NameResolver.Listener2 listener;
    private final String authority;

    UdsNameResolver(String authority, String targetPath) {
        Preconditions.checkArgument(authority == null, "non-null authority not supported");
        this.authority = targetPath;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState(this.listener == null, "already started");
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    @Override
    public void refresh() {
        this.resolve();
    }

    private void resolve() {
        NameResolver.ResolutionResult.Builder resolutionResultBuilder = NameResolver.ResolutionResult.newBuilder();
        ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>(1);
        servers.add(new EquivalentAddressGroup((SocketAddress)new DomainSocketAddress(this.authority)));
        resolutionResultBuilder.setAddresses(Collections.unmodifiableList(servers));
        this.listener.onResult(resolutionResultBuilder.build());
    }

    @Override
    public void shutdown() {
    }
}

