/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.StreamMetadata;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class StreamMetadata$
implements Logging,
Serializable {
    public static final StreamMetadata$ MODULE$ = new StreamMetadata$();
    private static final Formats format;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        format = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Formats format() {
        return format;
    }

    public Option<StreamMetadata> read(Path metadataFile, Configuration hadoopConf) {
        None$ none$;
        CheckpointFileManager fileManager = CheckpointFileManager$.MODULE$.create(metadataFile.getParent(), hadoopConf);
        if (fileManager.exists(metadataFile)) {
            FSDataInputStream input = null;
            try {
                try {
                    input = fileManager.open(metadataFile);
                    InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
                    StreamMetadata metadata = (StreamMetadata)Serialization$.MODULE$.read((Reader)reader, this.format(), ManifestFactory$.MODULE$.classType(StreamMetadata.class));
                    none$ = new Some((Object)metadata);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Error reading stream metadata from ").append(metadataFile).toString(), e);
                        throw e;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void write(StreamMetadata metadata, Path metadataFile, Configuration hadoopConf) {
        CheckpointFileManager.CancellableFSDataOutputStream output = null;
        try {
            CheckpointFileManager fileManager = CheckpointFileManager$.MODULE$.create(metadataFile.getParent(), hadoopConf);
            output = fileManager.createAtomic(metadataFile, false);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)output));
            Serialization$.MODULE$.write((Object)metadata, (Writer)writer, this.format());
            writer.close();
        }
        catch (FileAlreadyExistsException e) {
            if (output != null) {
                output.cancel();
            }
            throw QueryExecutionErrors$.MODULE$.multiStreamingQueriesUsingPathConcurrentlyError(metadataFile.getName(), e);
        }
        catch (Throwable e) {
            if (output != null) {
                output.cancel();
            }
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Error writing stream metadata ").append(metadata).append(" to ").append(metadataFile).toString(), e);
            throw e;
        }
    }

    public StreamMetadata apply(String id) {
        return new StreamMetadata(id);
    }

    public Option<String> unapply(StreamMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.id());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StreamMetadata$.class);
    }

    private StreamMetadata$() {
    }
}

