/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.execution.RowToColumnConverter;
import org.apache.spark.sql.execution.datasources.v2.V2ColumnUtils$;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class AggregatePushDownUtils$ {
    public static final AggregatePushDownUtils$ MODULE$ = new AggregatePushDownUtils$();

    public Option<StructType> getSchemaForPushedAggregation(Aggregation aggregation, StructType schema, Set<String> partitionNames, Seq<org.apache.spark.sql.catalyst.expressions.Expression> dataFilters) {
        Option option;
        Object object = new Object();
        try {
            ObjectRef finalSchema = ObjectRef.create((Object)new StructType());
            if (dataFilters.nonEmpty()) {
                return None$.MODULE$;
            }
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions())) && partitionNames.size() != aggregation.groupByExpressions().length) {
                return None$.MODULE$;
            }
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions()), (Function1 & Serializable)v2Expr -> MODULE$.extractColName((Expression)v2Expr), ClassTag$.MODULE$.apply(Option.class))), (Function1 & Serializable)colName -> {
                AggregatePushDownUtils$.$anonfun$getSchemaForPushedAggregation$2(object, finalSchema, partitionNames, schema, colName);
                return BoxedUnit.UNIT;
            });
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.aggregateExpressions()), (Function1 & Serializable)x0$1 -> {
                AggregatePushDownUtils$.$anonfun$getSchemaForPushedAggregation$3(object, finalSchema, partitionNames, schema, x0$1);
                return BoxedUnit.UNIT;
            });
            option = new Some((Object)((StructType)finalSchema.elem));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public boolean equivalentAggregations(Aggregation a, Aggregation b) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])a.aggregateExpressions()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.hashCode()), (Ordering)Ordering.Int$.MODULE$)).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])b.aggregateExpressions()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.hashCode()), (Ordering)Ordering.Int$.MODULE$))) && Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])a.groupByExpressions()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.hashCode()), (Ordering)Ordering.Int$.MODULE$)).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])b.groupByExpressions()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.hashCode()), (Ordering)Ordering.Int$.MODULE$)));
    }

    public ColumnarBatch convertAggregatesRowToBatch(InternalRow aggregatesAsRow, StructType aggregatesSchema, boolean offHeap) {
        RowToColumnConverter converter = new RowToColumnConverter(aggregatesSchema);
        WritableColumnVector[] columnVectors = offHeap ? (WritableColumnVector[])OffHeapColumnVector.allocateColumns(1, aggregatesSchema) : (WritableColumnVector[])OnHeapColumnVector.allocateColumns(1, aggregatesSchema);
        converter.convert(aggregatesAsRow, (WritableColumnVector[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])columnVectors), ClassTag$.MODULE$.apply(WritableColumnVector.class)));
        return new ColumnarBatch((ColumnVector[])columnVectors, 1);
    }

    public StructType getSchemaWithoutGroupingExpression(StructType aggSchema, Aggregation aggregation) {
        int numOfGroupByColumns = aggregation.groupByExpressions().length;
        return numOfGroupByColumns > 0 ? new StructType((StructField[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])aggSchema.fields()), numOfGroupByColumns)) : aggSchema;
    }

    public InternalRow reOrderPartitionCol(StructType partitionSchema, Aggregation aggregation, InternalRow partitionValues) {
        InternalRow internalRow;
        String[] groupByColNames = (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])aggregation.groupByExpressions()), (Function1 & Serializable)v2Expr -> MODULE$.extractColName((Expression)v2Expr), ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.assert(groupByColNames.length == partitionSchema.length() && groupByColNames.length == partitionValues.numFields(), (Function0 & Serializable)() -> new StringBuilder(31).append("The number of group by columns ").append(new StringBuilder(47).append(groupByColNames.length).append(" should be the same as partition schema length ").toString()).append(new StringBuilder(27).append(partitionSchema.length()).append(" and the number of fields ").append(partitionValues.numFields()).append(" ").toString()).append("in partitionValues").toString());
        ObjectRef reorderedPartColValues = ObjectRef.create((Object)((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Any())));
        if (!Predef$.MODULE$.wrapRefArray((Object[])partitionSchema.names()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])groupByColNames))) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])groupByColNames), (Function1 & Serializable)col -> {
                AggregatePushDownUtils$.$anonfun$reOrderPartitionCol$3(partitionSchema, partitionValues, reorderedPartColValues, col);
                return BoxedUnit.UNIT;
            });
            internalRow = new GenericInternalRow((Object[])reorderedPartColValues.elem);
        } else {
            internalRow = partitionValues;
        }
        return internalRow;
    }

    private Option<String> extractColName(Expression v2Expr) {
        FieldReference fieldReference;
        Expression expression = v2Expr;
        Object object = expression instanceof FieldReference && (fieldReference = (FieldReference)expression).fieldNames().length == 1 ? new Some(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])fieldReference.fieldNames()))) : None$.MODULE$;
        return object;
    }

    private static final StructField getStructFieldForCol$1(String colName, StructType schema$1) {
        return schema$1.apply(colName);
    }

    private static final boolean isPartitionCol$1(String colName, Set partitionNames$1) {
        return partitionNames$1.contains((Object)colName);
    }

    private static final boolean processMinOrMax$1(AggregateFunc agg, ObjectRef finalSchema$1, Set partitionNames$1, StructType schema$1) {
        boolean bl;
        Min min;
        Tuple2 tuple2;
        Max max;
        AggregateFunc aggregateFunc = agg;
        if (aggregateFunc instanceof Max && V2ColumnUtils$.MODULE$.extractV2Column((max = (Max)aggregateFunc).column()).isDefined()) {
            tuple2 = new Tuple2(V2ColumnUtils$.MODULE$.extractV2Column(max.column()).get(), (Object)"max");
        } else if (aggregateFunc instanceof Min && V2ColumnUtils$.MODULE$.extractV2Column((min = (Min)aggregateFunc).column()).isDefined()) {
            tuple2 = new Tuple2(V2ColumnUtils$.MODULE$.extractV2Column(min.column()).get(), (Object)"min");
        } else {
            return false;
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String columnName = (String)tuple22._1();
        String aggType = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)columnName, (Object)aggType);
        Tuple2 tuple24 = tuple23;
        String columnName2 = (String)tuple24._1();
        String aggType2 = (String)tuple24._2();
        if (AggregatePushDownUtils$.isPartitionCol$1(columnName2, partitionNames$1)) {
            return false;
        }
        StructField structField = AggregatePushDownUtils$.getStructFieldForCol$1(columnName2, schema$1);
        DataType dataType = structField.dataType();
        boolean bl2 = BooleanType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType)))))));
        if (bl2) {
            finalSchema$1.elem = ((StructType)finalSchema$1.elem).add(structField.copy(new StringBuilder(1).append(new StringBuilder(1).append(aggType2).append("(").toString()).append(structField.name()).append(")").toString(), structField.copy$default$2(), structField.copy$default$3(), structField.copy$default$4()));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getSchemaForPushedAggregation$2(Object nonLocalReturnKey1$1, ObjectRef finalSchema$1, Set partitionNames$1, StructType schema$1, Option colName) {
        if (colName.isEmpty() || !AggregatePushDownUtils$.isPartitionCol$1((String)colName.get(), partitionNames$1)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)None$.MODULE$);
        }
        finalSchema$1.elem = ((StructType)finalSchema$1.elem).add(AggregatePushDownUtils$.getStructFieldForCol$1((String)colName.get(), schema$1));
    }

    public static final /* synthetic */ void $anonfun$getSchemaForPushedAggregation$3(Object nonLocalReturnKey1$1, ObjectRef finalSchema$1, Set partitionNames$1, StructType schema$1, AggregateFunc x0$1) {
        Count count;
        AggregateFunc aggregateFunc = x0$1;
        if (aggregateFunc instanceof Max) {
            Max max = (Max)aggregateFunc;
            if (!AggregatePushDownUtils$.processMinOrMax$1((AggregateFunc)max, finalSchema$1, partitionNames$1, schema$1)) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)None$.MODULE$);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aggregateFunc instanceof Min) {
            Min min = (Min)aggregateFunc;
            if (!AggregatePushDownUtils$.processMinOrMax$1((AggregateFunc)min, finalSchema$1, partitionNames$1, schema$1)) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)None$.MODULE$);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aggregateFunc instanceof Count && V2ColumnUtils$.MODULE$.extractV2Column((count = (Count)aggregateFunc).column()).isDefined() && !count.isDistinct()) {
            String columnName = (String)V2ColumnUtils$.MODULE$.extractV2Column(count.column()).get();
            finalSchema$1.elem = ((StructType)finalSchema$1.elem).add(new StructField(new StringBuilder(7).append("count(").append(columnName).append(")").toString(), (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aggregateFunc instanceof CountStar) {
            finalSchema$1.elem = ((StructType)finalSchema$1.elem).add(new StructField("count(*)", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)None$.MODULE$);
        }
    }

    public static final /* synthetic */ void $anonfun$reOrderPartitionCol$3(StructType partitionSchema$1, InternalRow partitionValues$1, ObjectRef reorderedPartColValues$1, String col) {
        Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])partitionSchema$1.names());
        String x$1 = col;
        int x$2 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1);
        int index = ArrayOps$.MODULE$.indexOf$extension(qual$1, (Object)x$1, x$2);
        Object v = ((GenericInternalRow)partitionValues$1).values()[index];
        reorderedPartColValues$1.elem = (Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.genericArrayOps((Object)((Object[])reorderedPartColValues$1.elem)), v, ClassTag$.MODULE$.Any());
    }

    private AggregatePushDownUtils$() {
    }
}

