/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.KeyValueGroupedDataset;
import org.apache.spark.sql.RelationalGroupedDataset$;
import org.apache.spark.sql.RelationalGroupedDataset$CubeType$;
import org.apache.spark.sql.RelationalGroupedDataset$GroupByType$;
import org.apache.spark.sql.RelationalGroupedDataset$RollupType$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.Star;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cube;
import org.apache.spark.sql.catalyst.expressions.Cube$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.Rollup;
import org.apache.spark.sql.catalyst.expressions.Rollup$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapCoGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandasWithState;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInR$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Pivot;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Stable
@ScalaSignature(bytes="\u0006\u0005\ruh\u0001\u0002&L\u0001QC\u0011b\u0017\u0001\u0003\u0006\u0004%\ta\u0013/\t\u0011\u0015\u0004!\u0011!Q\u0001\nuC\u0011B\u001a\u0001\u0003\u0006\u0004%\taS4\t\u0011m\u0004!\u0011!Q\u0001\n!D\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\t\u0003\u000b\u0001A\u0011C&\u0003\u0004\"A!1\u0012\u0001!\n\u0013\u0011i\t\u0003\u0005\u0003\u0014\u0002\u0001K\u0011\u0002BK\u0011!\u0011I\f\u0001Q\u0005\n\tm\u0006b\u0002Ba\u0001\u0011\u0005!1\u0019\u0005\b\u0005g\u0004A\u0011\u0001B{\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0007\u0003AqAa=\u0001\t\u0003\u0019i\u0001C\u0004\u0003t\u0002!\taa\u0007\t\u000f\rM\u0002\u0001\"\u0001\u00046!91q\u0007\u0001\u0005\u0002\re\u0002bBB \u0001\u0011\u00051\u0011\t\u0005\b\u0007\u000f\u0002A\u0011AB%\u0011\u001d\u0019y\u0005\u0001C\u0001\u0007#Bqaa\u0016\u0001\t\u0003\u0019I\u0006C\u0004\u0004`\u0001!\ta!\u0019\t\u000f\r}\u0003\u0001\"\u0001\u0004h!91q\f\u0001\u0005\u0002\r=\u0004bBB0\u0001\u0011\u000511\u0010\u0005\b\u0007?\u0002A\u0011AB@\u0011\u001d\u0019y\u0006\u0001C\u0001\u0007\u000bC\u0001ba#\u0001\t\u0003Y5Q\u0012\u0005\t\u0007\u0007\u0004A\u0011A&\u0004F\"A1q\u001a\u0001\u0005\u0002-\u001b\t\u000e\u0003\u0005\u0004Z\u0002!\taSBn\u0011\u001d\t9\u0003\u0001C!\u0003S9qa`&\t\u0002-\u000b\tAB\u0004K\u0017\"\u00051*a\u0001\t\u000f\u0005\u0015\u0011\u0005\"\u0001\u0002\b!9\u0011\u0011B\u0011\u0005\u0002\u0005-\u0001\u0002CA\u001eC\u0011\u00051*!\u0010\t\u000f\u0005e\u0014\u0005\"\u0003\u0002|\u0019Q\u0011\u0011D\u0011\u0011\u0002\u0007\u00051*a\u0007\t\u000f\u0005ua\u0005\"\u0001\u0002 !9\u0011q\u0005\u0014\u0005B\u0005%r\u0001CADC!\u00051*!#\u0007\u0011\u0005-\u0015\u0005#\u0001L\u0003\u001bCq!!\u0002+\t\u0003\tyi\u0002\u0005\u0002\u0012\u0006B\taSAJ\r!\t)*\tE\u0001\u0017\u0006]\u0005bBA\u0003[\u0011\u0005\u0011\u0011T\u0004\t\u00037\u000b\u0003\u0012A&\u0002\u001e\u001aA\u0011qT\u0011\t\u0002-\u000b\t\u000bC\u0004\u0002\u0006A\"\t!a)\u0007\u000f\u0005\u0015\u0016\u0005Q&\u0002(\"Q\u0011Q\u0017\u001a\u0003\u0016\u0004%\t!a.\t\u0013\u0005e&G!E!\u0002\u0013\u0019\b\"CA^e\tU\r\u0011\"\u0001h\u0011%\tiL\rB\tB\u0003%\u0001\u000eC\u0004\u0002\u0006I\"\t!a0\t\u0013\u0005\u001d''!A\u0005\u0002\u0005%\u0007\"CAheE\u0005I\u0011AAi\u0011%\t9OMI\u0001\n\u0003\tI\u000fC\u0005\u0002nJ\n\t\u0011\"\u0011\u0002p\"I\u0011q \u001a\u0002\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005\u0013\u0011\u0014\u0011!C\u0001\u0005\u0017A\u0011Ba\u00063\u0003\u0003%\tE!\u0007\t\u0013\t\u001d\"'!A\u0005\u0002\t%\u0002\"\u0003B\u001ae\u0005\u0005I\u0011\tB\u001b\u0011%\u0011IDMA\u0001\n\u0003\u0012Y\u0004C\u0005\u0003>I\n\t\u0011\"\u0011\u0003@\u001dQ!1I\u0011\u0002\u0002#\u00051J!\u0012\u0007\u0015\u0005\u0015\u0016%!A\t\u0002-\u00139\u0005C\u0004\u0002\u0006\u0011#\tAa\u0018\t\u0013\u0005\u001dB)!A\u0005F\t\u0005\u0004\"CA\u0005\t\u0006\u0005I\u0011\u0011B2\u0011%\u0011I\u0007RA\u0001\n\u0003\u0013Y\u0007C\u0005\u0003z\u0011\u000b\t\u0011\"\u0003\u0003|\tA\"+\u001a7bi&|g.\u00197He>,\b/\u001a3ECR\f7/\u001a;\u000b\u00051k\u0015aA:rY*\u0011ajT\u0001\u0006gB\f'o\u001b\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&AB!osJ+g-\u0001\u0002eMV\tQ\f\u0005\u0002_E:\u0011q\fY\u0007\u0002\u0017&\u0011\u0011mS\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GMA\u0005ECR\fgI]1nK*\u0011\u0011mS\u0001\u0004I\u001a\u0004\u0013!D4s_V\u0004\u0018N\\4FqB\u00148/F\u0001i!\rI\u0007o\u001d\b\u0003U>t!a\u001b8\u000e\u00031T!!\\*\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0016BA1X\u0013\t\t(OA\u0002TKFT!!Y,\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018aC3yaJ,7o]5p]NT!\u0001_&\u0002\u0011\r\fG/\u00197zgRL!A_;\u0003\u0015\u0015C\bO]3tg&|g.\u0001\bhe>,\b/\u001b8h\u000bb\u0004(o\u001d\u0011\u0002\u0013\u001d\u0014x.\u001e9UsB,\u0007C\u0001@'\u001d\ty\u0006%\u0001\rSK2\fG/[8oC2<%o\\;qK\u0012$\u0015\r^1tKR\u0004\"aX\u0011\u0014\u0005\u0005*\u0016A\u0002\u001fj]&$h\b\u0006\u0002\u0002\u0002\u0005)\u0011\r\u001d9msRA\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0002`\u0001!)1l\ta\u0001;\")am\ta\u0001Q\"1Ap\ta\u0001\u0003+\u00012!a\u0006'\u001b\u0005\t#!C$s_V\u0004H+\u001f9f'\t1S+\u0001\u0004%S:LG\u000f\n\u000b\u0003\u0003C\u00012AVA\u0012\u0013\r\t)c\u0016\u0002\u0005+:LG/\u0001\u0005u_N#(/\u001b8h)\t\tY\u0003\u0005\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003c\u0001\"a[,\n\u0007\u0005Mr+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g9\u0016\u0001\u00075b]\u0012dWm\u0012:pkBLgnZ#yaJ,7o]5p]RA\u0011qHA-\u0003[\n9\bE\u0004W\u0003\u0003\n)%!\u0015\n\u0007\u0005\rsK\u0001\u0004UkBdWM\r\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J&\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BA(\u0003\u0013\u0012a\"U;fef,\u00050Z2vi&|g\u000e\u0005\u0003ja\u0006M\u0003c\u0001;\u0002V%\u0019\u0011qK;\u0003\u0013\u0005#HO]5ckR,\u0007bBA.I\u0001\u0007\u0011QL\u0001\fY><\u0017nY1m!2\fg\u000e\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u000f1|w-[2bY*\u0019\u0011qM<\u0002\u000bAd\u0017M\\:\n\t\u0005-\u0014\u0011\r\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0004\u0002p\u0011\u0002\r!!\u001d\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0007}\u000b\u0019(C\u0002\u0002v-\u0013Ab\u00159be.\u001cVm]:j_:DQA\u001a\u0013A\u0002!\fQ!\u00197jCN$B!! \u0002\u0004B\u0019A/a \n\u0007\u0005\u0005UOA\bOC6,G-\u0012=qe\u0016\u001c8/[8o\u0011\u0019\t))\na\u0001g\u0006!Q\r\u001f9s\u0003-9%o\\;q\u0005f$\u0016\u0010]3\u0011\u0007\u0005]!FA\u0006He>,\bOQ=UsB,7\u0003\u0002\u0016V\u0003+!\"!!#\u0002\u0011\r+(-\u001a+za\u0016\u00042!a\u0006.\u0005!\u0019UOY3UsB,7\u0003B\u0017V\u0003+!\"!a%\u0002\u0015I{G\u000e\\;q)f\u0004X\rE\u0002\u0002\u0018A\u0012!BU8mYV\u0004H+\u001f9f'\u0011\u0001T+!\u0006\u0015\u0005\u0005u%!\u0003)jm>$H+\u001f9f'!\u0011T+!\u0006\u0002*\u0006=\u0006c\u0001,\u0002,&\u0019\u0011QV,\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0011.!-\n\u0007\u0005M&O\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005qSZ|GoQ8m+\u0005\u0019\u0018!\u00039jm>$8i\u001c7!\u0003\u00191\u0018\r\\;fg\u00069a/\u00197vKN\u0004CCBAa\u0003\u0007\f)\rE\u0002\u0002\u0018IBa!!.8\u0001\u0004\u0019\bBBA^o\u0001\u0007\u0001.\u0001\u0003d_BLHCBAa\u0003\u0017\fi\r\u0003\u0005\u00026b\u0002\n\u00111\u0001t\u0011!\tY\f\u000fI\u0001\u0002\u0004A\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003'T3a]AkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAq/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WT3\u0001[Ak\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001f\t\u0005\u0003g\fi0\u0004\u0002\u0002v*!\u0011q_A}\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0018\u0001\u00026bm\u0006LA!a\u000e\u0002v\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!1\u0001\t\u0004-\n\u0015\u0011b\u0001B\u0004/\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0002B\n!\r1&qB\u0005\u0004\u0005#9&aA!os\"I!QC\u001f\u0002\u0002\u0003\u0007!1A\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0001C\u0002B\u000f\u0005G\u0011i!\u0004\u0002\u0003 )\u0019!\u0011E,\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003&\t}!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u000b\u00032A\u0019aK!\f\n\u0007\t=rKA\u0004C_>dW-\u00198\t\u0013\tUq(!AA\u0002\t5\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!=\u00038!I!Q\u0003!\u0002\u0002\u0003\u0007!1A\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!1A\u0001\u0007KF,\u0018\r\\:\u0015\t\t-\"\u0011\t\u0005\n\u0005+\u0011\u0015\u0011!a\u0001\u0005\u001b\t\u0011\u0002U5w_R$\u0016\u0010]3\u0011\u0007\u0005]AiE\u0003E\u0005\u0013\u0012)\u0006\u0005\u0005\u0003L\tE3\u000f[Aa\u001b\t\u0011iEC\u0002\u0003P]\u000bqA];oi&lW-\u0003\u0003\u0003T\t5#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!q\u000bB/\u001b\t\u0011IF\u0003\u0003\u0003\\\u0005e\u0018AA5p\u0013\u0011\t\u0019L!\u0017\u0015\u0005\t\u0015CCAAy)\u0019\t\tM!\u001a\u0003h!1\u0011QW$A\u0002MDa!a/H\u0001\u0004A\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005[\u0012)\bE\u0003W\u0005_\u0012\u0019(C\u0002\u0003r]\u0013aa\u00149uS>t\u0007#\u0002,\u0002BMD\u0007\"\u0003B<\u0011\u0006\u0005\t\u0019AAa\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005{\u0002B!a=\u0003\u0000%!!\u0011QA{\u0005\u0019y%M[3diRA\u0011Q\u0002BC\u0005\u000f\u0013I\tC\u0003\\\r\u0001\u0007Q\fC\u0003g\r\u0001\u0007\u0001\u000eC\u0003}\r\u0001\u0007Q0\u0001\u0003u_\u00123EcA/\u0003\u0010\"1!\u0011S\u0004A\u0002!\f\u0001\"Y4h\u000bb\u0004(o]\u0001\u0018C\u001e<'/Z4bi\u0016tU/\\3sS\u000e\u001cu\u000e\\;n]N$BAa&\u00030R\u0019QL!'\t\u000f\tm\u0005\u00021\u0001\u0003\u001e\u0006\ta\r\u0005\u0004W\u0005?\u001b(1U\u0005\u0004\u0005C;&!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011)Ka+\u000e\u0005\t\u001d&b\u0001BUk\u0006I\u0011mZ4sK\u001e\fG/Z\u0005\u0005\u0005[\u00139KA\tBO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:DqA!-\t\u0001\u0004\u0011\u0019,\u0001\u0005d_2t\u0015-\\3t!\u00151&QWA\u0016\u0013\r\u00119l\u0016\u0002\u000byI,\u0007/Z1uK\u0012t\u0014!C:ueR{W\t\u001f9s)\u0011\u0011iLa0\u0011\u000bY\u0013yj]:\t\u000f\u0005\u0015\u0015\u00021\u0001\u0002,\u0005\u0011\u0011m]\u000b\u0007\u0005\u000b\u0014\tNa8\u0015\r\t\u001d'1\u001dBw!\u001dy&\u0011\u001aBg\u0005;L1Aa3L\u0005YYU-\u001f,bYV,wI]8va\u0016$G)\u0019;bg\u0016$\b\u0003\u0002Bh\u0005#d\u0001\u0001B\u0004\u0003T*\u0011\rA!6\u0003\u0003-\u000bBAa6\u0003\u000eA\u0019aK!7\n\u0007\tmwKA\u0004O_RD\u0017N\\4\u0011\t\t='q\u001c\u0003\b\u0005CT!\u0019\u0001Bk\u0005\u0005!\u0006\"\u0003Bs\u0015\u0005\u0005\t9\u0001Bt\u0003))g/\u001b3f]\u000e,G%\r\t\u0006?\n%(QZ\u0005\u0004\u0005W\\%aB#oG>$WM\u001d\u0005\n\u0005_T\u0011\u0011!a\u0002\u0005c\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0015y&\u0011\u001eBo\u0003\r\twm\u001a\u000b\u0006;\n](Q \u0005\b\u0005s\\\u0001\u0019\u0001B~\u0003\u001d\twmZ#yaJ\u0004rAVA!\u0003W\tY\u0003C\u0004\u0003\u0012.\u0001\rAa@\u0011\u000bY\u0013)La?\u0015\u0007u\u001b\u0019\u0001C\u0004\u0004\u00061\u0001\raa\u0002\u0002\u000b\u0015D\bO]:\u0011\u0011\u000552\u0011BA\u0016\u0003WIAaa\u0003\u0002:\t\u0019Q*\u00199\u0015\u0007u\u001by\u0001C\u0004\u0004\u00065\u0001\ra!\u0005\u0011\u0011\rM1\u0011DA\u0016\u0003Wi!a!\u0006\u000b\t\r]\u0011\u0011`\u0001\u0005kRLG.\u0003\u0003\u0004\f\rUA#B/\u0004\u001e\r\u0015\u0002bBAC\u001d\u0001\u00071q\u0004\t\u0004?\u000e\u0005\u0012bAB\u0012\u0017\n11i\u001c7v[:Dqa!\u0002\u000f\u0001\u0004\u00199\u0003E\u0003W\u0005k\u001by\u0002K\u0002\u000f\u0007W\u0001Ba!\f\u000405\u0011\u0011q\\\u0005\u0005\u0007c\tyNA\u0004wCJ\f'oZ:\u0002\u000b\r|WO\u001c;\u0015\u0003u\u000bA!\\3b]R\u0019Qla\u000f\t\u000f\tE\u0006\u00031\u0001\u00034\"\u001a\u0001ca\u000b\u0002\u00075\f\u0007\u0010F\u0002^\u0007\u0007BqA!-\u0012\u0001\u0004\u0011\u0019\fK\u0002\u0012\u0007W\t1!\u0019<h)\ri61\n\u0005\b\u0005c\u0013\u0002\u0019\u0001BZQ\r\u001121F\u0001\u0004[&tGcA/\u0004T!9!\u0011W\nA\u0002\tM\u0006fA\n\u0004,\u0005\u00191/^7\u0015\u0007u\u001bY\u0006C\u0004\u00032R\u0001\rAa-)\u0007Q\u0019Y#A\u0003qSZ|G\u000f\u0006\u0003\u0002\u000e\r\r\u0004bBB3+\u0001\u0007\u00111F\u0001\fa&4x\u000e^\"pYVlg\u000e\u0006\u0004\u0002\u000e\r%41\u000e\u0005\b\u0007K2\u0002\u0019AA\u0016\u0011\u001d\tYL\u0006a\u0001\u0007[\u0002B!\u001b9\u0003\u000eQ1\u0011QBB9\u0007gBqa!\u001a\u0018\u0001\u0004\tY\u0003C\u0004\u0002<^\u0001\ra!\u001e\u0011\r\rM1q\u000fB\u0007\u0013\u0011\u0019Ih!\u0006\u0003\t1K7\u000f\u001e\u000b\u0005\u0003\u001b\u0019i\bC\u0004\u0004fa\u0001\raa\b\u0015\r\u000551\u0011QBB\u0011\u001d\u0019)'\u0007a\u0001\u0007?Aq!a/\u001a\u0001\u0004\u0019i\u0007\u0006\u0004\u0002\u000e\r\u001d5\u0011\u0012\u0005\b\u0007KR\u0002\u0019AB\u0010\u0011\u001d\tYL\u0007a\u0001\u0007k\n\u0001C\u001a7bi6\u000b\u0007o\u0012:pkB\u001c\u0018J\u001c*\u0015\u0013u\u001byi!(\u0004\"\u000eM\u0006b\u0002BN7\u0001\u00071\u0011\u0013\t\u0006-\u000eM5qS\u0005\u0004\u0007+;&!B!se\u0006L\bc\u0001,\u0004\u001a&\u001911T,\u0003\t\tKH/\u001a\u0005\b\u0007?[\u0002\u0019ABI\u00031\u0001\u0018mY6bO\u0016t\u0015-\\3t\u0011\u001d\u0019\u0019k\u0007a\u0001\u0007K\u000bQB\u0019:pC\u0012\u001c\u0017m\u001d;WCJ\u001c\b#\u0002,\u0004\u0014\u000e\u001d\u0006CBBU\u0007_\u0013i(\u0004\u0002\u0004,*\u00191QV'\u0002\u0013\t\u0014x.\u00193dCN$\u0018\u0002BBY\u0007W\u0013\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\t\u000f\rU6\u00041\u0001\u00048\u0006aq.\u001e;qkR\u001c6\r[3nCB!1\u0011XB`\u001b\t\u0019YLC\u0002\u0004>.\u000bQ\u0001^=qKNLAa!1\u0004<\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002+\u0019d\u0017\r^'ba\u001e\u0013x.\u001e9t\u0013:\u0004\u0016M\u001c3bgR\u0019Qla2\t\u000f\u0005\u0015E\u00041\u0001\u0004JB\u0019Aoa3\n\u0007\r5WOA\u0005QsRDwN\\+E\r\u00069b\r\\1u\u001b\u0006\u00048i\\$s_V\u00048/\u00138QC:$\u0017m\u001d\u000b\u0006;\u000eM7q\u001b\u0005\b\u0007+l\u0002\u0019AA\u0007\u0003\u0005\u0011\bbBAC;\u0001\u00071\u0011Z\u0001\u0017CB\u0004H._%o!\u0006tG-Y:XSRD7\u000b^1uKRYQl!8\u0004b\u000e\u00158\u0011^Bw\u0011\u001d\u0019yN\ba\u0001\u0007\u0013\fAAZ;oG\"911\u001d\u0010A\u0002\r]\u0016\u0001E8viB,Ho\u0015;sk\u000e$H+\u001f9f\u0011\u001d\u00199O\ba\u0001\u0007o\u000bqb\u001d;bi\u0016\u001cFO];diRK\b/\u001a\u0005\b\u0007Wt\u0002\u0019AA\u0016\u00035yW\u000f\u001e9vi6{G-Z*ue\"91q\u001e\u0010A\u0002\u0005-\u0012A\u0004;j[\u0016|W\u000f^\"p]\u001a\u001cFO\u001d\u0015\u0004\u0001\rM\b\u0003BB{\u0007sl!aa>\u000b\u0007\u0005\u0005X*\u0003\u0003\u0004|\u000e](AB*uC\ndW\r")
public class RelationalGroupedDataset {
    private final Dataset<Row> df;
    private final Seq<Expression> groupingExprs;
    private final GroupType groupType;

    public static RelationalGroupedDataset apply(Dataset<Row> df, Seq<Expression> groupingExprs, GroupType groupType) {
        return RelationalGroupedDataset$.MODULE$.apply(df, groupingExprs, groupType);
    }

    public Dataset<Row> agg(Column expr, Column ... exprs) {
        return this.agg(expr, (Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> mean(String ... colNames) {
        return this.mean((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> max(String ... colNames) {
        return this.max((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> avg(String ... colNames) {
        return this.avg((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> min(String ... colNames) {
        return this.min((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> sum(String ... colNames) {
        return this.sum((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> df() {
        return this.df;
    }

    public Seq<Expression> groupingExprs() {
        return this.groupingExprs;
    }

    private Dataset<Row> toDF(Seq<Expression> aggExprs) {
        Dataset<Row> dataset;
        Seq seq;
        if (this.df().sparkSession().sessionState().conf().dataFrameRetainGroupColumns()) {
            Seq seq2;
            Seq<Expression> seq3 = this.groupingExprs();
            if (seq3 instanceof Stream) {
                Stream stream = (Stream)seq3;
                seq2 = (Seq)stream.toList().$plus$plus(aggExprs);
            } else {
                seq2 = (Seq)seq3.$plus$plus(aggExprs);
            }
            seq = seq2;
        } else {
            seq = aggExprs;
        }
        Seq aggregates = seq;
        Seq aliasedAgg = (Seq)aggregates.map((Function1 & Serializable)expr -> RelationalGroupedDataset$.MODULE$.org$apache$spark$sql$RelationalGroupedDataset$$alias((Expression)expr));
        GroupType groupType = this.groupType;
        if (RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate(this.groupingExprs(), aliasedAgg, this.df().logicalPlan()));
        } else if (RelationalGroupedDataset$RollupType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rollup[]{Rollup$.MODULE$.apply((Seq)this.groupingExprs().map((Function1 & Serializable)x$1 -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{x$1}))))})), aliasedAgg, this.df().logicalPlan()));
        } else if (RelationalGroupedDataset$CubeType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cube[]{Cube$.MODULE$.apply((Seq)this.groupingExprs().map((Function1 & Serializable)x$2 -> (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{x$2}))))})), aliasedAgg, this.df().logicalPlan()));
        } else if (groupType instanceof PivotType) {
            PivotType pivotType = (PivotType)groupType;
            Expression pivotCol = pivotType.pivotCol();
            Seq<Expression> values = pivotType.values();
            Seq aliasedGrps = (Seq)this.groupingExprs().map((Function1 & Serializable)expr -> RelationalGroupedDataset$.MODULE$.org$apache$spark$sql$RelationalGroupedDataset$$alias((Expression)expr));
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Pivot((Option)new Some((Object)aliasedGrps), pivotCol, values, aggExprs, this.df().logicalPlan()));
        } else {
            throw new MatchError((Object)groupType);
        }
        return dataset;
    }

    private Dataset<Row> aggregateNumericColumns(Seq<String> colNames, Function1<Expression, AggregateFunction> f) {
        Seq columnExprs = colNames.isEmpty() ? this.df().numericColumns() : (Seq)colNames.map((Function1 & Serializable)colName -> {
            void var2_2;
            NamedExpression namedExpr = this.df().resolve((String)colName);
            if (!(((Expression)namedExpr).dataType() instanceof NumericType)) {
                throw QueryCompilationErrors$.MODULE$.aggregationFunctionAppliedOnNonNumericColumnError(colName);
            }
            return var2_2;
        });
        return this.toDF((Seq<Expression>)((Seq)columnExprs.map((Function1 & Serializable)expr -> ((AggregateFunction)f.apply(expr)).toAggregateExpression())));
    }

    private Function1<Expression, Expression> strToExpr(String expr) {
        Function1 & Serializable exprToFunc = (Function1 & Serializable)inputExpr -> {
            UnresolvedFunction unresolvedFunction;
            block15: {
                String string;
                block12: {
                    block14: {
                        block13: {
                            string = expr.toLowerCase(Locale.ROOT);
                            switch (string == null ? 0 : string.hashCode()) {
                                case -892408046: {
                                    if (!"stddev".equals(string)) break block12;
                                    break block13;
                                }
                                case -631448035: {
                                    if ("average".equals(string)) {
                                        break;
                                    }
                                    break block12;
                                }
                                case 96978: {
                                    if ("avg".equals(string)) {
                                        break;
                                    }
                                    break block12;
                                }
                                case 114211: {
                                    if (!"std".equals(string)) break block12;
                                    break block13;
                                }
                                case 3347397: {
                                    if ("mean".equals(string)) {
                                        break;
                                    }
                                    break block12;
                                }
                                case 3530753: {
                                    if (!"size".equals(string)) break block12;
                                    break block14;
                                }
                                case 94851343: {
                                    if (!"count".equals(string)) break block12;
                                    break block14;
                                }
                                default: {
                                    break block12;
                                }
                            }
                            Expression expression = inputExpr;
                            unresolvedFunction = UnresolvedFunction$.MODULE$.apply("avg", (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)expression), false);
                            break block15;
                        }
                        Expression expression = inputExpr;
                        unresolvedFunction = UnresolvedFunction$.MODULE$.apply("stddev", (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)expression), false);
                        break block15;
                    }
                    Expression expression = inputExpr;
                    AggregateExpression aggregateExpression = expression instanceof Star ? Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression() : Count$.MODULE$.apply(inputExpr).toAggregateExpression();
                    unresolvedFunction = aggregateExpression;
                    break block15;
                }
                Expression expression = inputExpr;
                unresolvedFunction = UnresolvedFunction$.MODULE$.apply(string, (Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)expression), false);
            }
            return unresolvedFunction;
        };
        return (Function1 & Serializable)inputExpr -> (Expression)exprToFunc.apply(inputExpr);
    }

    public <K, T> KeyValueGroupedDataset<K, T> as(Encoder<K> evidence$1, Encoder<T> evidence$2) {
        ExpressionEncoder keyEncoder = package$.MODULE$.encoderFor(evidence$1);
        ExpressionEncoder valueEncoder = package$.MODULE$.encoderFor(evidence$2);
        Tuple2<QueryExecution, Seq<Attribute>> tuple2 = RelationalGroupedDataset$.MODULE$.handleGroupingExpression(this.df().logicalPlan(), this.df().sparkSession(), this.groupingExprs());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        QueryExecution qe = (QueryExecution)tuple2._1();
        Seq groupingAttributes = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)qe, (Object)groupingAttributes);
        Tuple2 tuple23 = tuple22;
        QueryExecution qe2 = (QueryExecution)tuple23._1();
        Seq groupingAttributes2 = (Seq)tuple23._2();
        return new KeyValueGroupedDataset(keyEncoder, valueEncoder, qe2, (Seq<Attribute>)this.df().logicalPlan().output(), (Seq<Attribute>)groupingAttributes2);
    }

    public Dataset<Row> agg(Tuple2<String, String> aggExpr, Seq<Tuple2<String, String>> aggExprs) {
        Tuple2<String, String> tuple2 = aggExpr;
        return this.toDF((Seq<Expression>)((Seq)((IterableOps)aggExprs.$plus$colon(tuple2)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)this.df().apply(colName).expr());
            return expression;
        })));
    }

    public Dataset<Row> agg(scala.collection.immutable.Map<String, String> exprs) {
        return this.toDF((Seq<Expression>)((IterableOnceOps)exprs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)this.df().apply(colName).expr());
            return expression;
        })).toSeq());
    }

    public Dataset<Row> agg(Map<String, String> exprs) {
        return this.agg((scala.collection.immutable.Map<String, String>)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(exprs).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Dataset<Row> agg(Column expr, Seq<Column> exprs) {
        Column column = expr;
        return this.toDF((Seq<Expression>)((Seq)((IterableOps)exprs.$plus$colon((Object)column)).map((Function1 & Serializable)x0$1 -> {
            Expression expression;
            Column column = x0$1;
            if (column instanceof TypedColumn) {
                TypedColumn typedColumn = (TypedColumn)column;
                expression = typedColumn.withInputType(this.df().exprEnc(), (Seq<Attribute>)this.df().logicalPlan().output()).expr();
            } else {
                expression = column.expr();
            }
            return expression;
        })));
    }

    public Dataset<Row> count() {
        Alias[] aliasArray = new Alias[1];
        AggregateExpression x$1 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        String x$2 = "count";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, "count");
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, "count");
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, "count");
        Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, "count");
        aliasArray[0] = new Alias((Expression)x$1, "count", x$3, x$4, x$5, x$6);
        return this.toDF((Seq<Expression>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])aliasArray))));
    }

    public Dataset<Row> mean(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)(Function1 & Serializable)x$4 -> new Average(x$4, Average$.MODULE$.apply$default$2()));
    }

    public Dataset<Row> max(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Max$.MODULE$);
    }

    public Dataset<Row> avg(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)(Function1 & Serializable)x$5 -> new Average(x$5, Average$.MODULE$.apply$default$2()));
    }

    public Dataset<Row> min(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Min$.MODULE$);
    }

    public Dataset<Row> sum(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)(Function1 & Serializable)x$6 -> new Sum(x$6, Sum$.MODULE$.apply$default$2()));
    }

    public RelationalGroupedDataset pivot(String pivotColumn) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn));
    }

    public RelationalGroupedDataset pivot(String pivotColumn, Seq<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(String pivotColumn, List<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn) {
        if (this.df().isStreaming()) {
            throw new AnalysisException("pivot is not supported on a streaming DataFrames/Datasets", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        int maxValues = this.df().sparkSession().sessionState().conf().dataFramePivotMaxValues();
        Seq values = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.df().select((Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).distinct().limit(maxValues + 1).sort((Seq<Column>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).collect()), (Function1 & Serializable)x$7 -> x$7.get(0), ClassTag$.MODULE$.Any())));
        if (values.length() > maxValues) {
            throw QueryCompilationErrors$.MODULE$.aggregationFunctionAppliedOnNonNumericColumnError(pivotColumn.toString(), maxValues);
        }
        return this.pivot(pivotColumn, (Seq<Object>)values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, Seq<Object> values) {
        GroupType groupType = this.groupType;
        if (!RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            if (groupType instanceof PivotType) {
                throw QueryExecutionErrors$.MODULE$.repeatedPivotsUnsupportedError("PIVOT", "SUBQUERY");
            }
            throw QueryExecutionErrors$.MODULE$.pivotNotAfterGroupByUnsupportedError();
        }
        Seq valueExprs = (Seq)values.map((Function1 & Serializable)x$8 -> {
            Expression expression;
            Object object = x$8;
            if (object instanceof Column) {
                Column column = (Column)object;
                expression = column.expr();
            } else {
                Literal literal;
                try {
                    literal = Literal$.MODULE$.apply(object);
                }
                catch (SparkRuntimeException sparkRuntimeException) {
                    throw QueryExecutionErrors$.MODULE$.pivotColumnUnsupportedError(object, pivotColumn.expr().dataType());
                }
                expression = literal;
            }
            return expression;
        });
        RelationalGroupedDataset relationalGroupedDataset = new RelationalGroupedDataset(this.df(), this.groupingExprs(), new PivotType(pivotColumn.expr(), (Seq<Expression>)valueExprs));
        return relationalGroupedDataset;
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, List<Object> values) {
        return this.pivot(pivotColumn, (Seq<Object>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()).toSeq());
    }

    public Dataset<Row> flatMapGroupsInR(byte[] f, byte[] packageNames, Broadcast<Object>[] broadcastVars, StructType outputSchema) {
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable)expr -> RelationalGroupedDataset$.MODULE$.org$apache$spark$sql$RelationalGroupedDataset$$alias((Expression)expr));
        Seq groupingCols = (Seq)groupingNamedExpressions.map((Function1 & Serializable)x$9 -> Column$.MODULE$.apply((Expression)x$9));
        Dataset<Row> groupingDataFrame = this.df().select((Seq<Column>)groupingCols);
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable)x$10 -> x$10.toAttribute());
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), FlatMapGroupsInR$.MODULE$.apply(f, packageNames, broadcastVars, outputSchema, groupingDataFrame.exprEnc().deserializer(), this.df().exprEnc().deserializer(), this.df().exprEnc().schema(), groupingAttributes, this.df().logicalPlan().output(), this.df().logicalPlan()));
    }

    public Dataset<Row> flatMapGroupsInPandas(PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_GROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable)() -> "Must pass a grouped map udf");
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            return namedExpression;
        });
        LogicalPlan child = this.df().logicalPlan();
        LogicalPlan project = this.df().sparkSession().sessionState().executePlan((LogicalPlan)new Project((Seq)groupingNamedExpressions.$plus$plus((IterableOnce)child.output()), child), this.df().sparkSession().sessionState().executePlan$default$2()).analyzed();
        Seq groupingAttributes = (Seq)project.output().take(groupingNamedExpressions.length());
        Seq output = DataTypeUtils$.MODULE$.toAttributes((StructType)expr.dataType());
        FlatMapGroupsInPandas plan = new FlatMapGroupsInPandas(groupingAttributes, (Expression)expr, output, project);
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public Dataset<Row> flatMapCoGroupsInPandas(RelationalGroupedDataset r, PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_COGROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable)() -> "Must pass a cogrouped map udf");
        Predef$.MODULE$.require(this.groupingExprs().length() == r.groupingExprs().length(), (Function0 & Serializable)() -> new java.lang.StringBuilder(34).append("Cogroup keys must have same size: ").append(new java.lang.StringBuilder(4).append(this.groupingExprs().length()).append(" != ").append(r.groupingExprs().length()).toString()).toString());
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq leftGroupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            return namedExpression;
        });
        Seq rightGroupingNamedExpressions = (Seq)r.groupingExprs().map((Function1 & Serializable)x0$2 -> {
            NamedExpression namedExpression;
            Expression expression = x0$2;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$7 = expression;
                String x$8 = expression.toString();
                ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
                Seq x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                Option x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
                Seq x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
                namedExpression = new Alias(x$7, x$8, x$9, x$10, x$11, x$12);
            }
            return namedExpression;
        });
        LogicalPlan leftChild = this.df().logicalPlan();
        LogicalPlan rightChild = r.df().logicalPlan();
        LogicalPlan left = this.df().sparkSession().sessionState().executePlan((LogicalPlan)new Project((Seq)leftGroupingNamedExpressions.$plus$plus((IterableOnce)leftChild.output()), leftChild), this.df().sparkSession().sessionState().executePlan$default$2()).analyzed();
        LogicalPlan right = r.df().sparkSession().sessionState().executePlan((LogicalPlan)new Project((Seq)rightGroupingNamedExpressions.$plus$plus((IterableOnce)rightChild.output()), rightChild), r.df().sparkSession().sessionState().executePlan$default$2()).analyzed();
        Seq output = DataTypeUtils$.MODULE$.toAttributes((StructType)expr.dataType());
        FlatMapCoGroupsInPandas plan = new FlatMapCoGroupsInPandas(leftGroupingNamedExpressions.length(), rightGroupingNamedExpressions.length(), (Expression)expr, output, left, right);
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public Dataset<Row> applyInPandasWithState(PythonUDF func, StructType outputStructType, StructType stateStructType, String outputModeStr, String timeoutConfStr) {
        OutputMode outputMode;
        GroupStateTimeout timeoutConf = GroupStateImpl$.MODULE$.groupStateTimeoutFromString(timeoutConfStr);
        OutputMode outputMode2 = outputMode = InternalOutputModes$.MODULE$.apply(outputModeStr);
        OutputMode outputMode3 = OutputMode.Append();
        if (outputMode2 == null ? outputMode3 != null : !outputMode2.equals(outputMode3)) {
            OutputMode outputMode4 = outputMode;
            OutputMode outputMode5 = OutputMode.Update();
            if (outputMode4 == null ? outputMode5 != null : !outputMode4.equals(outputMode5)) {
                throw new IllegalArgumentException("The output mode of function should be append or update");
            }
        }
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            return namedExpression;
        });
        Seq groupingAttrs = (Seq)groupingNamedExpressions.map((Function1 & Serializable)x$11 -> x$11.toAttribute());
        Seq outputAttrs = DataTypeUtils$.MODULE$.toAttributes(outputStructType);
        FlatMapGroupsInPandasWithState plan = new FlatMapGroupsInPandasWithState((Expression)func, groupingAttrs, outputAttrs, stateStructType, outputMode, timeoutConf, this.df().logicalPlan());
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RelationalGroupedDataset: [grouping expressions: [");
        Seq kFields = (Seq)this.groupingExprs().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string;
                boolean bl = false;
                NamedExpression namedExpression = null;
                A1 A1 = x1;
                if (A1 instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)A1;
                    if (((Expression)namedExpression).resolved()) {
                        string = new java.lang.StringBuilder(2).append(namedExpression.name()).append(": ").append(((Expression)namedExpression).dataType().simpleString(2)).toString();
                        return (B1)string;
                    }
                }
                if (bl) {
                    string = namedExpression.name();
                    return (B1)string;
                }
                string = A1.toString();
                return (B1)string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                NamedExpression namedExpression = null;
                Expression expression = x1;
                if (expression instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)expression;
                    if (((Expression)namedExpression).resolved()) {
                        return true;
                    }
                }
                if (!bl) return true;
                return true;
            }
        });
        builder.append(((IterableOnceOps)kFields.take(2)).mkString(", "));
        Object object = kFields.length() > 2 ? builder.append(new java.lang.StringBuilder(19).append(" ... ").append(kFields.length() - 2).append(" more field(s)").toString()) : BoxedUnit.UNIT;
        return builder.append(new java.lang.StringBuilder(19).append("], value: ").append(this.df().toString()).append(", type: ").append(this.groupType).append("]").toString()).toString();
    }

    public RelationalGroupedDataset(Dataset<Row> df, Seq<Expression> groupingExprs, GroupType groupType) {
        this.df = df;
        this.groupingExprs = groupingExprs;
        this.groupType = groupType;
    }

    public static interface GroupType {
        default public String toString() {
            return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.getClass().getSimpleName()), "$")), "Type");
        }

        public static void $init$(GroupType $this) {
        }
    }

    public static class PivotType
    implements GroupType,
    Product,
    Serializable {
        private final Expression pivotCol;
        private final Seq<Expression> values;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String toString() {
            return ((GroupType)this).toString();
        }

        public Expression pivotCol() {
            return this.pivotCol;
        }

        public Seq<Expression> values() {
            return this.values;
        }

        public PivotType copy(Expression pivotCol, Seq<Expression> values) {
            return new PivotType(pivotCol, values);
        }

        public Expression copy$default$1() {
            return this.pivotCol();
        }

        public Seq<Expression> copy$default$2() {
            return this.values();
        }

        public String productPrefix() {
            return "PivotType";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.pivotCol();
                    break;
                }
                case 1: {
                    object = this.values();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PivotType;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "pivotCol";
                    break;
                }
                case 1: {
                    string = "values";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PivotType)) return false;
            boolean bl = true;
            if (!bl) return false;
            PivotType pivotType = (PivotType)x$1;
            Expression expression = this.pivotCol();
            Expression expression2 = pivotType.pivotCol();
            if (expression == null) {
                if (expression2 != null) {
                    return false;
                }
            } else if (!expression.equals(expression2)) return false;
            Seq<Expression> seq = this.values();
            Seq<Expression> seq2 = pivotType.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!pivotType.canEqual(this)) return false;
            return true;
        }

        public PivotType(Expression pivotCol, Seq<Expression> values) {
            this.pivotCol = pivotCol;
            this.values = values;
            GroupType.$init$(this);
            Product.$init$((Product)this);
        }
    }
}

