/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.ConfigFluentImpl;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigBuilder() {
        this(false);
    }

    public ConfigBuilder(Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this(fluent, instance, false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withClusters(instance.getClusters());
            fluent.withContexts(instance.getContexts());
            fluent.withCurrentContext(instance.getCurrentContext());
            fluent.withExtensions(instance.getExtensions());
            fluent.withKind(instance.getKind());
            fluent.withPreferences(instance.getPreferences());
            fluent.withUsers(instance.getUsers());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Config instance) {
        this(instance, (Boolean)false);
    }

    public ConfigBuilder(Config instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withClusters(instance.getClusters());
            this.withContexts(instance.getContexts());
            this.withCurrentContext(instance.getCurrentContext());
            this.withExtensions(instance.getExtensions());
            this.withKind(instance.getKind());
            this.withPreferences(instance.getPreferences());
            this.withUsers(instance.getUsers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Config build() {
        Config buildable = new Config(this.fluent.getApiVersion(), this.fluent.getClusters(), this.fluent.getContexts(), this.fluent.getCurrentContext(), this.fluent.getExtensions(), this.fluent.getKind(), this.fluent.getPreferences(), this.fluent.getUsers());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

