/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hive.service.cli.operation.TableTypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.collect.ArrayListMultimap;
import org.sparkproject.guava.collect.Iterables;
import org.sparkproject.guava.collect.Multimap;

public class ClassicTableTypeMapping
implements TableTypeMapping {
    private static final Logger LOG = LoggerFactory.getLogger(ClassicTableTypeMapping.class);
    private final Map<String, String> hiveToClientMap = new HashMap<String, String>();
    private final Multimap<String, String> clientToHiveMap = ArrayListMultimap.create();

    public ClassicTableTypeMapping() {
        this.hiveToClientMap.put(TableType.MANAGED_TABLE.name(), ClassicTableTypes.TABLE.name());
        this.hiveToClientMap.put(TableType.EXTERNAL_TABLE.name(), ClassicTableTypes.TABLE.name());
        this.hiveToClientMap.put(TableType.VIRTUAL_VIEW.name(), ClassicTableTypes.VIEW.name());
        this.hiveToClientMap.put(TableType.MATERIALIZED_VIEW.toString(), ClassicTableTypes.MATERIALIZED_VIEW.toString());
        this.clientToHiveMap.putAll((Object)ClassicTableTypes.TABLE.name(), Arrays.asList(TableType.MANAGED_TABLE.name(), TableType.EXTERNAL_TABLE.name()));
        this.clientToHiveMap.put((Object)ClassicTableTypes.VIEW.name(), (Object)TableType.VIRTUAL_VIEW.name());
        this.clientToHiveMap.put((Object)ClassicTableTypes.MATERIALIZED_VIEW.toString(), (Object)TableType.MATERIALIZED_VIEW.toString());
    }

    @Override
    public String[] mapToHiveType(String clientTypeName) {
        Collection hiveTableType = this.clientToHiveMap.get((Object)clientTypeName.toUpperCase());
        if (hiveTableType == null) {
            LOG.warn("Not supported client table type " + clientTypeName);
            return new String[]{clientTypeName};
        }
        return (String[])Iterables.toArray((Iterable)hiveTableType, String.class);
    }

    @Override
    public String mapToClientType(String hiveTypeName) {
        String clientTypeName = this.hiveToClientMap.get(hiveTypeName);
        if (clientTypeName == null) {
            LOG.warn("Invalid hive table type " + hiveTypeName);
            return hiveTypeName;
        }
        return clientTypeName;
    }

    @Override
    public Set<String> getTableTypeNames() {
        HashSet<String> typeNameSet = new HashSet<String>();
        for (ClassicTableTypes typeNames : ClassicTableTypes.values()) {
            typeNameSet.add(typeNames.name());
        }
        return typeNameSet;
    }

    public static enum ClassicTableTypes {
        TABLE,
        VIEW,
        MATERIALIZED_VIEW;

    }
}

