/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.prf;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.prf.AesCmacPrfProtoSerialization;
import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.proto.AesCmacPrfKey;
import com.google.crypto.tink.proto.AesCmacPrfKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.PrfAesCmac;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AesCmacPrfKeyManager
extends KeyTypeManager<AesCmacPrfKey> {
    private static final int VERSION = 0;
    private static final int KEY_SIZE_IN_BYTES = 32;

    AesCmacPrfKeyManager() {
        super(AesCmacPrfKey.class, new PrimitiveFactory<Prf, AesCmacPrfKey>(Prf.class){

            @Override
            public Prf getPrimitive(AesCmacPrfKey key) throws GeneralSecurityException {
                return new PrfAesCmac(key.getKeyValue().toByteArray());
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.AesCmacPrfKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(AesCmacPrfKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        AesCmacPrfKeyManager.validateSize(key.getKeyValue().size());
    }

    @Override
    public AesCmacPrfKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCmacPrfKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    private static void validateSize(int size) throws GeneralSecurityException {
        if (size != 32) {
            throw new GeneralSecurityException("AesCmacPrfKey size wrong, must be 32 bytes");
        }
    }

    @Override
    public KeyTypeManager.KeyFactory<AesCmacPrfKeyFormat, AesCmacPrfKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<AesCmacPrfKeyFormat, AesCmacPrfKey>(AesCmacPrfKeyFormat.class){

            @Override
            public void validateKeyFormat(AesCmacPrfKeyFormat format) throws GeneralSecurityException {
                AesCmacPrfKeyManager.validateSize(format.getKeySize());
            }

            @Override
            public AesCmacPrfKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return AesCmacPrfKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public AesCmacPrfKey createKey(AesCmacPrfKeyFormat format) {
                return AesCmacPrfKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).build();
            }

            @Override
            public Map<String, KeyTypeManager.KeyFactory.KeyFormat<AesCmacPrfKeyFormat>> keyFormats() throws GeneralSecurityException {
                HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<AesCmacPrfKeyFormat>> result = new HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<AesCmacPrfKeyFormat>>();
                result.put("AES256_CMAC_PRF", new KeyTypeManager.KeyFactory.KeyFormat<AesCmacPrfKeyFormat>(AesCmacPrfKeyFormat.newBuilder().setKeySize(32).build(), KeyTemplate.OutputPrefixType.RAW));
                result.put("AES_CMAC_PRF", new KeyTypeManager.KeyFactory.KeyFormat<AesCmacPrfKeyFormat>(AesCmacPrfKeyFormat.newBuilder().setKeySize(32).build(), KeyTemplate.OutputPrefixType.RAW));
                return Collections.unmodifiableMap(result);
            }
        };
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new AesCmacPrfKeyManager(), newKeyAllowed);
        AesCmacPrfProtoSerialization.register();
    }

    public static final KeyTemplate aes256CmacTemplate() {
        AesCmacPrfKeyFormat format = AesCmacPrfKeyFormat.newBuilder().setKeySize(32).build();
        return KeyTemplate.create(new AesCmacPrfKeyManager().getKeyType(), format.toByteArray(), KeyTemplate.OutputPrefixType.RAW);
    }
}

