/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import org.sparkproject.guava.collect.Ordering;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005g\u0001\u0002\u001f>\u0001!C\u0011\"\u0019\u0001\u0003\u0006\u0004%\t!\u00112\t\u0011E\u0004!\u0011!Q\u0001\n\rD\u0011B\u001d\u0001\u0003\u0006\u0004%\t!Q:\t\u0011i\u0004!\u0011!Q\u0001\nQDaa\u001f\u0001\u0005\u0002\u0005c\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011\u001d\t9\u0001\u0001Q\u0001\n9D\u0011\"!\u0003\u0001\u0005\u0004%I!!\u0002\t\u000f\u0005-\u0001\u0001)A\u0005]\"Q\u0011Q\u0002\u0001\t\u0006\u0004%I!a\u0004\t\u0013\u0005M\u0001\u0001#b\u0001\n\u0013\u0019\bBB>\u0001\t\u0003\t)\u0002C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA5\u0001\u0011\u0005\u00111\u0011\u0005\t\u0003S\u0002A\u0011A!\u0002\u000e\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005vaBAV{!\u0005\u0011Q\u0016\u0004\u0007yuB\t!a,\t\rm$B\u0011AAc\u0011\u001d\t9\r\u0006C\u0005\u0003\u0013Dq!!4\u0015\t\u0013\tymB\u0004\u0002TRAI!!6\u0007\u000f\u0005eG\u0003#\u0003\u0002\\\"110\u0007C\u0001\u0003;D\u0011\"a8\u001a\u0005\u0004%\t!!9\t\u0011\u00055\u0018\u0004)A\u0005\u0003GD\u0011\"a<\u001a\u0005\u0004%\t!!9\t\u0011\u0005E\u0018\u0004)A\u0005\u0003G4a!a=\u001a\u0001\u0006U\bBCA1?\tU\r\u0011\"\u0001\u0002~\"I\u0011q`\u0010\u0003\u0012\u0003\u0006Ia\u001b\u0005\n\u0003\u000f{\"Q3A\u0005\u0002MD\u0011B!\u0001 \u0005#\u0005\u000b\u0011\u0002;\t\rm|B\u0011\u0001B\u0002\u0011%\u0011iaHA\u0001\n\u0003\u0011y\u0001C\u0005\u0003\u0016}\t\n\u0011\"\u0001\u0003\u0018!I!1F\u0010\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005cy\u0012\u0011!C!\u0003CD\u0011Ba\r \u0003\u0003%\t!!\u0002\t\u0013\tUr$!A\u0005\u0002\t]\u0002\"\u0003B\"?\u0005\u0005I\u0011\tB#\u0011%\u0011\u0019fHA\u0001\n\u0003\u0011)\u0006C\u0005\u0003`}\t\t\u0011\"\u0011\u0003b!I!QM\u0010\u0002\u0002\u0013\u0005#q\r\u0005\n\u0005Sz\u0012\u0011!C!\u0005WB\u0011B!\u001c \u0003\u0003%\tEa\u001c\b\u0013\tM\u0014$!A\t\u0002\tUd!CAz3\u0005\u0005\t\u0012\u0001B<\u0011\u0019Y(\u0007\"\u0001\u0003\u0006\"I!\u0011\u000e\u001a\u0002\u0002\u0013\u0015#1\u000e\u0005\n\u0005\u000f\u0013\u0014\u0011!CA\u0005\u0013C\u0011Ba$3\u0003\u0003%\tI!%\t\u0013\tm%'!A\u0005\n\tu\u0005b\u0002BS3\u0011\u0005!q\u0015\u0005\b\u0003_IB\u0011\u0001BW\u0011\u001d\u0011)\u000b\u0006C!\u0005kC\u0011Ba'\u0015\u0003\u0003%IA!(\u0003\u001b]{'\u000f\u001a\u001aWK\u000elu\u000eZ3m\u0015\tqt(A\u0004gK\u0006$XO]3\u000b\u0005\u0001\u000b\u0015!B7mY&\u0014'B\u0001\"D\u0003\u0015\u0019\b/\u0019:l\u0015\t!U)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\r\u0006\u0019qN]4\u0004\u0001M!\u0001!S(\\!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0019\te.\u001f*fMB\u0011\u0001\u000b\u0017\b\u0003#Zs!AU+\u000e\u0003MS!\u0001V$\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015BA,L\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005][\u0005C\u0001/`\u001b\u0005i&B\u00010@\u0003\u0011)H/\u001b7\n\u0005\u0001l&\u0001C*bm\u0016\f'\r\\3\u0002\u0013]|'\u000fZ%oI\u0016DX#A2\u0011\t\u0011D7N\u001c\b\u0003K\u001a\u0004\"AU&\n\u0005\u001d\\\u0015A\u0002)sK\u0012,g-\u0003\u0002jU\n\u0019Q*\u00199\u000b\u0005\u001d\\\u0005C\u00013m\u0013\ti'N\u0001\u0004TiJLgn\u001a\t\u0003\u0015>L!\u0001]&\u0003\u0007%sG/\u0001\u0006x_J$\u0017J\u001c3fq\u0002\n1b^8sIZ+7\r^8sgV\tA\u000fE\u0002Kk^L!A^&\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)C\u0018BA=L\u0005\u00151En\\1u\u000319xN\u001d3WK\u000e$xN]:!\u0003\u0019a\u0014N\\5u}Q!Qp`A\u0001!\tq\b!D\u0001>\u0011\u0015\tW\u00011\u0001d\u0011\u0015\u0011X\u00011\u0001u\u0003!qW/\\,pe\u0012\u001cX#\u00018\u0002\u00139,XnV8sIN\u0004\u0013A\u0003<fGR|'oU5{K\u0006Ya/Z2u_J\u001c\u0016N_3!\u0003!9xN\u001d3MSN$XCAA\t!\rQUo[\u0001\u0010o>\u0014HMV3d\u0013:4hj\u001c:ngR\u0019Q0a\u0006\t\u000f\u0005eA\u00021\u0001\u0002\u001c\u0005)Qn\u001c3fYB!A\r[6uQ\u0015a\u0011qDA\u0016!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00121\u0005\u0002\u0006'&t7-Z\u0011\u0003\u0003[\tQ!\r\u00186]A\nAa]1wKR1\u00111GA\u001d\u0003\u000b\u00022ASA\u001b\u0013\r\t9d\u0013\u0002\u0005+:LG\u000fC\u0004\u0002<5\u0001\r!!\u0010\u0002\u0005M\u001c\u0007\u0003BA \u0003\u0003j\u0011!Q\u0005\u0004\u0003\u0007\n%\u0001D*qCJ\\7i\u001c8uKb$\bBBA$\u001b\u0001\u00071.\u0001\u0003qCRD\u0007&B\u0007\u0002 \u0005-\u0013EAA'\u0003\u0015\td\u0006\u000e\u00181\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002T\u0005}\u0003\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005es(\u0001\u0004mS:\fGnZ\u0005\u0005\u0003;\n9F\u0001\u0004WK\u000e$xN\u001d\u0005\u0007\u0003Cr\u0001\u0019A6\u0002\t]|'\u000f\u001a\u0015\u0006\u001d\u0005}\u0011QM\u0011\u0003\u0003O\nQ!\r\u00182]A\nABZ5oINKhn\u001c8z[N$b!!\u001c\u0002|\u0005u\u0004\u0003\u0002&v\u0003_\u0002bASA9W\u0006U\u0014bAA:\u0017\n1A+\u001e9mKJ\u00022ASA<\u0013\r\tIh\u0013\u0002\u0007\t>,(\r\\3\t\r\u0005\u0005t\u00021\u0001l\u0011\u0019\tyh\u0004a\u0001]\u0006\u0019a.^7)\u000b=\ty\"!\u001a\u0015\r\u00055\u0014QQAE\u0011\u001d\t9\t\u0005a\u0001\u0003'\naA^3di>\u0014\bBBA@!\u0001\u0007a\u000eK\u0003\u0011\u0003?\t)\u0007\u0006\u0005\u0002n\u0005=\u00151SAK\u0011\u001d\t9)\u0005a\u0001\u0003#\u0003BAS;\u0002v!1\u0011qP\tA\u00029Dq!a&\u0012\u0001\u0004\tI*A\u0004x_J$w\n\u001d;\u0011\t)\u000bYj[\u0005\u0004\u0003;[%AB(qi&|g.\u0001\u0006hKR4Vm\u0019;peN,\"!a\u0007)\u000bI\ty\"!*\"\u0005\u0005\u001d\u0016!B\u0019/e9\u0002\u0004&\u0002\u0001\u0002 \u0005\u0015\u0014!D,pe\u0012\u0014d+Z2N_\u0012,G\u000e\u0005\u0002\u007f)M1A#SAY\u0003o\u0003B\u0001XAZ{&\u0019\u0011QW/\u0003\r1{\u0017\rZ3s!\u0011\tI,a1\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000b!![8\u000b\u0005\u0005\u0005\u0017\u0001\u00026bm\u0006L1!WA^)\t\ti+\u0001\bck&dGmV8sI&sG-\u001a=\u0015\u0007\r\fY\rC\u0004\u0002\u001aY\u0001\r!a\u0007\u0002!\t,\u0018\u000e\u001c3X_J$g+Z2u_J\u001cHc\u0001;\u0002R\"9\u0011\u0011D\fA\u0002\u0005m\u0011\u0001D*bm\u0016du.\u00193Wc}\u0003\u0004cAAl35\tAC\u0001\u0007TCZ,Gj\\1e-Fz\u0006g\u0005\u0002\u001a\u0013R\u0011\u0011Q[\u0001\u0012M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003TCAAr!\u0011\t)/a;\u000e\u0005\u0005\u001d(\u0002BAu\u0003\u007f\u000bA\u0001\\1oO&\u0019Q.a:\u0002%\u0019|'/\\1u-\u0016\u00148/[8o-Fz\u0006\u0007I\u0001\u000eG2\f7o\u001d(b[\u00164\u0016g\u0018\u0019\u0002\u001d\rd\u0017m]:OC6,g+M01A\t!A)\u0019;b'\u0015y\u0012*a>P!\rQ\u0015\u0011`\u0005\u0004\u0003w\\%a\u0002)s_\u0012,8\r^\u000b\u0002W\u0006)qo\u001c:eA\u00059a/Z2u_J\u0004CC\u0002B\u0003\u0005\u0013\u0011Y\u0001E\u0002\u0003\b}i\u0011!\u0007\u0005\u0007\u0003C\"\u0003\u0019A6\t\r\u0005\u001dE\u00051\u0001u\u0003\u0011\u0019w\u000e]=\u0015\r\t\u0015!\u0011\u0003B\n\u0011!\t\t'\nI\u0001\u0002\u0004Y\u0007\u0002CADKA\u0005\t\u0019\u0001;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0004\u0016\u0004W\nm1F\u0001B\u000f!\u0011\u0011yBa\n\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0005K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00152*\u0003\u0003\u0003*\t\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0018U\r!(1D\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\bB !\rQ%1H\u0005\u0004\u0005{Y%aA!os\"A!\u0011\t\u0016\u0002\u0002\u0003\u0007a.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u000f\u0002bA!\u0013\u0003P\teRB\u0001B&\u0015\r\u0011ieS\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B)\u0005\u0017\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\u000bB/!\rQ%\u0011L\u0005\u0004\u00057Z%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005\u0003b\u0013\u0011!a\u0001\u0005s\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111\u001dB2\u0011!\u0011\t%LA\u0001\u0002\u0004q\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u00039\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003G\fa!Z9vC2\u001cH\u0003\u0002B,\u0005cB\u0011B!\u00111\u0003\u0003\u0005\rA!\u000f\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005\u000f\u00114#\u0002\u001a\u0003z\u0005]\u0006\u0003\u0003B>\u0005\u0003[GO!\u0002\u000e\u0005\tu$b\u0001B@\u0017\u00069!/\u001e8uS6,\u0017\u0002\u0002BB\u0005{\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011)(A\u0003baBd\u0017\u0010\u0006\u0004\u0003\u0006\t-%Q\u0012\u0005\u0007\u0003C*\u0004\u0019A6\t\r\u0005\u001dU\u00071\u0001u\u0003\u001d)h.\u00199qYf$BAa%\u0003\u0018B)!*a'\u0003\u0016B)!*!\u001dli\"I!\u0011\u0014\u001c\u0002\u0002\u0003\u0007!QA\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BP!\u0011\t)O!)\n\t\t\r\u0016q\u001d\u0002\u0007\u001f\nTWm\u0019;\u0002\t1|\u0017\r\u001a\u000b\u0006{\n%&1\u0016\u0005\b\u0003wA\u0004\u0019AA\u001f\u0011\u0019\t9\u0005\u000fa\u0001WRA\u00111\u0007BX\u0005c\u0013\u0019\fC\u0004\u0002<e\u0002\r!!\u0010\t\r\u0005\u001d\u0013\b1\u0001l\u0011\u001d\tI\"\u000fa\u0001\u00037!R! B\\\u0005sCq!a\u000f;\u0001\u0004\ti\u0004\u0003\u0004\u0002Hi\u0002\ra\u001b\u0015\u0006u\u0005}\u00111\n\u0015\u0006)\u0005}\u00111\n\u0015\u0006'\u0005}\u00111\n")
public class Word2VecModel
implements Serializable,
Saveable {
    private String[] wordList;
    private float[] wordVecInvNorms;
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int vectorSize;
    private volatile byte bitmap$0;

    public static Word2VecModel load(SparkContext sc, String path) {
        return Word2VecModel$.MODULE$.load(sc, path);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private String[] wordList$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wordList = (String[])((IterableOnce)this.wordIndex().toSeq().sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()), (scala.math.Ordering)Ordering.Int$.MODULE$)).iterator().map((Function1 & Serializable)x$9 -> (String)x$9._1()).toArray(ClassTag$.MODULE$.apply(String.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.wordList;
    }

    private String[] wordList() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wordList$lzycompute() : this.wordList;
    }

    private float[] wordVecInvNorms$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                int size = this.vectorSize();
                this.wordVecInvNorms = (float[])Array$.MODULE$.tabulate(this.numWords(), (Function1)(JFunction1.mcFI.sp & Serializable)i -> {
                    float norm = BLAS$.MODULE$.nativeBLAS().snrm2(size, this.wordVectors(), i * size, 1);
                    return norm != 0.0f ? 1.0f / norm : 0.0f;
                }, (ClassTag)ClassTag$.MODULE$.Float());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.wordVecInvNorms;
    }

    private float[] wordVecInvNorms() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.wordVecInvNorms$lzycompute() : this.wordVecInvNorms;
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        double[] array;
        Option option = this.wordIndex().get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            int index = BoxesRunTime.unboxToInt((Object)some.value());
            int size = this.vectorSize();
            int offset = index * size;
            array = (double[])Array$.MODULE$.ofDim(size, (ClassTag)ClassTag$.MODULE$.Double());
            for (int i = 0; i < size; ++i) {
                array[i] = this.wordVectors()[offset + i];
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(18).append(word).append(" not in vocabulary").toString());
            }
            throw new MatchError((Object)option);
        }
        Vector vector = Vectors$.MODULE$.dense(array);
        return vector;
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector.toArray(), num, (Option<String>)new Some((Object)word));
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        return this.findSynonyms(vector.toArray(), num, (Option<String>)None$.MODULE$);
    }

    public Tuple2<String, Object>[] findSynonyms(double[] vector, int num, Option<String> wordOpt) {
        Tuple2[] tuple2Array;
        Predef$.MODULE$.require(num > 0, (Function0 & Serializable)() -> "Number of similar words should > 0");
        int localVectorSize = this.vectorSize();
        float[] floatVec = (float[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(vector), (Function1)(JFunction1.mcFD.sp & Serializable)x$10 -> (float)x$10, (ClassTag)ClassTag$.MODULE$.Float());
        float vecNorm = BLAS$.MODULE$.nativeBLAS().snrm2(localVectorSize, floatVec, 1);
        String[] localWordList = this.wordList();
        int localNumWords = this.numWords();
        if (vecNorm == 0.0f) {
            tuple2Array = (Tuple2[])package$.MODULE$.Iterator().tabulate(num + 1, (Function1 & Serializable)i -> Word2VecModel.$anonfun$findSynonyms$3(localWordList, BoxesRunTime.unboxToInt((Object)i))).filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)wordOpt.contains(t._1()))).take(num).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            BLAS$.MODULE$.nativeBLAS().sscal(localVectorSize, 1.0f / vecNorm, floatVec, 0, 1);
            float[] cosineVec = (float[])Array$.MODULE$.ofDim(localNumWords, (ClassTag)ClassTag$.MODULE$.Float());
            BLAS$.MODULE$.nativeBLAS().sgemv("T", localVectorSize, localNumWords, 1.0f, this.wordVectors(), localVectorSize, floatVec, 1, 0.0f, cosineVec, 1);
            float[] localWordVecInvNorms = this.wordVecInvNorms();
            for (int i2 = 0; i2 < cosineVec.length; ++i2) {
                int n = i2;
                cosineVec[n] = cosineVec[n] * localWordVecInvNorms[i2];
            }
            Ordering<Object> idxOrd = new Ordering<Object>(null, cosineVec){
                private final float[] cosineVec$1;

                public int compare(int left, int right) {
                    return package$.MODULE$.Ordering().apply((scala.math.Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$).compare((Object)BoxesRunTime.boxToFloat((float)this.cosineVec$1[left]), (Object)BoxesRunTime.boxToFloat((float)this.cosineVec$1[right]));
                }
                {
                    this.cosineVec$1 = cosineVec$1;
                }
            };
            tuple2Array = (Tuple2[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(idxOrd.greatestOf((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(package$.MODULE$.Iterator().range(0, localNumWords)).asJava(), num + 1).iterator()).asScala()).map((Function1 & Serializable)i -> Word2VecModel.$anonfun$findSynonyms$5(localWordList, cosineVec, BoxesRunTime.unboxToInt((Object)i))).filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)wordOpt.contains(t._1()))).take(num).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        return tuple2Array;
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)word, ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.floatArrayOps(this.wordVectors()), this.vectorSize() * ind, this.vectorSize() * ind + this.vectorSize()));
            return tuple22;
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$findSynonyms$3(String[] localWordList$1, int i) {
        return new Tuple2((Object)localWordList$1[i], (Object)BoxesRunTime.boxToDouble((double)0.0));
    }

    public static final /* synthetic */ Tuple2 $anonfun$findSynonyms$5(String[] localWordList$1, float[] cosineVec$1, int i) {
        return new Tuple2((Object)localWordList$1[i], (Object)BoxesRunTime.boxToDouble((double)cosineVec$1[i]));
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.vectorSize = wordVectors.length / this.numWords();
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

