/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class OpenBlocks
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final String[] blockIds;

    public OpenBlocks(String appId, String execId, String[] blockIds) {
        this.appId = appId;
        this.execId = execId;
        this.blockIds = blockIds;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.OPEN_BLOCKS;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.execId) * 41 + Arrays.hashCode(this.blockIds);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("appId", (Object)this.appId).append("execId", (Object)this.execId).append("blockIds", (Object)Arrays.toString(this.blockIds)).toString();
    }

    public boolean equals(Object other) {
        if (other instanceof OpenBlocks) {
            OpenBlocks o = (OpenBlocks)other;
            return Objects.equals(this.appId, o.appId) && Objects.equals(this.execId, o.execId) && Arrays.equals(this.blockIds, o.blockIds);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + Encoders.StringArrays.encodedLength((String[])this.blockIds);
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        Encoders.StringArrays.encode((ByteBuf)buf, (String[])this.blockIds);
    }

    public static OpenBlocks decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        String[] blockIds = Encoders.StringArrays.decode((ByteBuf)buf);
        return new OpenBlocks(appId, execId, blockIds);
    }
}

