/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1.streaming;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.status.api.v1.streaming.BaseStreamingAppResource;
import org.apache.spark.status.api.v1.streaming.BatchInfo;
import org.apache.spark.status.api.v1.streaming.BatchStatus;
import org.apache.spark.status.api.v1.streaming.OutputOperationInfo;
import org.apache.spark.status.api.v1.streaming.ReceiverInfo;
import org.apache.spark.status.api.v1.streaming.StreamingStatistics;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.OutputOpIdAndSparkJobId;
import org.apache.spark.streaming.ui.OutputOperationUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.ui.SparkUI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f!B\u0006\r\u00019Q\u0002\"B\u0013\u0001\t\u00039\u0003\"B\u0015\u0001\t\u0003Q\u0003\"\u0002!\u0001\t\u0003\t\u0005\"B+\u0001\t\u00031\u0006\"B3\u0001\t\u00031\u0007bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002\u000e\u0002!I!a$\u00031\u0005\u0003\u0018n\u0015;sK\u0006l\u0017N\\4S_>$(+Z:pkJ\u001cWM\u0003\u0002\u000e\u001d\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u001fA\t!A^\u0019\u000b\u0005E\u0011\u0012aA1qS*\u00111\u0003F\u0001\u0007gR\fG/^:\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c2\u0001A\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002\u0019%\u0011A\u0005\u0004\u0002\u0019\u0005\u0006\u001cXm\u0015;sK\u0006l\u0017N\\4BaB\u0014Vm]8ve\u000e,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003!\u0002\"A\t\u0001\u0002'M$(/Z1nS:<7\u000b^1uSN$\u0018nY:\u0015\u0003-\u0002\"A\t\u0017\n\u00055b!aE*ue\u0016\fW.\u001b8h'R\fG/[:uS\u000e\u001c\b\u0006\u0002\u00020si\u0002\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0005I\u001c(B\u0001\u001b6\u0003\t98OC\u00017\u0003\u0015Q\u0017M^1y\u0013\tA\u0014G\u0001\u0003QCRD\u0017!\u0002<bYV,\u0017%A\u001e\u0002\u0015M$\u0018\r^5ti&\u001c7\u000f\u000b\u0002\u0003{A\u0011\u0001GP\u0005\u0003\u007fE\u00121aR#U\u00035\u0011XmY3jm\u0016\u00148\u000fT5tiR\t!\tE\u0002D\u0017:s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001d3\u0013A\u0002\u001fs_>$h(C\u0001\u001f\u0013\tQU$A\u0004qC\u000e\\\u0017mZ3\n\u00051k%aA*fc*\u0011!*\b\t\u0003E=K!\u0001\u0015\u0007\u0003\u0019I+7-Z5wKJLeNZ8)\t\ry\u0013HU\u0011\u0002'\u0006I!/Z2fSZ,'o\u001d\u0015\u0003\u0007u\n1b\u001c8f%\u0016\u001cW-\u001b<feR\u0011aj\u0016\u0005\u00061\u0012\u0001\r!W\u0001\tgR\u0014X-Y7JIB\u0011ADW\u0005\u00037v\u00111!\u00138uQ\u00119V,\u000f1\u0011\u0005Ar\u0016BA02\u0005%\u0001\u0016\r\u001e5QCJ\fW.I\u0001YQ\u0011!q&\u000f2\"\u0003\r\f\u0011D]3dK&4XM]:0wN$(/Z1n\u0013\u0012T\u0004\u0005\u00183,{\"\u0012A!P\u0001\fE\u0006$8\r[3t\u0019&\u001cH\u000f\u0006\u0002hWB\u00191i\u00135\u0011\u0005\tJ\u0017B\u00016\r\u0005%\u0011\u0015\r^2i\u0013:4w\u000eC\u0003m\u000b\u0001\u0007Q.\u0001\u0007ti\u0006$Xo\u001d)be\u0006l7\u000fE\u0002ogVl\u0011a\u001c\u0006\u0003aF\fA!\u001e;jY*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0011a\u0015n\u001d;\u0011\u0005\t2\u0018BA<\r\u0005-\u0011\u0015\r^2i'R\fG/^:)\t-L\u0018\b \t\u0003aiL!a_\u0019\u0003\u0015E+XM]=QCJ\fW.I\u0001\u0014Q\u0011)q&\u000f@\"\u0003}\fqAY1uG\",7\u000f\u000b\u0002\u0006{\u0005AqN\\3CCR\u001c\u0007\u000eF\u0002i\u0003\u000fAq!!\u0003\u0007\u0001\u0004\tY!A\u0004cCR\u001c\u0007.\u00133\u0011\u0007q\ti!C\u0002\u0002\u0010u\u0011A\u0001T8oO\"2\u0011qA/:\u0003'\t#!!\u0003)\u000b\u0019y\u0013(a\u0006\"\u0005\u0005e\u0011A\u00062bi\u000eDWm]\u0018|E\u0006$8\r[%eu\u0001bFmK?)\u0005\u0019i\u0014AD8qKJ\fG/[8og2K7\u000f\u001e\u000b\u0005\u0003C\tI\u0003\u0005\u0003D\u0017\u0006\r\u0002c\u0001\u0012\u0002&%\u0019\u0011q\u0005\u0007\u0003'=+H\u000f];u\u001fB,'/\u0019;j_:LeNZ8\t\u000f\u0005%q\u00011\u0001\u0002\f!2\u0011\u0011F/:\u0003'ASaB\u0018:\u0003_\t#!!\r\u0002C\t\fGo\u00195fg>Z(-\u0019;dQ&#'\b\t/eWu|s\u000e]3sCRLwN\\:)\u0005\u001di\u0014\u0001D8oK>\u0003XM]1uS>tGCBA\u0012\u0003s\ti\u0004C\u0004\u0002\n!\u0001\r!a\u0003)\r\u0005eR,OA\n\u0011\u001d\ty\u0004\u0003a\u0001\u0003\u0003\nAa\u001c9JIB!\u00111IA2\u001d\u0011\t)%!\u0018\u000f\t\u0005\u001d\u0013q\u000b\b\u0005\u0003\u0013\n)F\u0004\u0003\u0002L\u0005Mc\u0002BA'\u0003#r1!RA(\u0013\u0005I\u0012BA\f\u0019\u0013\t)b#\u0003\u0002\u000e)%!\u0011\u0011LA.\u0003\t)\u0018N\u0003\u0002\u000e)%!\u0011qLA1\u0003q\u0019FO]3b[&twMS8c!J|wM]3tg2K7\u000f^3oKJTA!!\u0017\u0002\\%!\u0011QMA4\u0005)yU\u000f\u001e9vi>\u0003\u0018\n\u001a\u0006\u0005\u0003?\n\t\u0007\u000b\u0004\u0002>uK\u00141N\u0011\u0003\u0003[\n!b\\;uaV$x\n]%eQ\u0015Aq&OA9C\t\t\u0019(A\u001acCR\u001c\u0007.Z:0w\n\fGo\u00195JIj\u0002C\fZ\u0016~_=\u0004XM]1uS>t7oL>pkR\u0004X\u000f^(q\u0013\u0012T\u0004\u0005\u00183,{\"\u0012\u0001\"P\u0001\bCZ<'+\u0019;f)\u0011\tY(a\"\u0011\u000bq\ti(!!\n\u0007\u0005}TD\u0001\u0004PaRLwN\u001c\t\u00049\u0005\r\u0015bAAC;\t1Ai\\;cY\u0016Dq!!#\n\u0001\u0004\tY)\u0001\u0003eCR\f\u0007\u0003B\"L\u0003\u0003\u000bq!\u0019<h)&lW\r\u0006\u0003\u0002\u0012\u0006M\u0005#\u0002\u000f\u0002~\u0005-\u0001bBAE\u0015\u0001\u0007\u0011Q\u0013\t\u0005\u0007.\u000bY\u0001\u000b\u0004\u0001\u00033K\u0014q\u0014\t\u0004a\u0005m\u0015bAAOc\tA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002\"\u0006\u0012\u00111U\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:\u0004")
public class ApiStreamingRootResource
implements BaseStreamingAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withListener(Function1<StreamingJobProgressListener, T> fn) {
        return (T)BaseStreamingAppResource.withListener$(this, fn);
    }

    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$((BaseAppResource)this, fn);
    }

    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$((BaseAppResource)this);
    }

    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$((ApiRequestContext)this);
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    @Path(value="statistics")
    public StreamingStatistics streamingStatistics() {
        return (StreamingStatistics)this.withListener((Function1 & Serializable)listener -> {
            Seq<BatchUIData> batches = listener.retainedBatches();
            Option<Object> avgInputRate = this.avgRate((Seq<Object>)((Seq)batches.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)ApiStreamingRootResource.$anonfun$streamingStatistics$2(listener, x$1)))));
            Option<Object> avgSchedulingDelay = this.avgTime((Seq<Object>)((Seq)batches.flatMap((Function1 & Serializable)x$2 -> x$2.schedulingDelay())));
            Option<Object> avgProcessingTime = this.avgTime((Seq<Object>)((Seq)batches.flatMap((Function1 & Serializable)x$3 -> x$3.processingDelay())));
            Option<Object> avgTotalDelay = this.avgTime((Seq<Object>)((Seq)batches.flatMap((Function1 & Serializable)x$4 -> x$4.totalDelay())));
            return new StreamingStatistics(new Date(listener.startTime()), listener.batchDuration(), listener.numReceivers(), listener.numActiveReceivers(), listener.numInactiveReceivers(), listener.numTotalCompletedBatches(), listener.retainedCompletedBatches().size(), listener.numUnprocessedBatches(), listener.numTotalProcessedRecords(), listener.numTotalReceivedRecords(), avgInputRate, avgSchedulingDelay, avgProcessingTime, avgTotalDelay);
        });
    }

    @GET
    @Path(value="receivers")
    public Seq<ReceiverInfo> receiversList() {
        return (Seq)this.withListener((Function1 & Serializable)listener -> (Seq)((IterableOnceOps)listener.receivedRecordRateWithBatchTime().map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3;
            None$ avgEventRate;
            String streamName;
            Option<org.apache.spark.streaming.scheduler.ReceiverInfo> receiverInfo;
            Seq eventRates;
            int streamId;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple3 tuple32;
                streamId = tuple2._1$mcI$sp();
                eventRates = (Seq)tuple2._2();
                receiverInfo = listener.receiverInfo(streamId);
                streamName = (String)receiverInfo.map((Function1 & Serializable)x$5 -> x$5.name()).orElse((Function0 & Serializable)() -> listener.streamName(streamId)).getOrElse((Function0 & Serializable)() -> new StringBuilder(7).append("Stream-").append(streamId).toString());
                avgEventRate = eventRates.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)eventRates.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6._2$mcD$sp()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)eventRates.size())));
                Option<org.apache.spark.streaming.scheduler.ReceiverInfo> option = receiverInfo;
                if (None$.MODULE$.equals(option)) {
                    tuple32 = new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    org.apache.spark.streaming.scheduler.ReceiverInfo info = (org.apache.spark.streaming.scheduler.ReceiverInfo)some.value();
                    None$ someTime = info.lastErrorTime() >= 0L ? new Some((Object)new Date(info.lastErrorTime())) : None$.MODULE$;
                    None$ someMessage = info.lastErrorMessage().length() > 0 ? new Some((Object)info.lastErrorMessage()) : None$.MODULE$;
                    None$ someError = info.lastError().length() > 0 ? new Some((Object)info.lastError()) : None$.MODULE$;
                    tuple32 = new Tuple3((Object)someTime, (Object)someMessage, (Object)someError);
                } else {
                    throw new MatchError(option);
                }
                Tuple3 tuple33 = tuple32;
                if (tuple33 == null) {
                    throw new MatchError((Object)tuple33);
                }
                Option errorTime = (Option)tuple33._1();
                Option errorMessage = (Option)tuple33._2();
                Option error = (Option)tuple33._3();
                tuple3 = new Tuple3((Object)errorTime, (Object)errorMessage, (Object)error);
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple34 = tuple3;
            Option errorTime = (Option)tuple34._1();
            Option errorMessage = (Option)tuple34._2();
            Option error = (Option)tuple34._3();
            ReceiverInfo receiverInfo2 = new ReceiverInfo(streamId, streamName, (Option<Object>)receiverInfo.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.active())), (Option<String>)receiverInfo.map((Function1 & Serializable)x$9 -> x$9.executorId()), (Option<String>)receiverInfo.map((Function1 & Serializable)x$10 -> x$10.location()), (Option<Date>)errorTime, (Option<String>)errorMessage, (Option<String>)error, (Option<Object>)avgEventRate, (Seq<Tuple2<Object, Object>>)eventRates);
            return receiverInfo2;
        })).toSeq().sortBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.streamId()), (Ordering)Ordering.Int$.MODULE$));
    }

    @GET
    @Path(value="receivers/{streamId: \\d+}")
    public ReceiverInfo oneReceiver(@PathParam(value="streamId") int streamId) {
        return (ReceiverInfo)this.receiversList().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ApiStreamingRootResource.$anonfun$oneReceiver$1(streamId, x$12))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(18).append("unknown receiver: ").append(streamId).toString());
        });
    }

    @GET
    @Path(value="batches")
    public Seq<BatchInfo> batchesList(@QueryParam(value="status") List<BatchStatus> statusParams) {
        return (Seq)this.withListener((Function1 & Serializable)listener -> {
            List<Object> statuses = statusParams.isEmpty() ? Arrays.asList((Object[])BatchStatus.values()) : statusParams;
            Seq statusToBatches = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchStatus.COMPLETED), listener.retainedCompletedBatches()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchStatus.QUEUED), listener.waitingBatches()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchStatus.PROCESSING), listener.runningBatches())}));
            Seq batchInfos = (Seq)statusToBatches.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ApiStreamingRootResource.$anonfun$batchesList$2(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$14 -> {
                Tuple2 tuple2 = x$14;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BatchStatus status = (BatchStatus)((Object)((Object)((Object)tuple2._1())));
                Seq batches = (Seq)tuple2._2();
                Seq seq = (Seq)batches.withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)status))).map((Function1 & Serializable)batch -> {
                    long batchId = batch.batchTime().milliseconds();
                    Option firstFailureReason = ((IterableOps)batch.outputOperations().flatMap((Function1 & Serializable)x$13 -> ((OutputOperationUIData)x$13._2()).failureReason())).headOption();
                    return new BatchInfo(batchId, new Date(batchId), status.toString(), listener.batchDuration(), batch.numRecords(), batch.schedulingDelay(), batch.processingDelay(), batch.totalDelay(), batch.numActiveOutputOp(), batch.numCompletedOutputOp(), batch.numFailedOutputOp(), batch.outputOperations().size(), (Option<String>)firstFailureReason);
                });
                return seq;
            });
            return (Seq)batchInfos.sortBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)ApiStreamingRootResource.$anonfun$batchesList$7(x$15)), (Ordering)Ordering.Long$.MODULE$);
        });
    }

    @GET
    @Path(value="batches/{batchId: \\d+}")
    public BatchInfo oneBatch(@PathParam(value="batchId") long batchId) {
        return (BatchInfo)this.batchesList(Collections.emptyList()).find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ApiStreamingRootResource.$anonfun$oneBatch$1(batchId, x$16))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(15).append("unknown batch: ").append(batchId).toString());
        });
    }

    @GET
    @Path(value="batches/{batchId: \\d+}/operations")
    public Seq<OutputOperationInfo> operationsList(@PathParam(value="batchId") long batchId) {
        return (Seq)this.withListener((Function1 & Serializable)listener -> {
            Option<BatchUIData> option = listener.getBatchUIData(new Time(batchId));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new NotFoundException(new StringBuilder(15).append("unknown batch: ").append(batchId).toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            BatchUIData batch = (BatchUIData)some.value();
            Iterable iterable = (Iterable)batch.outputOperations().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ApiStreamingRootResource.$anonfun$operationsList$2(check$ifrefutable$2))).map((Function1 & Serializable)x$21 -> {
                Tuple2 tuple2 = x$21;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int opId = tuple2._1$mcI$sp();
                OutputOperationUIData op = (OutputOperationUIData)tuple2._2();
                Seq jobIds = (Seq)((IterableOnceOps)((IterableOps)batch.outputOpIdSparkJobIdPairs().filter((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ApiStreamingRootResource.$anonfun$operationsList$4(opId, x$17)))).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.sparkJobId()))).toSeq().sorted((Ordering)Ordering.Int$.MODULE$);
                OutputOperationInfo outputOperationInfo = new OutputOperationInfo(opId, op.name(), op.description(), (Option<Date>)op.startTime().map((Function1 & Serializable)x$19 -> ApiStreamingRootResource.$anonfun$operationsList$6(BoxesRunTime.unboxToLong((Object)x$19))), (Option<Date>)op.endTime().map((Function1 & Serializable)x$20 -> ApiStreamingRootResource.$anonfun$operationsList$7(BoxesRunTime.unboxToLong((Object)x$20))), op.duration(), op.failureReason(), (Seq<Object>)jobIds);
                return outputOperationInfo;
            });
            Iterable ops = iterable;
            return ops.toSeq();
        });
    }

    @GET
    @Path(value="batches/{batchId: \\d+}/operations/{outputOpId: \\d+}")
    public OutputOperationInfo oneOperation(@PathParam(value="batchId") long batchId, @PathParam(value="outputOpId") int opId) {
        return (OutputOperationInfo)this.operationsList(batchId).find((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ApiStreamingRootResource.$anonfun$oneOperation$1(opId, x$22))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(26).append("unknown output operation: ").append(opId).toString());
        });
    }

    private Option<Object> avgRate(Seq<Object> data) {
        return data.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)data.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)data.size())));
    }

    private Option<Object> avgTime(Seq<Object> data) {
        return data.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)data.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)data.size())));
    }

    public static final /* synthetic */ double $anonfun$streamingStatistics$2(StreamingJobProgressListener listener$1, BatchUIData x$1) {
        return (double)x$1.numRecords() * 1000.0 / (double)listener$1.batchDuration();
    }

    public static final /* synthetic */ boolean $anonfun$oneReceiver$1(int streamId$2, ReceiverInfo x$12) {
        return x$12.streamId() == streamId$2;
    }

    public static final /* synthetic */ boolean $anonfun$batchesList$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$batchesList$7(BatchInfo x$15) {
        return -x$15.batchId();
    }

    public static final /* synthetic */ boolean $anonfun$oneBatch$1(long batchId$1, BatchInfo x$16) {
        return x$16.batchId() == batchId$1;
    }

    public static final /* synthetic */ boolean $anonfun$operationsList$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$operationsList$4(int opId$1, OutputOpIdAndSparkJobId x$17) {
        return x$17.outputOpId() == opId$1;
    }

    public static final /* synthetic */ Date $anonfun$operationsList$6(long x$19) {
        return new Date(x$19);
    }

    public static final /* synthetic */ Date $anonfun$operationsList$7(long x$20) {
        return new Date(x$20);
    }

    public static final /* synthetic */ boolean $anonfun$oneOperation$1(int opId$2, OutputOperationInfo x$22) {
        return x$22.outputOpId() == opId$2;
    }

    public ApiStreamingRootResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
        BaseAppResource.$init$((BaseAppResource)this);
        BaseStreamingAppResource.$init$(this);
    }
}

