/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.apache.sling.feature.maven.ProjectHelper;

public class FeatureSelectionConfig {
    private final List<Selection> selections = new ArrayList<Selection>();
    private final List<String> filesExcludes = new ArrayList<String>();

    public void setFilesInclude(String val) {
        this.selections.add(new Selection(SelectionType.FILES_INCLUDE, val));
    }

    public void setFilesExclude(String val) {
        this.filesExcludes.add(val);
    }

    public void setRefsInclude(String val) {
        this.selections.add(new Selection(SelectionType.REFS_INCLUDE, val));
    }

    public void setIncludeArtifact(Dependency a) {
        this.selections.add(new Selection(SelectionType.ARTIFACT, ProjectHelper.toArtifactId(a).toMvnId()));
    }

    public void setIncludeClassifier(String classifier) {
        this.selections.add(new Selection(SelectionType.CLASSIFIER, ":".equals(classifier) ? "" : classifier));
    }

    public List<String> getFilesExcludes() {
        return this.filesExcludes;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public int hashCode() {
        return Objects.hash(this.filesExcludes, this.selections);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureSelectionConfig other = (FeatureSelectionConfig)obj;
        return Objects.equals(this.filesExcludes, other.filesExcludes) && Objects.equals(this.selections, other.selections);
    }

    public String toString() {
        return "FeatureSelectionConfig [selections=" + this.selections + ", filesExcludes=" + this.filesExcludes + "]";
    }

    static class Selection {
        public final SelectionType type;
        public final String instruction;

        public Selection(SelectionType type, String instruction) {
            this.type = type;
            this.instruction = instruction;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.instruction, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Selection other = (Selection)obj;
            return Objects.equals(this.instruction, other.instruction) && this.type == other.type;
        }

        public String toString() {
            return "Selection [type=" + this.type + ", instruction=" + this.instruction + "]";
        }
    }

    static enum SelectionType {
        FILES_INCLUDE,
        CLASSIFIER,
        ARTIFACT,
        REFS_INCLUDE;

    }
}

