/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.jcr;

import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description:String=Generates Test Workspaces ws1, ws2, ws3"})
public class WorkspaceCreator {
    @Reference
    private SlingRepository repo;

    @Activate
    private void activate() {
        Session s = null;
        try {
            s = this.repo.loginAdministrative(null);
            Workspace w = s.getWorkspace();
            this.createWorkspace(w, "ws1");
            this.createWorkspace(w, "ws2");
            this.createWorkspace(w, "ws3");
        }
        catch (Exception exception) {
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    @Deactivate
    private void deactivate() {
        Session s = null;
        try {
            s = this.repo.loginAdministrative(null);
            Workspace w = s.getWorkspace();
            this.deleteWorkspace(w, "ws3");
            this.deleteWorkspace(w, "ws2");
            this.deleteWorkspace(w, "ws1");
        }
        catch (Exception exception) {
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    private void createWorkspace(Workspace w, String name) {
        try {
            w.createWorkspace(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteWorkspace(Workspace w, String name) {
        try {
            w.deleteWorkspace(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

