/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ByteUtils {
    public static final ByteBuffer EMPTY_BUF = ByteBuffer.wrap(new byte[0]);

    private ByteUtils() {
    }

    public static long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static int readUnsignedIntLE(InputStream in) throws IOException {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public static int readUnsignedIntLE(byte[] buffer, int offset) {
        return buffer[offset] << 0 & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static int readIntBE(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    public static void writeUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)(value & 0xFFFFFFFFL));
    }

    public static void writeUnsignedInt(ByteBuffer buffer, long value) {
        buffer.putInt((int)(value & 0xFFFFFFFFL));
    }

    public static void writeUnsignedIntLE(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >>> 8);
        out.write(value >>> 16);
        out.write(value >>> 24);
    }

    public static void writeUnsignedIntLE(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)value;
        buffer[offset + 1] = (byte)(value >>> 8);
        buffer[offset + 2] = (byte)(value >>> 16);
        buffer[offset + 3] = (byte)(value >>> 24);
    }

    public static int readUnsignedVarint(ByteBuffer buffer) {
        byte tmp = buffer.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = buffer.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = buffer.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = buffer.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = buffer.get();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw ByteUtils.illegalVarintException(result);
                    }
                }
            }
        }
        return result;
    }

    static int readUnsignedVarint(InputStream in) throws IOException {
        byte tmp = (byte)in.read();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = (byte)in.read();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = (byte)in.read();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = (byte)in.read();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = (byte)in.read();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw ByteUtils.illegalVarintException(result);
                    }
                }
            }
        }
        return result;
    }

    public static int readVarint(ByteBuffer buffer) {
        int value = ByteUtils.readUnsignedVarint(buffer);
        return value >>> 1 ^ -(value & 1);
    }

    public static int readVarint(InputStream in) throws IOException {
        int value = ByteUtils.readUnsignedVarint(in);
        return value >>> 1 ^ -(value & 1);
    }

    public static long readVarlong(InputStream in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.read()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value);
        }
        return (value |= b << i) >>> 1 ^ -(value & 1L);
    }

    public static long readVarlong(ByteBuffer buffer) {
        long raw = ByteUtils.readUnsignedVarlong(buffer);
        return raw >>> 1 ^ -(raw & 1L);
    }

    static long readUnsignedVarlong(ByteBuffer buffer) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)buffer.get()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value);
        }
        return value |= b << i;
    }

    public static double readDouble(DataInput in) throws IOException {
        return in.readDouble();
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static void writeUnsignedVarint(int value, ByteBuffer buffer) {
        if ((value & 0xFFFFFF80) == 0) {
            buffer.put((byte)value);
        } else {
            buffer.put((byte)(value & 0x7F | 0x80));
            if ((value & 0xFFFFC000) == 0) {
                buffer.put((byte)(value >>> 7 & 0xFF));
            } else {
                buffer.put((byte)(value >>> 7 & 0x7F | 0x80));
                if ((value & 0xFFE00000) == 0) {
                    buffer.put((byte)(value >>> 14 & 0xFF));
                } else {
                    buffer.put((byte)(value >>> 14 & 0x7F | 0x80));
                    if ((value & 0xF0000000) == 0) {
                        buffer.put((byte)(value >>> 21 & 0xFF));
                    } else {
                        buffer.put((byte)(value >>> 21 & 0x7F | 0x80));
                        buffer.put((byte)(value >>> 28 & 0xFF));
                    }
                }
            }
        }
    }

    public static void writeUnsignedVarint(int value, DataOutput out) throws IOException {
        if ((value & 0xFFFFFF80) == 0) {
            out.writeByte(value);
        } else {
            out.writeByte(value & 0x7F | 0x80);
            if ((value & 0xFFFFC000) == 0) {
                out.writeByte(value >>> 7);
            } else {
                out.writeByte(value >>> 7 & 0x7F | 0x80);
                if ((value & 0xFFE00000) == 0) {
                    out.writeByte(value >>> 14);
                } else {
                    out.writeByte((byte)(value >>> 14 & 0x7F | 0x80));
                    if ((value & 0xF0000000) == 0) {
                        out.writeByte(value >>> 21);
                    } else {
                        out.writeByte(value >>> 21 & 0x7F | 0x80);
                        out.writeByte(value >>> 28);
                    }
                }
            }
        }
    }

    public static void writeVarint(int value, DataOutput out) throws IOException {
        ByteUtils.writeUnsignedVarint(value << 1 ^ value >> 31, out);
    }

    public static void writeVarint(int value, ByteBuffer buffer) {
        ByteUtils.writeUnsignedVarint(value << 1 ^ value >> 31, buffer);
    }

    public static void writeVarlong(long value, DataOutput out) throws IOException {
        long v = value << 1 ^ value >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)v & 0x7F | 0x80);
            v >>>= 7;
        }
        out.writeByte((byte)v);
    }

    public static void writeVarlong(long value, ByteBuffer buffer) {
        long v = value << 1 ^ value >> 63;
        ByteUtils.writeUnsignedVarlong(v, buffer);
    }

    public static void writeUnsignedVarlong(long v, ByteBuffer buffer) {
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            buffer.put(b);
            v >>>= 7;
        }
        buffer.put((byte)v);
    }

    public static void writeDouble(double value, DataOutput out) throws IOException {
        out.writeDouble(value);
    }

    public static void writeDouble(double value, ByteBuffer buffer) {
        buffer.putDouble(value);
    }

    public static int sizeOfUnsignedVarint(int value) {
        int leadingZeros = Integer.numberOfLeadingZeros(value);
        int leadingZerosBelow38DividedBy7 = (38 - leadingZeros) * 74899 >>> 19;
        return leadingZerosBelow38DividedBy7 + (leadingZeros >>> 5);
    }

    public static int sizeOfVarint(int value) {
        return ByteUtils.sizeOfUnsignedVarint(value << 1 ^ value >> 31);
    }

    public static int sizeOfVarlong(long value) {
        return ByteUtils.sizeOfUnsignedVarlong(value << 1 ^ value >> 63);
    }

    public static int sizeOfUnsignedVarlong(long v) {
        int leadingZeros = Long.numberOfLeadingZeros(v);
        int leadingZerosBelow70DividedBy7 = (70 - leadingZeros) * 74899 >>> 19;
        return leadingZerosBelow70DividedBy7 + (leadingZeros >>> 6);
    }

    private static IllegalArgumentException illegalVarintException(int value) {
        throw new IllegalArgumentException("Varint is too long, the most significant bit in the 5th byte is set, converted value: " + Integer.toHexString(value));
    }

    private static IllegalArgumentException illegalVarlongException(long value) {
        throw new IllegalArgumentException("Varlong is too long, most significant bit in the 10th byte is set, converted value: " + Long.toHexString(value));
    }
}

