/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.ClientResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Cluster;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.KafkaException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Node;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.PartitionInfo;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.RetriableException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.TimeoutException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.MetadataRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.MetadataResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Timer;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

public class TopicMetadataFetcher {
    private final Logger log;
    private final ConsumerNetworkClient client;
    private final ExponentialBackoff retryBackoff;

    public TopicMetadataFetcher(LogContext logContext, ConsumerNetworkClient client, long retryBackoffMs, long retryBackoffMaxMs) {
        this.log = logContext.logger(this.getClass());
        this.client = client;
        this.retryBackoff = new ExponentialBackoff(retryBackoffMs, 2, retryBackoffMaxMs, 0.2);
    }

    public List<PartitionInfo> getTopicMetadata(String topic, boolean allowAutoTopicCreation, Timer timer) {
        MetadataRequest.Builder request = new MetadataRequest.Builder(Collections.singletonList(topic), allowAutoTopicCreation);
        Map<String, List<PartitionInfo>> topicMetadata = this.getTopicMetadata(request, timer);
        return topicMetadata.get(topic);
    }

    public Map<String, List<PartitionInfo>> getAllTopicMetadata(Timer timer) {
        MetadataRequest.Builder request = MetadataRequest.Builder.allTopics();
        return this.getTopicMetadata(request, timer);
    }

    private Map<String, List<PartitionInfo>> getTopicMetadata(MetadataRequest.Builder request, Timer timer) {
        if (!request.isAllTopics() && request.emptyTopicList()) {
            return Collections.emptyMap();
        }
        long attempts = 0L;
        do {
            RequestFuture<ClientResponse> future = this.sendMetadataRequest(request);
            this.client.poll(future, timer);
            if (future.failed() && !future.isRetriable()) {
                throw future.exception();
            }
            if (future.succeeded()) {
                MetadataResponse response = (MetadataResponse)future.value().responseBody();
                Cluster cluster = response.buildCluster();
                Set<String> unauthorizedTopics = cluster.unauthorizedTopics();
                if (!unauthorizedTopics.isEmpty()) {
                    throw new TopicAuthorizationException(unauthorizedTopics);
                }
                boolean shouldRetry = false;
                Map<String, Errors> errors = response.errors();
                if (!errors.isEmpty()) {
                    this.log.debug("Topic metadata fetch included errors: {}", (Object)errors);
                    for (Map.Entry<String, Errors> errorEntry : errors.entrySet()) {
                        String topic = errorEntry.getKey();
                        Errors error = errorEntry.getValue();
                        if (error == Errors.INVALID_TOPIC_EXCEPTION) {
                            throw new InvalidTopicException("Topic '" + topic + "' is invalid");
                        }
                        if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) continue;
                        if (error.exception() instanceof RetriableException) {
                            shouldRetry = true;
                            continue;
                        }
                        throw new KafkaException("Unexpected error fetching metadata for topic " + topic, error.exception());
                    }
                }
                if (!shouldRetry) {
                    HashMap<String, List<PartitionInfo>> topicsPartitionInfos = new HashMap<String, List<PartitionInfo>>();
                    for (String topic : cluster.topics()) {
                        topicsPartitionInfos.put(topic, cluster.partitionsForTopic(topic));
                    }
                    return topicsPartitionInfos;
                }
            }
            timer.sleep(this.retryBackoff.backoff(attempts++));
        } while (timer.notExpired());
        throw new TimeoutException("Timeout expired while fetching topic metadata");
    }

    private RequestFuture<ClientResponse> sendMetadataRequest(MetadataRequest.Builder request) {
        Node node = this.client.leastLoadedNode();
        if (node == null) {
            return RequestFuture.noBrokersAvailable();
        }
        return this.client.send(node, request);
    }
}

