/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.metrics.RebalanceCallbackMetricsManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.InterruptException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.WakeupException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Time;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

public class ConsumerRebalanceListenerInvoker {
    private final Logger log;
    private final SubscriptionState subscriptions;
    private final Time time;
    private final RebalanceCallbackMetricsManager metricsManager;

    ConsumerRebalanceListenerInvoker(LogContext logContext, SubscriptionState subscriptions, Time time, RebalanceCallbackMetricsManager metricsManager) {
        this.log = logContext.logger(this.getClass());
        this.subscriptions = subscriptions;
        this.time = time;
        this.metricsManager = metricsManager;
    }

    public Exception invokePartitionsAssigned(SortedSet<TopicPartition> assignedPartitions) {
        this.log.info("Adding newly assigned partitions: {}", (Object)assignedPartitions.stream().map(TopicPartition::toString).collect(Collectors.joining(", ")));
        Optional<ConsumerRebalanceListener> listener = this.subscriptions.rebalanceListener();
        if (listener.isPresent()) {
            try {
                long startMs = this.time.milliseconds();
                listener.get().onPartitionsAssigned(assignedPartitions);
                this.metricsManager.recordPartitionsAssignedLatency(this.time.milliseconds() - startMs);
            }
            catch (InterruptException | WakeupException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("User provided listener {} failed on invocation of onPartitionsAssigned for partitions {}", listener.get().getClass().getName(), assignedPartitions, e);
                return e;
            }
        }
        return null;
    }

    public Exception invokePartitionsRevoked(SortedSet<TopicPartition> revokedPartitions) {
        Optional<ConsumerRebalanceListener> listener;
        this.log.info("Revoke previously assigned partitions {}", (Object)revokedPartitions.stream().map(TopicPartition::toString).collect(Collectors.joining(", ")));
        Set<TopicPartition> revokePausedPartitions = this.subscriptions.pausedPartitions();
        revokePausedPartitions.retainAll(revokedPartitions);
        if (!revokePausedPartitions.isEmpty()) {
            this.log.info("The pause flag in partitions [{}] will be removed due to revocation.", (Object)revokePausedPartitions.stream().map(TopicPartition::toString).collect(Collectors.joining(", ")));
        }
        if ((listener = this.subscriptions.rebalanceListener()).isPresent()) {
            try {
                long startMs = this.time.milliseconds();
                listener.get().onPartitionsRevoked(revokedPartitions);
                this.metricsManager.recordPartitionsRevokedLatency(this.time.milliseconds() - startMs);
            }
            catch (InterruptException | WakeupException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("User provided listener {} failed on invocation of onPartitionsRevoked for partitions {}", listener.get().getClass().getName(), revokedPartitions, e);
                return e;
            }
        }
        return null;
    }

    public Exception invokePartitionsLost(SortedSet<TopicPartition> lostPartitions) {
        Optional<ConsumerRebalanceListener> listener;
        this.log.info("Lost previously assigned partitions {}", (Object)lostPartitions.stream().map(TopicPartition::toString).collect(Collectors.joining(", ")));
        Set<TopicPartition> lostPausedPartitions = this.subscriptions.pausedPartitions();
        lostPausedPartitions.retainAll(lostPartitions);
        if (!lostPausedPartitions.isEmpty()) {
            this.log.info("The pause flag in partitions [{}] will be removed due to partition lost.", (Object)lostPartitions.stream().map(TopicPartition::toString).collect(Collectors.joining(", ")));
        }
        if ((listener = this.subscriptions.rebalanceListener()).isPresent()) {
            try {
                long startMs = this.time.milliseconds();
                listener.get().onPartitionsLost(lostPartitions);
                this.metricsManager.recordPartitionsLostLatency(this.time.milliseconds() - startMs);
            }
            catch (InterruptException | WakeupException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("User provided listener {} failed on invocation of onPartitionsLost for partitions {}", listener.get().getClass().getName(), lostPartitions, e);
                return e;
            }
        }
        return null;
    }
}

