/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.opengis.util.GenericName;

public final class AssociationRoleBuilder
extends PropertyTypeBuilder {
    private final DefaultFeatureType type;
    private final GenericName typeName;
    private transient DefaultAssociationRole property;

    AssociationRoleBuilder(FeatureTypeBuilder owner, DefaultFeatureType type, GenericName typeName) {
        super(owner);
        this.type = type;
        this.typeName = typeName;
    }

    AssociationRoleBuilder(FeatureTypeBuilder owner, DefaultAssociationRole template) {
        super(owner);
        this.property = template;
        this.minimumOccurs = template.getMinimumOccurs();
        this.maximumOccurs = template.getMaximumOccurs();
        if (!template.isResolved()) {
            this.type = null;
            this.typeName = Features.getValueTypeName(template);
        } else {
            this.type = template.getValueType();
            this.typeName = this.type.getName();
        }
        this.initialize(template);
    }

    @Override
    final void clearCache() {
        this.property = null;
        super.clearCache();
    }

    @Override
    final void toStringInternal(StringBuilder buffer) {
        buffer.append(" \u2192 ").append(this.typeName);
    }

    @Override
    final String getDefaultName() {
        return this.typeName.tip().toString();
    }

    @Override
    public AssociationRoleBuilder setName(GenericName name) {
        super.setName(name);
        return this;
    }

    @Override
    public AssociationRoleBuilder setName(CharSequence localPart) {
        super.setName(localPart);
        return this;
    }

    @Override
    public AssociationRoleBuilder setName(CharSequence ... components) {
        super.setName(components);
        return this;
    }

    @Override
    public AssociationRoleBuilder setMinimumOccurs(int occurs) {
        super.setMinimumOccurs(occurs);
        return this;
    }

    @Override
    public AssociationRoleBuilder setMaximumOccurs(int occurs) {
        super.setMaximumOccurs(occurs);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDefinition(CharSequence definition) {
        super.setDefinition(definition);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDesignation(CharSequence designation) {
        super.setDesignation(designation);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDescription(CharSequence description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDeprecated(boolean deprecated) {
        super.setDeprecated(deprecated);
        return this;
    }

    @Override
    public DefaultAssociationRole build() {
        if (this.property == null) {
            this.property = this.type != null ? new DefaultAssociationRole(this.identification(), this.type, this.minimumOccurs, this.maximumOccurs) : new DefaultAssociationRole(this.identification(), this.typeName, this.minimumOccurs, this.maximumOccurs);
        }
        return this.property;
    }
}

