/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.Set;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.matrix.UnderdeterminedMatrixException;
import org.apache.sis.util.collection.CodeListSet;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.CodeList;

public class MissingSourceDimensionsException
extends OperationNotFoundException {
    private static final long serialVersionUID = 5228802326932593847L;
    private CodeListSet<AxisDirection> axes;

    public MissingSourceDimensionsException() {
    }

    public MissingSourceDimensionsException(String message) {
        super(message);
    }

    public MissingSourceDimensionsException(String message, Throwable cause) {
        super(message, cause);
    }

    final void addMissing(CoordinateSystem source, CoordinateSystem target) {
        int i = target.getDimension();
        while (--i >= 0) {
            AxisDirection direction = target.getAxis(i).getDirection();
            if (AxisDirections.indexOfColinear(source, direction) >= 0) continue;
            this.addMissing(direction);
        }
    }

    public void addMissing(AxisDirection direction) {
        if (this.axes == null) {
            this.axes = new CodeListSet(AxisDirection.class);
            Throwable cause = this.getCause();
            if (cause instanceof UnderdeterminedMatrixException) {
                this.axes.addAll(((UnderdeterminedMatrixException)cause).getUnknownAxes());
            }
        }
        this.axes.add((CodeList)direction);
    }

    public Set<AxisDirection> getMissingAxes() {
        if (this.axes != null) {
            return Collections.unmodifiableSet(this.axes);
        }
        Throwable cause = this.getCause();
        if (cause instanceof UnderdeterminedMatrixException) {
            return ((UnderdeterminedMatrixException)cause).getUnknownAxes();
        }
        return Set.of();
    }
}

