/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support;

import com.weibo.api.motan.closable.Closable;
import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.AbstractRegistry;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class FailbackRegistry
extends AbstractRegistry {
    private Set<URL> failedRegistered = new ConcurrentHashSet<URL>();
    private Set<URL> failedUnregistered = new ConcurrentHashSet<URL>();
    private ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>> failedSubscribed = new ConcurrentHashMap();
    private ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>> failedUnsubscribed = new ConcurrentHashMap();
    private static ScheduledExecutorService retryExecutor = Executors.newScheduledThreadPool(1);

    public FailbackRegistry(URL url) {
        super(url);
        long retryPeriod = url.getIntParameter(URLParamType.registryRetryPeriod.getName(), URLParamType.registryRetryPeriod.getIntValue()).intValue();
        retryExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    FailbackRegistry.this.retry();
                }
                catch (Exception e) {
                    LoggerUtil.warn(String.format("[%s] False when retry in failback registry", FailbackRegistry.this.registryClassName), e);
                }
            }
        }, retryPeriod, retryPeriod, TimeUnit.MILLISECONDS);
    }

    @Override
    public void register(URL url) {
        this.failedRegistered.remove(url);
        this.failedUnregistered.remove(url);
        try {
            super.register(url);
        }
        catch (Exception e) {
            if (this.isCheckingUrls(this.getUrl(), url)) {
                throw new MotanFrameworkException(String.format("[%s] false to registery %s to %s", this.registryClassName, url, this.getUrl()), e);
            }
            this.failedRegistered.add(url);
        }
    }

    @Override
    public void unregister(URL url) {
        this.failedRegistered.remove(url);
        this.failedUnregistered.remove(url);
        try {
            super.unregister(url);
        }
        catch (Exception e) {
            if (this.isCheckingUrls(this.getUrl(), url)) {
                throw new MotanFrameworkException(String.format("[%s] false to unregistery %s to %s", this.registryClassName, url, this.getUrl()), e);
            }
            this.failedUnregistered.add(url);
        }
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        this.removeForFailedSubAndUnsub(url, listener);
        try {
            super.subscribe(url, listener);
        }
        catch (Exception e) {
            List<URL> cachedUrls = this.getCachedUrls(url);
            if (cachedUrls != null && cachedUrls.size() > 0) {
                listener.notify(this.getUrl(), cachedUrls);
            } else if (this.isCheckingUrls(this.getUrl(), url)) {
                LoggerUtil.warn(String.format("[%s] false to subscribe %s from %s", this.registryClassName, url, this.getUrl()), e);
                throw new MotanFrameworkException(String.format("[%s] false to subscribe %s from %s", this.registryClassName, url, this.getUrl()), e);
            }
            this.addToFailedMap(this.failedSubscribed, url, listener);
        }
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        this.removeForFailedSubAndUnsub(url, listener);
        try {
            super.unsubscribe(url, listener);
        }
        catch (Exception e) {
            if (this.isCheckingUrls(this.getUrl(), url)) {
                throw new MotanFrameworkException(String.format("[%s] false to unsubscribe %s from %s", this.registryClassName, url, this.getUrl()), e);
            }
            this.addToFailedMap(this.failedUnsubscribed, url, listener);
        }
    }

    @Override
    public List<URL> discover(URL url) {
        try {
            return super.discover(url);
        }
        catch (Exception e) {
            LoggerUtil.warn(String.format("Failed to discover url:%s in registry (%s)", url, this.getUrl()), e);
            return Collections.EMPTY_LIST;
        }
    }

    private boolean isCheckingUrls(URL ... urls) {
        for (URL url : urls) {
            if (Boolean.parseBoolean(url.getParameter(URLParamType.check.getName(), URLParamType.check.getValue()))) continue;
            return false;
        }
        return true;
    }

    private void removeForFailedSubAndUnsub(URL url, NotifyListener listener) {
        Set listeners = this.failedSubscribed.get(url);
        if (listeners != null) {
            listeners.remove(listener);
        }
        if ((listeners = (Set)this.failedUnsubscribed.get(url)) != null) {
            listeners.remove(listener);
        }
    }

    private void addToFailedMap(ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>> failedMap, URL url, NotifyListener listener) {
        Set listeners = failedMap.get(url);
        if (listeners == null) {
            failedMap.putIfAbsent(url, new ConcurrentHashSet());
            listeners = failedMap.get(url);
        }
        listeners.add(listener);
    }

    private void retry() {
        Set listeners;
        URL url;
        URL url2;
        Cloneable failed;
        if (!this.failedRegistered.isEmpty()) {
            failed = new HashSet<URL>(this.failedRegistered);
            LoggerUtil.info("[{}] Retry register {}", this.registryClassName, failed);
            try {
                Iterator iterator = failed.iterator();
                while (iterator.hasNext()) {
                    url2 = (URL)iterator.next();
                    super.register(url2);
                    this.failedRegistered.remove(url2);
                }
            }
            catch (Exception e) {
                LoggerUtil.warn(String.format("[%s] Failed to retry register, retry later, failedRegistered.size=%s, cause=%s", this.registryClassName, this.failedRegistered.size(), e.getMessage()), e);
            }
        }
        if (!this.failedUnregistered.isEmpty()) {
            failed = new HashSet<URL>(this.failedUnregistered);
            LoggerUtil.info("[{}] Retry unregister {}", this.registryClassName, failed);
            try {
                Iterator e = failed.iterator();
                while (e.hasNext()) {
                    url2 = (URL)((Object)e.next());
                    super.unregister(url2);
                    this.failedUnregistered.remove(url2);
                }
            }
            catch (Exception e) {
                LoggerUtil.warn(String.format("[%s] Failed to retry unregister, retry later, failedUnregistered.size=%s, cause=%s", this.registryClassName, this.failedUnregistered.size(), e.getMessage()), e);
            }
        }
        if (!this.failedSubscribed.isEmpty()) {
            failed = new HashMap<URL, ConcurrentHashSet<NotifyListener>>(this.failedSubscribed);
            for (Map.Entry entry : new HashMap(failed).entrySet()) {
                if (entry.getValue() != null && ((Set)entry.getValue()).size() != 0) continue;
                failed.remove(entry.getKey());
            }
            if (failed.size() > 0) {
                LoggerUtil.info("[{}] Retry subscribe {}", this.registryClassName, failed);
                try {
                    for (Map.Entry entry : failed.entrySet()) {
                        url = (URL)entry.getKey();
                        listeners = (Set)entry.getValue();
                        for (NotifyListener listener : listeners) {
                            super.subscribe(url, listener);
                            listeners.remove(listener);
                        }
                    }
                }
                catch (Exception e) {
                    LoggerUtil.warn(String.format("[%s] Failed to retry subscribe, retry later, failedSubscribed.size=%s, cause=%s", this.registryClassName, this.failedSubscribed.size(), e.getMessage()), e);
                }
            }
        }
        if (!this.failedUnsubscribed.isEmpty()) {
            failed = new HashMap<URL, ConcurrentHashSet<NotifyListener>>(this.failedUnsubscribed);
            for (Map.Entry entry : new HashMap(failed).entrySet()) {
                if (entry.getValue() != null && ((Set)entry.getValue()).size() != 0) continue;
                failed.remove(entry.getKey());
            }
            if (failed.size() > 0) {
                LoggerUtil.info("[{}] Retry unsubscribe {}", this.registryClassName, failed);
                try {
                    for (Map.Entry entry : failed.entrySet()) {
                        url = (URL)entry.getKey();
                        listeners = (Set)entry.getValue();
                        for (NotifyListener listener : listeners) {
                            super.unsubscribe(url, listener);
                            listeners.remove(listener);
                        }
                    }
                }
                catch (Exception e) {
                    LoggerUtil.warn(String.format("[%s] Failed to retry unsubscribe, retry later, failedUnsubscribed.size=%s, cause=%s", this.registryClassName, this.failedUnsubscribed.size(), e.getMessage()), e);
                }
            }
        }
    }

    static {
        ShutDownHook.registerShutdownHook(new Closable(){

            @Override
            public void close() {
                if (!retryExecutor.isShutdown()) {
                    retryExecutor.shutdown();
                }
            }
        });
    }
}

