/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStats;
import co.elastic.clients.elasticsearch.snapshot.SnapshotIndexStats;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Status
implements JsonpSerializable {
    private final boolean includeGlobalState;
    private final Map<String, SnapshotIndexStats> indices;
    private final String repository;
    private final ShardsStats shardsStats;
    private final String snapshot;
    private final String state;
    private final SnapshotStats stats;
    private final String uuid;
    public static final JsonpDeserializer<Status> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Status::setupStatusDeserializer);

    private Status(Builder builder) {
        this.includeGlobalState = ApiTypeHelper.requireNonNull(builder.includeGlobalState, this, "includeGlobalState");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.shardsStats = ApiTypeHelper.requireNonNull(builder.shardsStats, this, "shardsStats");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
        this.uuid = ApiTypeHelper.requireNonNull(builder.uuid, this, "uuid");
    }

    public static Status of(Function<Builder, ObjectBuilder<Status>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public final Map<String, SnapshotIndexStats> indices() {
        return this.indices;
    }

    public final String repository() {
        return this.repository;
    }

    public final ShardsStats shardsStats() {
        return this.shardsStats;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    public final String state() {
        return this.state;
    }

    public final SnapshotStats stats() {
        return this.stats;
    }

    public final String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("include_global_state");
        generator.write(this.includeGlobalState);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, SnapshotIndexStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("repository");
        generator.write(this.repository);
        generator.writeKey("shards_stats");
        this.shardsStats.serialize(generator, mapper);
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        generator.writeKey("state");
        generator.write(this.state);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        generator.writeKey("uuid");
        generator.write(this.uuid);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(SnapshotIndexStats._DESERIALIZER), "indices");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository");
        op.add(Builder::shardsStats, ShardsStats._DESERIALIZER, "shards_stats");
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
        op.add(Builder::stats, SnapshotStats._DESERIALIZER, "stats");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Status> {
        private Boolean includeGlobalState;
        private Map<String, SnapshotIndexStats> indices;
        private String repository;
        private ShardsStats shardsStats;
        private String snapshot;
        private String state;
        private SnapshotStats stats;
        private String uuid;

        public final Builder includeGlobalState(boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public final Builder indices(Map<String, SnapshotIndexStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        public final Builder indices(String key, SnapshotIndexStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        public final Builder indices(String key, Function<SnapshotIndexStats.Builder, ObjectBuilder<SnapshotIndexStats>> fn) {
            return this.indices(key, fn.apply(new SnapshotIndexStats.Builder()).build());
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder shardsStats(ShardsStats value) {
            this.shardsStats = value;
            return this;
        }

        public final Builder shardsStats(Function<ShardsStats.Builder, ObjectBuilder<ShardsStats>> fn) {
            return this.shardsStats(fn.apply(new ShardsStats.Builder()).build());
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder state(String value) {
            this.state = value;
            return this;
        }

        public final Builder stats(SnapshotStats value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<SnapshotStats.Builder, ObjectBuilder<SnapshotStats>> fn) {
            return this.stats(fn.apply(new SnapshotStats.Builder()).build());
        }

        public final Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Status build() {
            this._checkSingleUse();
            return new Status(this);
        }
    }
}

