/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.lock;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.LockClusterStatement;
import org.apache.shardingsphere.infra.algorithm.core.exception.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperation;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.lock.exception.LockedClusterException;
import org.apache.shardingsphere.mode.state.ShardingSphereState;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.lock.LockClusterOperation;
import org.apache.shardingsphere.proxy.backend.lock.spi.ClusterLockStrategy;

@DistSQLExecutorClusterModeRequired
public final class LockClusterExecutor
implements DistSQLUpdateExecutor<LockClusterStatement> {
    public void executeUpdate(LockClusterStatement sqlStatement, ContextManager contextManager) throws SQLException {
        this.checkState(contextManager);
        this.checkAlgorithm(sqlStatement);
        contextManager.getExclusiveOperatorEngine().operate((ExclusiveOperation)new LockClusterOperation(), sqlStatement.getTimeoutMillis(), () -> {
            this.checkState(contextManager);
            ((ClusterLockStrategy)TypedSPILoader.getService(ClusterLockStrategy.class, (Object)sqlStatement.getLockStrategy().getName())).lock();
        });
    }

    private void checkState(ContextManager contextManager) {
        ShardingSpherePreconditions.checkState((ShardingSphereState.OK == contextManager.getStateContext().getState() ? 1 : 0) != 0, LockedClusterException::new);
    }

    private void checkAlgorithm(LockClusterStatement sqlStatement) {
        ShardingSpherePreconditions.checkNotNull((Object)sqlStatement.getLockStrategy(), () -> new MissingRequiredAlgorithmException("Lock", new SQLExceptionIdentifier("")));
        TypedSPILoader.checkService(ClusterLockStrategy.class, (Object)sqlStatement.getLockStrategy().getName(), (Properties)sqlStatement.getLockStrategy().getProps());
    }

    public Class<LockClusterStatement> getType() {
        return LockClusterStatement.class;
    }
}

