/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.classbased;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.algorithm.sharding.classbased.ClassBasedShardingAlgorithmFactory;
import org.apache.shardingsphere.sharding.algorithm.sharding.classbased.ClassBasedShardingAlgorithmStrategyType;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class ClassBasedShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ComplexKeysShardingAlgorithm<Comparable<?>>,
HintShardingAlgorithm<Comparable<?>> {
    private static final String STRATEGY_KEY = "strategy";
    private static final String ALGORITHM_CLASS_NAME_KEY = "algorithmClassName";
    private ClassBasedShardingAlgorithmStrategyType strategy;
    private String algorithmClassName;
    private StandardShardingAlgorithm standardShardingAlgorithm;
    private ComplexKeysShardingAlgorithm complexKeysShardingAlgorithm;
    private HintShardingAlgorithm hintShardingAlgorithm;

    public void init(Properties props) {
        this.strategy = this.getStrategy(props);
        this.algorithmClassName = this.getAlgorithmClassName(props);
        this.initAlgorithmInstance(props);
    }

    private ClassBasedShardingAlgorithmStrategyType getStrategy(Properties props) {
        String strategy = props.getProperty(STRATEGY_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)strategy, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Properties `%s` can not be null or empty when uses class based sharding strategy", new Object[]{STRATEGY_KEY}));
        String shardingAlgorithmStrategyType = strategy.toUpperCase().trim();
        ShardingSpherePreconditions.checkState((boolean)Arrays.stream(ClassBasedShardingAlgorithmStrategyType.values()).anyMatch(each -> each.name().equals(shardingAlgorithmStrategyType)), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Unsupported sharding strategy `%s`", new Object[]{strategy}));
        return ClassBasedShardingAlgorithmStrategyType.valueOf(shardingAlgorithmStrategyType);
    }

    private String getAlgorithmClassName(Properties props) {
        String result = props.getProperty(ALGORITHM_CLASS_NAME_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)result, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "Sharding algorithm class name can not be null or empty", new Object[0]));
        return result;
    }

    private void initAlgorithmInstance(Properties props) {
        switch (this.strategy) {
            case STANDARD: {
                this.standardShardingAlgorithm = ClassBasedShardingAlgorithmFactory.newInstance(this.algorithmClassName, StandardShardingAlgorithm.class, props);
                break;
            }
            case COMPLEX: {
                this.complexKeysShardingAlgorithm = ClassBasedShardingAlgorithmFactory.newInstance(this.algorithmClassName, ComplexKeysShardingAlgorithm.class, props);
                break;
            }
            case HINT: {
                this.hintShardingAlgorithm = ClassBasedShardingAlgorithmFactory.newInstance(this.algorithmClassName, HintShardingAlgorithm.class, props);
                break;
            }
        }
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        return this.standardShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.standardShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, ComplexKeysShardingValue<Comparable<?>> shardingValue) {
        return this.complexKeysShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, HintShardingValue<Comparable<?>> shardingValue) {
        return this.hintShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public String getType() {
        return "CLASS_BASED";
    }
}

