/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.distsql.handler.update;

import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sqlfederation.compiler.exception.InvalidExecutionPlanCacheConfigException;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationCacheOption;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.distsql.segment.CacheOptionSegment;
import org.apache.shardingsphere.sqlfederation.distsql.statement.updatable.AlterSQLFederationRuleStatement;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;

public final class AlterSQLFederationRuleExecutor
implements GlobalRuleDefinitionExecutor<AlterSQLFederationRuleStatement, SQLFederationRule> {
    private SQLFederationRule rule;

    public SQLFederationRuleConfiguration buildToBeAlteredRuleConfiguration(AlterSQLFederationRuleStatement sqlStatement) {
        boolean sqlFederationEnabled = null == sqlStatement.getSqlFederationEnabled() ? this.rule.getConfiguration().isSqlFederationEnabled() : sqlStatement.getSqlFederationEnabled().booleanValue();
        boolean allQueryUseSQLFederation = null == sqlStatement.getAllQueryUseSQLFederation() ? this.rule.getConfiguration().isAllQueryUseSQLFederation() : sqlStatement.getAllQueryUseSQLFederation().booleanValue();
        SQLFederationCacheOption executionPlanCache = null == sqlStatement.getExecutionPlanCache() ? this.rule.getConfiguration().getExecutionPlanCache() : this.createCacheOption(this.rule.getConfiguration().getExecutionPlanCache(), sqlStatement.getExecutionPlanCache());
        return new SQLFederationRuleConfiguration(sqlFederationEnabled, allQueryUseSQLFederation, executionPlanCache);
    }

    private SQLFederationCacheOption createCacheOption(SQLFederationCacheOption cacheOption, CacheOptionSegment segment) {
        int initialCapacity = null == segment.getInitialCapacity() ? cacheOption.getInitialCapacity() : segment.getInitialCapacity().intValue();
        long maximumSize = null == segment.getMaximumSize() ? cacheOption.getMaximumSize() : segment.getMaximumSize().longValue();
        SQLFederationCacheOption result = new SQLFederationCacheOption(initialCapacity, maximumSize);
        this.checkExecutionPlanCacheConfig(result);
        return result;
    }

    private void checkExecutionPlanCacheConfig(SQLFederationCacheOption executionPlanCache) {
        ShardingSpherePreconditions.checkState((executionPlanCache.getInitialCapacity() > 0 ? 1 : 0) != 0, () -> new InvalidExecutionPlanCacheConfigException((Object)"initialCapacity", (Object)executionPlanCache.getInitialCapacity()));
        ShardingSpherePreconditions.checkState((executionPlanCache.getMaximumSize() > 0L ? 1 : 0) != 0, () -> new InvalidExecutionPlanCacheConfigException((Object)"maximumSize", (Object)executionPlanCache.getMaximumSize()));
    }

    public Class<AlterSQLFederationRuleStatement> getType() {
        return AlterSQLFederationRuleStatement.class;
    }

    public Class<SQLFederationRule> getRuleClass() {
        return SQLFederationRule.class;
    }

    @Generated
    public void setRule(SQLFederationRule rule) {
        this.rule = rule;
    }
}

