/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.factory.withoutfrom;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.MySQLSystemVariableQueryExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select.NoResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select.ShowConnectionIdExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select.ShowCurrentDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select.ShowCurrentUserExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select.ShowVersionExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select.UnicastResourceShowExecutor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class MySQLSelectWithoutFromAdminExecutorFactory {
    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatementContext selectStatementContext, String sql, String databaseName, ShardingSphereMetaData metaData) {
        SelectStatement selectStatement = selectStatementContext.getSqlStatement();
        Optional<DatabaseAdminExecutor> result = MySQLSystemVariableQueryExecutor.tryGetSystemVariableQueryExecutor(selectStatement);
        return result.isPresent() ? result : MySQLSelectWithoutFromAdminExecutorFactory.getSelectFunctionOrVariableExecutor(selectStatement, sql, databaseName, metaData);
    }

    private static Optional<DatabaseAdminExecutor> getSelectFunctionOrVariableExecutor(SelectStatement selectStatement, String sql, String databaseName, ShardingSphereMetaData metaData) {
        if (MySQLSelectWithoutFromAdminExecutorFactory.isShowSpecialFunction(selectStatement, "connection_id()")) {
            return Optional.of(new ShowConnectionIdExecutor(selectStatement));
        }
        if (MySQLSelectWithoutFromAdminExecutorFactory.isShowSpecialFunction(selectStatement, "version()")) {
            return Optional.of(new ShowVersionExecutor(selectStatement));
        }
        if (MySQLSelectWithoutFromAdminExecutorFactory.isShowSpecialFunction(selectStatement, "current_user()") || MySQLSelectWithoutFromAdminExecutorFactory.isShowSpecialFunction(selectStatement, "current_user")) {
            return Optional.of(new ShowCurrentUserExecutor());
        }
        if (MySQLSelectWithoutFromAdminExecutorFactory.isShowSpecialFunction(selectStatement, "DATABASE()")) {
            return Optional.of(new ShowCurrentDatabaseExecutor());
        }
        return MySQLSelectWithoutFromAdminExecutorFactory.mockExecutor(selectStatement, sql, databaseName, metaData);
    }

    private static boolean isShowSpecialFunction(SelectStatement sqlStatement, String functionName) {
        Iterator segmentIterator = sqlStatement.getProjections().getProjections().iterator();
        ProjectionSegment firstProjection = (ProjectionSegment)segmentIterator.next();
        if (segmentIterator.hasNext() || !(firstProjection instanceof ExpressionProjectionSegment)) {
            return false;
        }
        String projectionText = ((ExpressionProjectionSegment)firstProjection).getText();
        String trimmedText = projectionText.replaceAll("\\s+\\(", "(");
        return functionName.equalsIgnoreCase(trimmedText);
    }

    private static Optional<DatabaseAdminExecutor> mockExecutor(SelectStatement sqlStatement, String sql, String databaseName, ShardingSphereMetaData metaData) {
        boolean isUseDatabase;
        if (MySQLSelectWithoutFromAdminExecutorFactory.isEmptyResource(metaData)) {
            return Optional.of(new NoResourceShowExecutor(sqlStatement));
        }
        boolean bl = isUseDatabase = null != databaseName || sqlStatement.getFrom().isPresent();
        if (!isUseDatabase && MySQLSelectWithoutFromAdminExecutorFactory.hasMultipleProjections(sqlStatement)) {
            return Optional.empty();
        }
        return isUseDatabase ? Optional.empty() : Optional.of(new UnicastResourceShowExecutor(sqlStatement, sql));
    }

    private static boolean hasMultipleProjections(SelectStatement sqlStatement) {
        List projections = sqlStatement.getProjections().getProjections();
        return projections.size() > 1;
    }

    private static boolean isEmptyResource(ShardingSphereMetaData metaData) {
        Collection databases = metaData.getAllDatabases();
        return databases.isEmpty() || databases.stream().noneMatch(ShardingSphereDatabase::containsDataSource);
    }

    @Generated
    private MySQLSelectWithoutFromAdminExecutorFactory() {
    }
}

