/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.show;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowDatabasesStatement;

public final class MySQLShowDatabasesExecutor
implements DatabaseAdminQueryExecutor {
    private final MySQLShowDatabasesStatement sqlStatement;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        this.mergedResult = new LocalDataMergedResult(this.getDatabaseNames(connectionSession, metaData));
    }

    private Collection<LocalDataQueryResultRow> getDatabaseNames(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        AuthorityRule authorityRule = (AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, connectionSession.getConnectionContext().getGrantee());
        return metaData.getAllDatabases().stream().map(ShardingSphereDatabase::getName).sorted().filter(each -> this.checkLikePattern((String)each) && authorityChecker.isAuthorized(each)).map(xva$0 -> new LocalDataQueryResultRow(new Object[]{xva$0})).collect(Collectors.toList());
    }

    private boolean checkLikePattern(String databaseName) {
        if (this.sqlStatement.getFilter().isPresent()) {
            Optional<String> pattern = ((ShowFilterSegment)this.sqlStatement.getFilter().get()).getLike().map(optional -> RegexUtils.convertLikePatternToRegex((String)optional.getPattern()));
            return !pattern.isPresent() || databaseName.matches(pattern.get());
        }
        return true;
    }

    public QueryResultMetaData getQueryResultMetaData() {
        return new RawQueryResultMetaData(Collections.singletonList(new RawQueryResultColumnMetaData("SCHEMATA", "SCHEMA_NAME", "Database", 12, "VARCHAR", 255, 0)));
    }

    @Generated
    public MySQLShowDatabasesExecutor(MySQLShowDatabasesStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Generated
    public MySQLShowDatabasesStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

