/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.parser.core;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.distsql.parser.autogen.ReadwriteSplittingDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ReadwriteSplittingDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.statement.type.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.AlterReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.AlterReadwriteSplittingStorageUnitStatusStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.CreateReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.DropReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.ShowStatusFromReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.IdentifierValueUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ReadwriteSplittingDistSQLStatementVisitor
extends ReadwriteSplittingDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.CreateReadwriteSplittingRuleContext ctx) {
        return new CreateReadwriteSplittingRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.readwriteSplittingRuleDefinition().stream().map(each -> (ReadwriteSplittingRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.AlterReadwriteSplittingRuleContext ctx) {
        return new AlterReadwriteSplittingRuleStatement((Collection)ctx.readwriteSplittingRuleDefinition().stream().map(each -> (ReadwriteSplittingRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.DropReadwriteSplittingRuleContext ctx) {
        return new DropReadwriteSplittingRuleStatement(null != ctx.ifExists(), (Collection)ctx.ruleName().stream().map(IdentifierValueUtils::getValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterReadwriteSplittingStorageUnitStatus(ReadwriteSplittingDistSQLStatementParser.AlterReadwriteSplittingStorageUnitStatusContext ctx) {
        FromDatabaseSegment fromDatabase = null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
        return new AlterReadwriteSplittingStorageUnitStatusStatement(fromDatabase, IdentifierValueUtils.getValue((ParseTree)ctx.ruleName()), IdentifierValueUtils.getValue((ParseTree)ctx.storageUnitName()), null == ctx.DISABLE());
    }

    @Override
    public ASTNode visitShowReadwriteSplittingRules(ReadwriteSplittingDistSQLStatementParser.ShowReadwriteSplittingRulesContext ctx) {
        return new ShowReadwriteSplittingRulesStatement(null == ctx.ruleName() ? null : IdentifierValueUtils.getValue((ParseTree)ctx.ruleName()), null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())));
    }

    @Override
    public ASTNode visitReadwriteSplittingRuleDefinition(ReadwriteSplittingDistSQLStatementParser.ReadwriteSplittingRuleDefinitionContext ctx) {
        return new ReadwriteSplittingRuleSegment(IdentifierValueUtils.getValue((ParseTree)ctx.ruleName()), IdentifierValueUtils.getValue((ParseTree)ctx.dataSourceDefinition().writeStorageUnit().writeStorageUnitName()), (Collection)ctx.dataSourceDefinition().readStorageUnits().readStorageUnitsNames().storageUnitName().stream().map(IdentifierValueUtils::getValue).collect(Collectors.toList()), null == ctx.transactionalReadQueryStrategy() ? null : IdentifierValueUtils.getValue((ParseTree)ctx.transactionalReadQueryStrategy().transactionalReadQueryStrategyName()), null == ctx.algorithmDefinition() ? null : (AlgorithmSegment)this.visitAlgorithmDefinition(ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitDatabaseName(ReadwriteSplittingDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ReadwriteSplittingDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(IdentifierValueUtils.getValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    @Override
    public ASTNode visitShowStatusFromReadwriteSplittingRules(ReadwriteSplittingDistSQLStatementParser.ShowStatusFromReadwriteSplittingRulesContext ctx) {
        FromDatabaseSegment fromDatabase = null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().get(1).getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
        String ruleName = IdentifierValueUtils.getValue((ParseTree)ctx.ruleName());
        return new ShowStatusFromReadwriteSplittingRulesStatement(fromDatabase, ruleName);
    }

    @Override
    public ASTNode visitCountReadwriteSplittingRule(ReadwriteSplittingDistSQLStatementParser.CountReadwriteSplittingRuleContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())), "READWRITE_SPLITTING");
    }

    private Properties getProperties(ReadwriteSplittingDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (ReadwriteSplittingDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }
}

