/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.sharding;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.data.pipeline.core.importer.PipelineRequiredColumnsExtractor;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.YamlShardingRuleConfigurationSwapper;

public final class PipelineShardingColumnsExtractor
implements PipelineRequiredColumnsExtractor<YamlShardingRuleConfiguration> {
    public Map<ShardingSphereIdentifier, Collection<String>> getTableAndRequiredColumnsMap(YamlShardingRuleConfiguration yamlRuleConfig, Collection<ShardingSphereIdentifier> logicTableNames) {
        ShardingSphereIdentifier logicTableName;
        ShardingRuleConfiguration ruleConfig = new YamlShardingRuleConfigurationSwapper().swapToObject(yamlRuleConfig);
        Set<String> defaultDatabaseShardingColumns = this.extractShardingColumns(ruleConfig.getDefaultDatabaseShardingStrategy());
        Set<String> defaultTableShardingColumns = this.extractShardingColumns(ruleConfig.getDefaultTableShardingStrategy());
        ConcurrentHashMap<ShardingSphereIdentifier, Collection<String>> result = new ConcurrentHashMap<ShardingSphereIdentifier, Collection<String>>(ruleConfig.getTables().size(), 1.0f);
        for (ShardingTableRuleConfiguration each : ruleConfig.getTables()) {
            logicTableName = new ShardingSphereIdentifier(each.getLogicTable());
            if (!logicTableNames.contains(logicTableName)) continue;
            HashSet<String> shardingColumns = new HashSet<String>();
            shardingColumns.addAll(null == each.getDatabaseShardingStrategy() ? defaultDatabaseShardingColumns : this.extractShardingColumns(each.getDatabaseShardingStrategy()));
            shardingColumns.addAll(null == each.getTableShardingStrategy() ? defaultTableShardingColumns : this.extractShardingColumns(each.getTableShardingStrategy()));
            result.put(logicTableName, shardingColumns);
        }
        for (ShardingTableRuleConfiguration each : ruleConfig.getAutoTables()) {
            logicTableName = new ShardingSphereIdentifier(each.getLogicTable());
            if (!logicTableNames.contains(logicTableName)) continue;
            result.put(logicTableName, this.extractShardingColumns(each.getShardingStrategy()));
        }
        return result;
    }

    private Set<String> extractShardingColumns(ShardingStrategyConfiguration shardingStrategy) {
        if (shardingStrategy instanceof StandardShardingStrategyConfiguration) {
            return Collections.singleton(((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn());
        }
        if (shardingStrategy instanceof ComplexShardingStrategyConfiguration) {
            return new HashSet<String>(Arrays.asList(((ComplexShardingStrategyConfiguration)shardingStrategy).getShardingColumns().split(",")));
        }
        return Collections.emptySet();
    }

    public int getOrder() {
        return 0;
    }

    public Class<YamlShardingRuleConfiguration> getTypeClass() {
        return YamlShardingRuleConfiguration.class;
    }
}

