/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.projection;

import java.util.List;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptSelectProjectionSupportedChecker
implements SupportedSQLChecker<SelectStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !sqlStatementContext.getTablesContext().getSimpleTables().isEmpty();
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SelectStatementContext sqlStatementContext) {
        this.checkSelectStatementContext(rule, sqlStatementContext);
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            this.checkSelectStatementContext(rule, each);
        }
    }

    private void checkSelectStatementContext(EncryptRule rule, SelectStatementContext selectStatementContext) {
        this.checkNotContainEncryptProjectionInCombineSegment(rule, selectStatementContext);
        for (ProjectionSegment each : selectStatementContext.getSqlStatement().getProjections().getProjections()) {
            this.checkNotContainEncryptShorthandExpandWithSubqueryStatement(selectStatementContext, each);
        }
    }

    private void checkNotContainEncryptProjectionInCombineSegment(EncryptRule rule, SelectStatementContext selectStatementContext) {
        ShardingSpherePreconditions.checkState((!this.containsEncryptProjectionInCombineSegment(rule, selectStatementContext) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Can not support encrypt projection in combine statement."));
    }

    private boolean containsEncryptProjectionInCombineSegment(EncryptRule rule, SelectStatementContext selectStatementContext) {
        if (!selectStatementContext.getSqlStatement().getCombine().isPresent()) {
            return false;
        }
        CombineSegment combineSegment = (CombineSegment)selectStatementContext.getSqlStatement().getCombine().get();
        List leftProjections = ((SelectStatementContext)selectStatementContext.getSubqueryContexts().get(combineSegment.getLeft().getStartIndex())).getProjectionsContext().getExpandProjections();
        List rightProjections = ((SelectStatementContext)selectStatementContext.getSubqueryContexts().get(combineSegment.getRight().getStartIndex())).getProjectionsContext().getExpandProjections();
        ShardingSpherePreconditions.checkState((leftProjections.size() == rightProjections.size() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Column projections must be same for combine statement"));
        for (int i = 0; i < leftProjections.size(); ++i) {
            if (!this.containsEncryptProjectionInCombineSegment(rule, (Projection)leftProjections.get(i), (Projection)rightProjections.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean containsEncryptProjectionInCombineSegment(EncryptRule rule, Projection leftProjection, Projection rightProjection) {
        ColumnSegmentBoundInfo leftColumnInfo = this.getColumnSegmentBoundInfo(leftProjection);
        EncryptAlgorithm leftColumnEncryptor = rule.findQueryEncryptor(leftColumnInfo.getOriginalTable().getValue(), leftColumnInfo.getOriginalColumn().getValue()).orElse(null);
        ColumnSegmentBoundInfo rightColumnInfo = this.getColumnSegmentBoundInfo(rightProjection);
        EncryptAlgorithm rightColumnEncryptor = rule.findQueryEncryptor(rightColumnInfo.getOriginalTable().getValue(), rightColumnInfo.getOriginalColumn().getValue()).orElse(null);
        return null != leftColumnEncryptor || null != rightColumnEncryptor;
    }

    private ColumnSegmentBoundInfo getColumnSegmentBoundInfo(Projection projection) {
        return projection instanceof ColumnProjection ? new ColumnSegmentBoundInfo(null, ((ColumnProjection)projection).getOriginalTable(), ((ColumnProjection)projection).getOriginalColumn(), ((ColumnProjection)projection).getColumnBoundInfo().getTableSourceType()) : new ColumnSegmentBoundInfo(new IdentifierValue(projection.getColumnLabel()));
    }

    private void checkNotContainEncryptShorthandExpandWithSubqueryStatement(SelectStatementContext selectStatementContext, ProjectionSegment projectionSegment) {
        ShardingSpherePreconditions.checkState((!(projectionSegment instanceof ShorthandProjectionSegment) || !selectStatementContext.containsTableSubquery() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Can not support encrypt shorthand expand with subquery statement."));
    }
}

