/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.cryptographic;

import java.util.Collection;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.EncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class InsertSelectColumnsEncryptorChecker {
    public static void checkIsSame(Collection<ColumnSegment> insertColumns, Collection<Projection> projections, EncryptRule encryptRule) {
        Iterator<ColumnSegment> insertColumnsIterator = insertColumns.iterator();
        Iterator<Projection> projectionIterator = projections.iterator();
        while (insertColumnsIterator.hasNext()) {
            ColumnSegment insertColumnSegment = insertColumnsIterator.next();
            Projection projection = projectionIterator.next();
            if (InsertSelectColumnsEncryptorChecker.isLiteralOrParameterMarker(projection)) continue;
            ColumnSegmentBoundInfo projectionColumnBoundInfo = InsertSelectColumnsEncryptorChecker.getColumnSegmentBoundInfo(projection);
            EncryptAlgorithm insertColumnEncryptor = encryptRule.findQueryEncryptor(insertColumnSegment.getColumnBoundInfo().getOriginalTable().getValue(), insertColumnSegment.getColumnBoundInfo().getOriginalColumn().getValue()).orElse(null);
            EncryptAlgorithm projectionEncryptor = encryptRule.findQueryEncryptor(projectionColumnBoundInfo.getOriginalTable().getValue(), projectionColumnBoundInfo.getOriginalColumn().getValue()).orElse(null);
            ShardingSpherePreconditions.checkState((boolean)EncryptorComparator.isSame(insertColumnEncryptor, projectionEncryptor), () -> new UnsupportedSQLOperationException("Can not use different encryptor for " + insertColumnSegment.getColumnBoundInfo() + " and " + projectionColumnBoundInfo + " in insert select columns"));
        }
    }

    public static boolean isSame(Collection<ColumnSegment> insertColumns, Collection<Projection> projections, EncryptRule encryptRule) {
        Iterator<ColumnSegment> insertColumnsIterator = insertColumns.iterator();
        Iterator<Projection> projectionIterator = projections.iterator();
        while (insertColumnsIterator.hasNext()) {
            EncryptAlgorithm projectionEncryptor;
            ColumnSegment insertColumnSegment = insertColumnsIterator.next();
            Projection projection = projectionIterator.next();
            if (InsertSelectColumnsEncryptorChecker.isLiteralOrParameterMarker(projection)) continue;
            ColumnSegmentBoundInfo projectionColumnBoundInfo = InsertSelectColumnsEncryptorChecker.getColumnSegmentBoundInfo(projection);
            EncryptAlgorithm insertColumnEncryptor = encryptRule.findQueryEncryptor(insertColumnSegment.getColumnBoundInfo().getOriginalTable().getValue(), insertColumnSegment.getColumnBoundInfo().getOriginalColumn().getValue()).orElse(null);
            if (EncryptorComparator.isSame(insertColumnEncryptor, projectionEncryptor = (EncryptAlgorithm)encryptRule.findQueryEncryptor(projectionColumnBoundInfo.getOriginalTable().getValue(), projectionColumnBoundInfo.getOriginalColumn().getValue()).orElse(null))) continue;
            return false;
        }
        return true;
    }

    private static boolean isLiteralOrParameterMarker(Projection projection) {
        if (projection instanceof ExpressionProjection) {
            ExpressionSegment expressionSegment = ((ExpressionProjection)projection).getExpressionSegment().getExpr();
            return expressionSegment instanceof LiteralExpressionSegment;
        }
        return projection instanceof ParameterMarkerProjection;
    }

    private static ColumnSegmentBoundInfo getColumnSegmentBoundInfo(Projection projection) {
        if (projection instanceof ColumnProjection) {
            return ((ColumnProjection)projection).getColumnBoundInfo();
        }
        if (projection instanceof SubqueryProjection) {
            return InsertSelectColumnsEncryptorChecker.getColumnSegmentBoundInfo(((SubqueryProjection)projection).getProjection());
        }
        return new ColumnSegmentBoundInfo(new IdentifierValue(projection.getColumnLabel()));
    }

    @Generated
    private InsertSelectColumnsEncryptorChecker() {
    }
}

