/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.service.TransmissionJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.pojo.TransmissionJobItemInfo;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationStatusStatement;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowMigrationJobStatusExecutor
implements DistSQLQueryExecutor<ShowMigrationStatusStatement> {
    public Collection<String> getColumnNames(ShowMigrationStatusStatement sqlStatement) {
        return Arrays.asList("item", "data_source", "tables", "status", "active", "processed_records_count", "inventory_finished_percentage", "incremental_idle_seconds", "error_message");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowMigrationStatusStatement sqlStatement, ContextManager contextManager) {
        Collection jobItemInfos = new TransmissionJobManager((PipelineJobType)new MigrationJobType()).getJobItemInfos(sqlStatement.getJobId());
        long currentTimeMillis = System.currentTimeMillis();
        return jobItemInfos.stream().map(each -> this.getRow((TransmissionJobItemInfo)each, currentTimeMillis)).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow getRow(TransmissionJobItemInfo jobItemInfo, long currentTimeMillis) {
        TransmissionJobItemProgress jobItemProgress = jobItemInfo.getJobItemProgress();
        if (null == jobItemProgress) {
            return new LocalDataQueryResultRow(new Object[]{jobItemInfo.getShardingItem(), "", "", "", "", "", "", "", jobItemInfo.getErrorMessage()});
        }
        return new LocalDataQueryResultRow(new Object[]{jobItemInfo.getShardingItem(), jobItemProgress.getDataSourceName(), jobItemInfo.getTableNames(), jobItemProgress.getStatus(), jobItemProgress.isActive(), jobItemProgress.getProcessedRecordsCount(), jobItemInfo.getInventoryFinishedPercentage(), this.getIncrementalIdleSeconds(jobItemProgress, jobItemInfo, currentTimeMillis), jobItemInfo.getErrorMessage()});
    }

    private Optional<Long> getIncrementalIdleSeconds(TransmissionJobItemProgress jobItemProgress, TransmissionJobItemInfo jobItemInfo, long currentTimeMillis) {
        if (!jobItemProgress.isActive()) {
            return Optional.empty();
        }
        if (jobItemProgress.getIncremental().getIncrementalLatestActiveTimeMillis() > 0L) {
            long latestActiveTimeMillis = Math.max(jobItemInfo.getStartTimeMillis(), jobItemProgress.getIncremental().getIncrementalLatestActiveTimeMillis());
            return Optional.of(TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis - latestActiveTimeMillis));
        }
        return Optional.empty();
    }

    public Class<ShowMigrationStatusStatement> getType() {
        return ShowMigrationStatusStatement.class;
    }
}

