/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.api.CDCJobAPI;
import org.apache.shardingsphere.data.pipeline.cdc.config.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.CDCTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.context.CDCJobItemContext;
import org.apache.shardingsphere.data.pipeline.cdc.core.importer.sink.PipelineCDCSocketSink;
import org.apache.shardingsphere.data.pipeline.cdc.core.prepare.CDCJobPreparer;
import org.apache.shardingsphere.data.pipeline.cdc.core.task.CDCTasksRunner;
import org.apache.shardingsphere.data.pipeline.cdc.engine.CDCJobRunnerCleaner;
import org.apache.shardingsphere.data.pipeline.cdc.generator.CDCResponseUtils;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLineConvertUtils;
import org.apache.shardingsphere.data.pipeline.core.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.importer.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.core.importer.PipelineRequiredColumnsExtractor;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.DumperCommonContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.job.engine.PipelineJobRunnerManager;
import org.apache.shardingsphere.data.pipeline.core.job.engine.cleaner.PipelineJobRunnerCleaner;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineWriteConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineProcessConfigurationPersistService;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCJob
implements PipelineJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCJob.class);
    private final PipelineJobRunnerManager jobRunnerManager;
    private final CDCJobAPI jobAPI = (CDCJobAPI)TypedSPILoader.getService(TransmissionJobAPI.class, (Object)"STREAMING");
    private final PipelineSink sink;

    public CDCJob(PipelineSink sink) {
        this.jobRunnerManager = new PipelineJobRunnerManager((PipelineJobRunnerCleaner)new CDCJobRunnerCleaner(sink));
        this.sink = sink;
    }

    public void execute(ShardingContext shardingContext) {
        String jobId = shardingContext.getJobName();
        log.info("Execute job {}", (Object)jobId);
        PipelineJobType jobType = PipelineJobIdUtils.parseJobType((String)jobId);
        PipelineContextKey contextKey = PipelineJobIdUtils.parseContextKey((String)jobId);
        CDCJobConfiguration jobConfig = (CDCJobConfiguration)jobType.getOption().getYamlJobConfigurationSwapper().swapToObject(shardingContext.getJobParameter());
        PipelineJobItemManager jobItemManager = new PipelineJobItemManager(jobType.getOption().getYamlJobItemProgressSwapper());
        TransmissionProcessContext jobProcessContext = new TransmissionProcessContext(jobId, PipelineProcessConfigurationUtils.fillInDefaultValue((PipelineProcessConfiguration)new PipelineProcessConfigurationPersistService().load(contextKey, jobType.getType())));
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)contextKey);
        LinkedList<CDCJobItemContext> jobItemContexts = new LinkedList<CDCJobItemContext>();
        for (int shardingItem = 0; shardingItem < jobConfig.getJobShardingCount(); ++shardingItem) {
            CDCTaskConfiguration taskConfig;
            if (this.jobRunnerManager.isStopping()) {
                log.info("Execute, job is stopping, ignore.");
                return;
            }
            TransmissionJobItemProgress jobItemProgress = jobItemManager.getProgress(shardingContext.getJobName(), shardingItem).orElse(null);
            CDCJobItemContext jobItemContext = new CDCJobItemContext(jobConfig, shardingItem, jobItemProgress, jobProcessContext, taskConfig = this.buildTaskConfiguration(jobConfig, shardingItem, jobProcessContext.getProcessConfiguration()), this.getJobRunnerManager().getDataSourceManager(), this.sink);
            if (!this.jobRunnerManager.addTasksRunner(shardingItem, (PipelineTasksRunner)new CDCTasksRunner(jobItemContext))) continue;
            jobItemContexts.add(jobItemContext);
            governanceFacade.getJobItemFacade().getErrorMessage().clean(jobId, shardingItem);
            log.info("Start tasks runner, jobId={}, shardingItem={}.", (Object)jobId, (Object)shardingItem);
        }
        if (jobItemContexts.isEmpty()) {
            log.warn("Job item contexts are empty, ignore.");
            return;
        }
        this.initTasks(jobItemContexts, governanceFacade, (PipelineJobItemManager<TransmissionJobItemProgress>)jobItemManager);
        this.executeInventoryTasks(jobItemContexts, (PipelineJobItemManager<TransmissionJobItemProgress>)jobItemManager);
        this.executeIncrementalTasks(jobItemContexts, (PipelineJobItemManager<TransmissionJobItemProgress>)jobItemManager);
    }

    private CDCTaskConfiguration buildTaskConfiguration(CDCJobConfiguration jobConfig, int jobShardingItem, PipelineProcessConfiguration processConfig) {
        TableAndSchemaNameMapper mapper = new TableAndSchemaNameMapper(jobConfig.getSchemaTableNames());
        IncrementalDumperContext dumperContext = this.buildDumperContext(jobConfig, jobShardingItem, mapper);
        ImporterConfiguration importerConfig = this.buildImporterConfiguration(jobConfig, processConfig, mapper);
        return new CDCTaskConfiguration(dumperContext, importerConfig);
    }

    private IncrementalDumperContext buildDumperContext(CDCJobConfiguration jobConfig, int jobShardingItem, TableAndSchemaNameMapper mapper) {
        JobDataNodeLine dataNodeLine = jobConfig.getJobShardingDataNodes().get(jobShardingItem);
        String dataSourceName = ((DataNode)((JobDataNodeEntry)dataNodeLine.getEntries().iterator().next()).getDataNodes().iterator().next()).getDataSourceName();
        StandardPipelineDataSourceConfiguration actualDataSourceConfig = jobConfig.getDataSourceConfig().getActualDataSourceConfiguration(dataSourceName);
        DumperCommonContext dumperCommonContext = new DumperCommonContext(dataSourceName, (PipelineDataSourceConfiguration)actualDataSourceConfig, JobDataNodeLineConvertUtils.buildTableNameMapper((JobDataNodeLine)dataNodeLine), mapper);
        return new IncrementalDumperContext(dumperCommonContext, jobConfig.getJobId(), jobConfig.isDecodeWithTX());
    }

    private ImporterConfiguration buildImporterConfiguration(CDCJobConfiguration jobConfig, PipelineProcessConfiguration pipelineProcessConfig, TableAndSchemaNameMapper mapper) {
        PipelineDataSourceConfiguration dataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getDataSourceConfig().getType(), (String)jobConfig.getDataSourceConfig().getParameter());
        Map<ShardingSphereIdentifier, Collection<String>> tableAndRequiredColumnsMap = this.getTableAndRequiredColumnsMap(jobConfig);
        PipelineWriteConfiguration write = pipelineProcessConfig.getWrite();
        JobRateLimitAlgorithm writeRateLimitAlgorithm = null == write.getRateLimiter() ? null : (JobRateLimitAlgorithm)TypedSPILoader.getService(JobRateLimitAlgorithm.class, (Object)write.getRateLimiter().getType(), (Properties)write.getRateLimiter().getProps());
        return new ImporterConfiguration(dataSourceConfig, tableAndRequiredColumnsMap, mapper, write.getBatchSize().intValue(), writeRateLimitAlgorithm, 0, 1);
    }

    private Map<ShardingSphereIdentifier, Collection<String>> getTableAndRequiredColumnsMap(CDCJobConfiguration jobConfig) {
        HashMap<ShardingSphereIdentifier, Collection<String>> result = new HashMap<ShardingSphereIdentifier, Collection<String>>();
        Collection yamlRuleConfigs = jobConfig.getDataSourceConfig().getRootConfig().getRules();
        Collection targetTableNames = jobConfig.getSchemaTableNames().stream().map(ShardingSphereIdentifier::new).collect(Collectors.toSet());
        for (Map.Entry entry : OrderedSPILoader.getServices(PipelineRequiredColumnsExtractor.class, (Collection)yamlRuleConfigs).entrySet()) {
            result.putAll(((PipelineRequiredColumnsExtractor)entry.getValue()).getTableAndRequiredColumnsMap((YamlRuleConfiguration)entry.getKey(), targetTableNames));
        }
        return result;
    }

    private void initTasks(Collection<CDCJobItemContext> jobItemContexts, PipelineGovernanceFacade governanceFacade, PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager) {
        try {
            new CDCJobPreparer(jobItemManager).initTasks(jobItemContexts);
        }
        catch (RuntimeException ex) {
            for (PipelineJobItemContext pipelineJobItemContext : jobItemContexts) {
                this.initTasksFailed(pipelineJobItemContext.getJobId(), pipelineJobItemContext.getShardingItem(), ex, governanceFacade);
            }
            throw ex;
        }
    }

    private void initTasksFailed(String jobId, int shardingItem, Exception ex, PipelineGovernanceFacade governanceFacade) {
        log.error("Job {}-{} execution failed.", new Object[]{jobId, shardingItem, ex});
        governanceFacade.getJobItemFacade().getErrorMessage().update(jobId, shardingItem, (Throwable)ex);
        PipelineJobRegistry.stop((String)jobId);
        this.jobAPI.disable(jobId);
    }

    private void executeInventoryTasks(Collection<CDCJobItemContext> jobItemContexts, PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager) {
        LinkedList futures = new LinkedList();
        for (CDCJobItemContext each : jobItemContexts) {
            this.updateJobItemStatus(each, JobStatus.EXECUTE_INVENTORY_TASK, jobItemManager);
            for (PipelineTask task : each.getInventoryTasks()) {
                if (task.getTaskProgress().getPosition() instanceof IngestFinishedPosition) continue;
                futures.addAll(task.start());
            }
        }
        if (futures.isEmpty()) {
            return;
        }
        PipelineExecuteEngine.trigger(futures, (ExecuteCallback)new CDCExecuteCallback("inventory", jobItemContexts.iterator().next()));
    }

    private void executeIncrementalTasks(Collection<CDCJobItemContext> jobItemContexts, PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager) {
        LinkedList futures = new LinkedList();
        for (CDCJobItemContext each : jobItemContexts) {
            this.updateJobItemStatus(each, JobStatus.EXECUTE_INCREMENTAL_TASK, jobItemManager);
            for (PipelineTask task : each.getIncrementalTasks()) {
                if (task.getTaskProgress().getPosition() instanceof IngestFinishedPosition) continue;
                futures.addAll(task.start());
            }
        }
        PipelineExecuteEngine.trigger(futures, (ExecuteCallback)new CDCExecuteCallback("incremental", jobItemContexts.iterator().next()));
    }

    private void updateJobItemStatus(CDCJobItemContext jobItemContext, JobStatus jobStatus, PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager) {
        jobItemContext.setStatus(jobStatus);
        jobItemManager.updateStatus(jobItemContext.getJobId(), jobItemContext.getShardingItem(), jobStatus);
    }

    @Generated
    public PipelineJobRunnerManager getJobRunnerManager() {
        return this.jobRunnerManager;
    }

    @Generated
    public PipelineSink getSink() {
        return this.sink;
    }

    private class CDCExecuteCallback
    implements ExecuteCallback {
        private final String identifier;
        private final CDCJobItemContext jobItemContext;

        public void onSuccess() {
            if (this.jobItemContext.isStopping()) {
                log.info("onSuccess, job is stopping, ignore.");
                return;
            }
            log.info("All {} tasks finished successful.", (Object)this.identifier);
        }

        public void onFailure(Throwable throwable) {
            log.error("Task {} execute failed.", (Object)this.identifier, (Object)throwable);
            String jobId = this.jobItemContext.getJobId();
            PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getJobItemFacade().getErrorMessage().update(jobId, this.jobItemContext.getShardingItem(), throwable);
            if (this.jobItemContext.getSink() instanceof PipelineCDCSocketSink) {
                PipelineCDCSocketSink cdcSink = (PipelineCDCSocketSink)this.jobItemContext.getSink();
                cdcSink.getChannel().writeAndFlush((Object)CDCResponseUtils.failed("", "", Optional.ofNullable(throwable.getMessage()).orElse("")));
            }
            PipelineJobRegistry.stop((String)jobId);
            CDCJob.this.jobAPI.disable(jobId);
        }

        @Generated
        public CDCExecuteCallback(String identifier, CDCJobItemContext jobItemContext) {
            this.identifier = identifier;
            this.jobItemContext = jobItemContext;
        }
    }
}

