/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.generic;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.database.exception.postgresql.vendor.PostgreSQLVendorError;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLErrorResponsePacket
extends PostgreSQLIdentifierPacket {
    public static final char FIELD_TYPE_SEVERITY = 'S';
    public static final char FIELD_TYPE_SEVERITY_NON_LOCALIZED = 'V';
    public static final char FIELD_TYPE_CODE = 'C';
    public static final char FIELD_TYPE_MESSAGE = 'M';
    public static final char FIELD_TYPE_DETAIL = 'D';
    public static final char FIELD_TYPE_HINT = 'H';
    public static final char FIELD_TYPE_POSITION = 'P';
    public static final char FIELD_TYPE_INTERNAL_POSITION = 'p';
    public static final char FIELD_TYPE_INTERNAL_QUERY = 'q';
    public static final char FIELD_TYPE_WHERE = 'W';
    public static final char FIELD_TYPE_SCHEMA_NAME = 's';
    public static final char FIELD_TYPE_TABLE_NAME = 't';
    public static final char FIELD_TYPE_COLUMN_NAME = 'c';
    public static final char FIELD_TYPE_DATA_TYPE_NAME = 'd';
    public static final char FIELD_TYPE_CONSTRAINT_NAME = 'n';
    public static final char FIELD_TYPE_FILE = 'F';
    public static final char FIELD_TYPE_LINE = 'L';
    public static final char FIELD_TYPE_ROUTINE = 'R';
    private final Map<Character, String> fields = new LinkedHashMap<Character, String>(16, 1.0f);

    private PostgreSQLErrorResponsePacket(Map<Character, String> fields) {
        this.fields.putAll(fields);
    }

    public String toServerErrorMessage() {
        return this.fields.entrySet().stream().map(entry -> entry.getKey() + (String)entry.getValue()).collect(Collectors.joining("\u0000"));
    }

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
        for (Map.Entry<Character, String> entry : this.fields.entrySet()) {
            payload.writeInt1(entry.getKey().charValue());
            payload.writeStringNul(entry.getValue());
        }
        payload.writeInt1(0);
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.ERROR_RESPONSE;
    }

    public static Builder newBuilder(String severity, PostgreSQLVendorError vendorError, String message) {
        return PostgreSQLErrorResponsePacket.newBuilder(severity, vendorError.getSqlState().getValue(), message);
    }

    public static Builder newBuilder(String severity, String sqlState, String message) {
        return new Builder(severity, sqlState, message);
    }

    public static final class Builder {
        private final Map<Character, String> fields = new LinkedHashMap<Character, String>(16, 1.0f);

        private Builder(String severity, String sqlState, String message) {
            Preconditions.checkArgument((null != severity ? 1 : 0) != 0, (Object)"The severity is always present!");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sqlState) ? 1 : 0) != 0, (Object)"The SQLSTATE code is always present!");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)message) ? 1 : 0) != 0, (Object)"The message is always present!");
            this.fields.put(Character.valueOf('S'), severity);
            this.fields.put(Character.valueOf('V'), severity);
            this.fields.put(Character.valueOf('C'), sqlState);
            this.fields.put(Character.valueOf('M'), message);
        }

        public Builder detail(String detail) {
            if (!Strings.isNullOrEmpty((String)detail)) {
                this.fields.put(Character.valueOf('D'), detail);
            }
            return this;
        }

        public Builder hint(String hint) {
            if (!Strings.isNullOrEmpty((String)hint)) {
                this.fields.put(Character.valueOf('H'), hint);
            }
            return this;
        }

        public Builder position(int position) {
            if (position > 0) {
                this.fields.put(Character.valueOf('P'), Integer.toString(position));
            }
            return this;
        }

        public Builder internalQueryAndInternalPosition(String internalQuery, int internalPosition) {
            if (internalPosition > 0) {
                this.fields.put(Character.valueOf('p'), Integer.toString(internalPosition));
            }
            return this.internalQuery(internalQuery);
        }

        public Builder internalQuery(String internalQuery) {
            if (!Strings.isNullOrEmpty((String)internalQuery)) {
                this.fields.put(Character.valueOf('q'), internalQuery);
            }
            return this;
        }

        public Builder where(String where) {
            if (!Strings.isNullOrEmpty((String)where)) {
                this.fields.put(Character.valueOf('W'), where);
            }
            return this;
        }

        public Builder schemaName(String schemaName) {
            if (!Strings.isNullOrEmpty((String)schemaName)) {
                this.fields.put(Character.valueOf('s'), schemaName);
            }
            return this;
        }

        public Builder tableName(String tableName) {
            if (!Strings.isNullOrEmpty((String)tableName)) {
                this.fields.put(Character.valueOf('t'), tableName);
            }
            return this;
        }

        public Builder columnName(String columnName) {
            if (!Strings.isNullOrEmpty((String)columnName)) {
                this.fields.put(Character.valueOf('c'), columnName);
            }
            return this;
        }

        public Builder dataTypeName(String dataTypeName) {
            if (!Strings.isNullOrEmpty((String)dataTypeName)) {
                this.fields.put(Character.valueOf('d'), dataTypeName);
            }
            return this;
        }

        public Builder constraintName(String constraintName) {
            if (!Strings.isNullOrEmpty((String)constraintName)) {
                this.fields.put(Character.valueOf('n'), constraintName);
            }
            return this;
        }

        public Builder file(String file) {
            if (!Strings.isNullOrEmpty((String)file)) {
                this.fields.put(Character.valueOf('F'), file);
            }
            return this;
        }

        public Builder line(int line) {
            if (line > 0) {
                this.fields.put(Character.valueOf('L'), Integer.toString(line));
            }
            return this;
        }

        public Builder routine(String routine) {
            if (!Strings.isNullOrEmpty((String)routine)) {
                this.fields.put(Character.valueOf('R'), routine);
            }
            return this;
        }

        public PostgreSQLErrorResponsePacket build() {
            return new PostgreSQLErrorResponsePacket(this.fields);
        }
    }
}

