/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLRowDescriptionPacket
extends PostgreSQLIdentifierPacket {
    private final Collection<PostgreSQLColumnDescription> columnDescriptions;

    @Override
    protected void write(PostgreSQLPacketPayload payload) {
        payload.writeInt2(this.columnDescriptions.size());
        for (PostgreSQLColumnDescription each : this.columnDescriptions) {
            payload.writeStringNul(each.getColumnName());
            payload.writeInt4(each.getTableOID());
            payload.writeInt2(each.getColumnIndex());
            payload.writeInt4(each.getTypeOID());
            payload.writeInt2(each.getColumnLength());
            payload.writeInt4(each.getTypeModifier());
            payload.writeInt2(each.getDataFormat());
        }
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.ROW_DESCRIPTION;
    }

    @Generated
    public PostgreSQLRowDescriptionPacket(Collection<PostgreSQLColumnDescription> columnDescriptions) {
        this.columnDescriptions = columnDescriptions;
    }
}

