/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.impl;

import com.google.common.base.Strings;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.mysql.packet.handshake.MySQLAuthenticationPluginData;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.frontend.mysql.authentication.authenticator.MySQLAuthenticator;

public final class MySQLCachingSha2PasswordAuthenticator
implements MySQLAuthenticator {
    public boolean authenticate(ShardingSphereUser user, Object[] authInfo) {
        byte[] authResponse = (byte[])authInfo[0];
        MySQLAuthenticationPluginData authPluginData = (MySQLAuthenticationPluginData)authInfo[1];
        return Strings.isNullOrEmpty((String)user.getPassword()) || Arrays.equals(this.scramble256(user.getPassword().getBytes(), authPluginData.getAuthenticationPluginData()), authResponse);
    }

    private byte[] scramble256(byte[] pass, byte[] authenticationPluginData) {
        int cachingSha2DigestLength = 32;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] dig1 = new byte[cachingSha2DigestLength];
        byte[] dig2 = new byte[cachingSha2DigestLength];
        messageDigest.update(pass, 0, pass.length);
        messageDigest.digest(dig1, 0, cachingSha2DigestLength);
        messageDigest.reset();
        messageDigest.update(dig1, 0, dig1.length);
        messageDigest.digest(dig2, 0, cachingSha2DigestLength);
        messageDigest.reset();
        messageDigest.update(dig2, 0, dig1.length);
        messageDigest.update(authenticationPluginData, 0, authenticationPluginData.length);
        byte[] scramble1 = new byte[cachingSha2DigestLength];
        messageDigest.digest(scramble1, 0, cachingSha2DigestLength);
        byte[] result = new byte[cachingSha2DigestLength];
        this.xorString(dig1, result, scramble1, cachingSha2DigestLength);
        return result;
    }

    private void xorString(byte[] from, byte[] to, byte[] scramble, int length) {
        int scrambleLength = scramble.length;
        for (int pos = 0; pos < length; ++pos) {
            to[pos] = (byte)(from[pos] ^ scramble[pos % scrambleLength]);
        }
    }

    public String getAuthenticationMethodName() {
        return MySQLAuthenticationMethod.CACHING_SHA2_PASSWORD.getMethodName();
    }
}

