/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.QuantifySubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.operator.common.SQLExtensionOperatorTable;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;

public final class BinaryOperationExpressionConverter {
    private static final Map<String, SqlOperator> REGISTRY = new CaseInsensitiveMap();

    private static void register() {
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.EQUALS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.GREATER_THAN);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LESS_THAN);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.OR);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.AND);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.PLUS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MINUS);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MULTIPLY);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.DIVIDE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.LIKE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.NOT_LIKE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.PERCENT_REMAINDER);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.IS_NULL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.ALL_GT);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.IS_FALSE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.IS_TRUE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.CONCAT);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.PATTERN_ALTER);
        BinaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.MOD);
        SqlStdOperatorTable.QUANTIFY_OPERATORS.forEach(BinaryOperationExpressionConverter::register);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.DIV);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.CARET);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.AMPERSAND);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.SIGNED_RIGHT_SHIFT);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.SIGNED_LEFT_SHIFT);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.XOR);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.LOGICAL_AND);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.REGEXP);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.NOT_REGEXP);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.SOUNDS_LIKE);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.NULL_SAFE);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.ASSIGNMENT);
        BinaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.RLIKE);
    }

    private static void register(SqlOperator sqlOperator) {
        REGISTRY.put(sqlOperator.getName(), sqlOperator);
    }

    private static void registerAlias() {
        REGISTRY.put("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        REGISTRY.put("~", (SqlOperator)SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE);
        REGISTRY.put("~*", (SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE);
        REGISTRY.put("!~", (SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE);
        REGISTRY.put("!~*", (SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE);
    }

    public static SqlBasicCall convert(BinaryOperationExpression segment) {
        SqlOperator operator = BinaryOperationExpressionConverter.convertOperator(segment);
        List<SqlNode> sqlNodes = BinaryOperationExpressionConverter.convertSqlNodes(segment, operator);
        return new SqlBasicCall(operator, sqlNodes, SqlParserPos.ZERO);
    }

    private static SqlOperator convertOperator(BinaryOperationExpression segment) {
        String operator = BinaryOperationExpressionConverter.getOperator(segment);
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    private static String getOperator(BinaryOperationExpression segment) {
        String result = null;
        if ("IS".equalsIgnoreCase(segment.getOperator())) {
            result = BinaryOperationExpressionConverter.findIsOperator(segment).orElse(null);
        }
        if (segment.getRight() instanceof QuantifySubqueryExpression) {
            result = BinaryOperationExpressionConverter.findQuantifyOperator(segment.getOperator(), (QuantifySubqueryExpression)segment.getRight()).orElse(null);
        }
        return null == result ? segment.getOperator() : result;
    }

    private static Optional<String> findIsOperator(BinaryOperationExpression segment) {
        String literals = String.valueOf(((LiteralExpressionSegment)segment.getRight()).getLiterals());
        if ("NULL".equalsIgnoreCase(literals)) {
            return Optional.of(SqlStdOperatorTable.IS_NULL.getName());
        }
        if ("NOT NULL".equalsIgnoreCase(literals)) {
            return Optional.of(SqlStdOperatorTable.IS_NOT_NULL.getName());
        }
        if ("FALSE".equalsIgnoreCase(literals)) {
            return Optional.of(SqlStdOperatorTable.IS_FALSE.getName());
        }
        if ("NOT FALSE".equalsIgnoreCase(literals)) {
            return Optional.of(SqlStdOperatorTable.IS_NOT_FALSE.getName());
        }
        if ("TRUE".equalsIgnoreCase(literals)) {
            return Optional.of(SqlStdOperatorTable.IS_TRUE.getName());
        }
        if ("NOT TRUE".equalsIgnoreCase(literals)) {
            return Optional.of(SqlStdOperatorTable.IS_NOT_TRUE.getName());
        }
        return Optional.empty();
    }

    private static Optional<String> findQuantifyOperator(String operator, QuantifySubqueryExpression quantifySubquery) {
        if ("=".equals(operator)) {
            return "ALL".equalsIgnoreCase(quantifySubquery.getQuantifyOperator()) ? Optional.of(SqlStdOperatorTable.ALL_EQ.getName()) : Optional.of(SqlStdOperatorTable.SOME_EQ.getName());
        }
        if (">".equals(operator)) {
            return "ALL".equalsIgnoreCase(quantifySubquery.getQuantifyOperator()) ? Optional.of(SqlStdOperatorTable.ALL_GT.getName()) : Optional.of(SqlStdOperatorTable.SOME_GT.getName());
        }
        if (">=".equals(operator)) {
            return "ALL".equalsIgnoreCase(quantifySubquery.getQuantifyOperator()) ? Optional.of(SqlStdOperatorTable.ALL_GE.getName()) : Optional.of(SqlStdOperatorTable.SOME_GE.getName());
        }
        if ("<".equals(operator)) {
            return "ALL".equalsIgnoreCase(quantifySubquery.getQuantifyOperator()) ? Optional.of(SqlStdOperatorTable.ALL_LT.getName()) : Optional.of(SqlStdOperatorTable.SOME_LT.getName());
        }
        if ("<=".equals(operator)) {
            return "ALL".equalsIgnoreCase(quantifySubquery.getQuantifyOperator()) ? Optional.of(SqlStdOperatorTable.ALL_LE.getName()) : Optional.of(SqlStdOperatorTable.SOME_LE.getName());
        }
        if ("!=".equals(operator) || "<>".equals(operator)) {
            return "ALL".equalsIgnoreCase(quantifySubquery.getQuantifyOperator()) ? Optional.of(SqlStdOperatorTable.ALL_NE.getName()) : Optional.of(SqlStdOperatorTable.SOME_NE.getName());
        }
        return Optional.empty();
    }

    private static List<SqlNode> convertSqlNodes(BinaryOperationExpression segment, SqlOperator operator) {
        SqlNode left = ExpressionConverter.convert(segment.getLeft()).orElseThrow(IllegalStateException::new);
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        result.add(left);
        if (SqlStdOperatorTable.IS_FALSE.equals((Object)operator) || SqlStdOperatorTable.IS_NOT_FALSE.equals((Object)operator) || SqlStdOperatorTable.IS_TRUE.equals((Object)operator) || SqlStdOperatorTable.IS_NOT_TRUE.equals((Object)operator)) {
            if (left instanceof SqlNumericLiteral) {
                result.remove(0);
                Long value = (Long)((SqlNumericLiteral)left).getValueAs(Long.class);
                result.add((SqlNode)(value == null || value == 0L ? SqlLiteral.createBoolean((boolean)false, (SqlParserPos)left.getParserPosition()) : SqlLiteral.createBoolean((boolean)true, (SqlParserPos)left.getParserPosition())));
            }
        } else if (!SqlStdOperatorTable.IS_NULL.equals((Object)operator) && !SqlStdOperatorTable.IS_NOT_NULL.equals((Object)operator)) {
            SqlNode right = ExpressionConverter.convert(segment.getRight()).orElseThrow(IllegalStateException::new);
            result.addAll(right instanceof SqlNodeList ? ((SqlNodeList)right).getList() : Collections.singletonList(right));
        }
        return result;
    }

    @Generated
    private BinaryOperationExpressionConverter() {
    }

    static {
        BinaryOperationExpressionConverter.register();
        BinaryOperationExpressionConverter.registerAlias();
    }
}

