/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.handshake;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdAcceptDataPacket
extends FirebirdPacket {
    private final byte[] salt;
    private final String publicKey;
    private final FirebirdAuthenticationMethod plugin;
    private final int authenticated;
    private final String keys;

    @Override
    protected void write(FirebirdPacketPayload payload) {
        if (this.salt.length != 0 && !this.publicKey.isEmpty()) {
            payload.writeInt4(this.salt.length + this.publicKey.length() + 4);
            payload.writeInt2LE(this.salt.length);
            payload.writeBytes(this.salt);
            payload.writeInt2LE(this.publicKey.length());
            payload.writeBytes(this.publicKey.getBytes(StandardCharsets.US_ASCII));
        } else {
            payload.writeInt4(0);
        }
        payload.writeString(this.plugin.getMethodName());
        payload.writeInt4(this.authenticated);
        payload.writeString(this.keys);
    }

    @Generated
    public FirebirdAcceptDataPacket(byte[] salt, String publicKey, FirebirdAuthenticationMethod plugin, int authenticated, String keys) {
        this.salt = salt;
        this.publicKey = publicKey;
        this.plugin = plugin;
        this.authenticated = authenticated;
        this.keys = keys;
    }

    @Generated
    public byte[] getSalt() {
        return this.salt;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public FirebirdAuthenticationMethod getPlugin() {
        return this.plugin;
    }

    @Generated
    public int getAuthenticated() {
        return this.authenticated;
    }

    @Generated
    public String getKeys() {
        return this.keys;
    }
}

