/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.transaction;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.FirebirdParameterBuffer;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.type.FirebirdTransactionParameterBufferType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;

public final class FirebirdStartTransactionPacket
extends FirebirdCommandPacket {
    private final int handle;
    private final FirebirdParameterBuffer tpb = FirebirdTransactionParameterBufferType.createBuffer();

    public FirebirdStartTransactionPacket(FirebirdPacketPayload payload) {
        payload.skipReserved(4);
        this.handle = payload.readInt4();
        this.tpb.parseBuffer(payload.readBuffer());
    }

    public boolean isAutoCommit() {
        return null != this.tpb.getValue(FirebirdTransactionParameterBufferType.AUTOCOMMIT);
    }

    public boolean isReadOnly() {
        return null != this.tpb.getValue(FirebirdTransactionParameterBufferType.READ);
    }

    public TransactionIsolationLevel getIsolationLevel() {
        if (null != this.tpb.getValue(FirebirdTransactionParameterBufferType.READ_COMMITTED)) {
            return TransactionIsolationLevel.READ_COMMITTED;
        }
        if (((Boolean)this.tpb.getValue(FirebirdTransactionParameterBufferType.CONCURRENCY)).booleanValue()) {
            return TransactionIsolationLevel.REPEATABLE_READ;
        }
        if (((Boolean)this.tpb.getValue(FirebirdTransactionParameterBufferType.CONSISTENCY)).booleanValue()) {
            return TransactionIsolationLevel.SERIALIZABLE;
        }
        return TransactionIsolationLevel.NONE;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdPacketPayload payload) {
        int length = 8;
        length += payload.getBufferLength(length);
        return length;
    }

    @Generated
    public int getHandle() {
        return this.handle;
    }

    @Generated
    public FirebirdParameterBuffer getTpb() {
        return this.tpb;
    }
}

