/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.util.FirebirdDateTimeUtils;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdTimestampBinaryProtocolValue
implements FirebirdBinaryProtocolValue {
    @Override
    public Object read(FirebirdPacketPayload payload) {
        return FirebirdDateTimeUtils.getDateTime(payload.readInt4(), payload.readInt4());
    }

    @Override
    public void write(FirebirdPacketPayload payload, Object value) {
        LocalDateTime localDateTime = value instanceof LocalDateTime ? (LocalDateTime)value : new Timestamp(((Date)value).getTime()).toLocalDateTime();
        payload.writeInt4(FirebirdDateTimeUtils.getEncodedDate(localDateTime));
        payload.writeInt4(new FirebirdDateTimeUtils(localDateTime).getEncodedTime());
    }

    @Override
    public int getLength(FirebirdPacketPayload payload) {
        return 8;
    }
}

