/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol;

import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.util.FirebirdDateTimeUtils;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdTimeBinaryProtocolValue
implements FirebirdBinaryProtocolValue {
    @Override
    public Object read(FirebirdPacketPayload payload) {
        return FirebirdDateTimeUtils.getTime(payload.readInt4());
    }

    @Override
    public void write(FirebirdPacketPayload payload, Object value) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Time)value).getTime()), ZoneId.systemDefault());
        payload.writeInt4(new FirebirdDateTimeUtils(localDateTime).getEncodedTime());
    }

    @Override
    public int getLength(FirebirdPacketPayload payload) {
        return 4;
    }
}

