/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.blob;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public enum FirebirdBlobInfoPacketType implements FirebirdInfoPacketType
{
    NUM_SEGMENTS(4),
    MAX_SEGMENT(5),
    TOTAL_LENGTH(6),
    TYPE(7);

    private static final Map<Integer, FirebirdBlobInfoPacketType> FIREBIRD_BLOB_INFO_TYPE_CACHE;
    private final int code;

    public static FirebirdBlobInfoPacketType valueOf(int code) {
        return FIREBIRD_BLOB_INFO_TYPE_CACHE.get(code);
    }

    public static FirebirdInfoPacket createPacket(FirebirdPacketPayload payload) {
        return new FirebirdInfoPacket(payload, FirebirdBlobInfoPacketType::valueOf);
    }

    @Override
    public boolean isCommon() {
        return false;
    }

    @Generated
    private FirebirdBlobInfoPacketType(int code) {
        this.code = code;
    }

    @Override
    @Generated
    public int getCode() {
        return this.code;
    }

    static {
        FIREBIRD_BLOB_INFO_TYPE_CACHE = new HashMap<Integer, FirebirdBlobInfoPacketType>();
        for (FirebirdBlobInfoPacketType each : FirebirdBlobInfoPacketType.values()) {
            FIREBIRD_BLOB_INFO_TYPE_CACHE.put(each.code, each);
        }
    }
}

