/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminUpdateExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetSetExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.session.SessionVariableRecordExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLResetParameterStatement;

public final class PostgreSQLResetVariableAdminExecutor
implements DatabaseAdminUpdateExecutor {
    private static final String DEFAULT = "DEFAULT";
    private final DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL");
    private final PostgreSQLResetParameterStatement resetParameterStatement;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        String variableName = this.resetParameterStatement.getConfigurationParameter();
        new CharsetSetExecutor(this.databaseType, connectionSession).set(variableName, DEFAULT);
        new SessionVariableRecordExecutor(this.databaseType, connectionSession).recordVariable(variableName, DEFAULT);
    }

    @Generated
    public PostgreSQLResetVariableAdminExecutor(PostgreSQLResetParameterStatement resetParameterStatement) {
        this.resetParameterStatement = resetParameterStatement;
    }
}

